/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.rust.cargo.toolchain.impl.ErrorCode;
import org.rust.cargo.toolchain.impl.RustcMessage;
import org.rust.ide.statistics.CargoErrorCodesCollectorKt;
import org.rust.ide.statistics.RsErrorCodeValidationRule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\rH\u0007R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/statistics/CargoErrorCodesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "ERROR_CODE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getERROR_CODE", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "ERROR_CODE_AFTER_BUILD", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "logErrorsAfterBuild", "", "project", "Lcom/intellij/openapi/project/Project;", "rustcErrorMessages", "", "Lorg/rust/cargo/toolchain/impl/RustcMessage;", "findErrorWithoutCodeToReport", "message", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoErrorCodesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoErrorCodesCollector.kt\norg/rust/ide/statistics/CargoErrorCodesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1265:1\n1869#2,2:1266\n1#3:1268\n*S KotlinDebug\n*F\n+ 1 CargoErrorCodesCollector.kt\norg/rust/ide/statistics/CargoErrorCodesCollector\n*L\n30#1:1266,2\n*E\n"})
public final class CargoErrorCodesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final CargoErrorCodesCollector INSTANCE = new CargoErrorCodesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("rust.cargo.build", 4, null, 4, null);
    @NotNull
    private static final StringEventField ERROR_CODE = EventFields.StringValidatedByCustomRule((String)"error_code", RsErrorCodeValidationRule.class);
    @NotNull
    private static final EventId1<String> ERROR_CODE_AFTER_BUILD = GROUP.registerEvent("error.emitted", (EventField)ERROR_CODE);

    private CargoErrorCodesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final StringEventField getERROR_CODE() {
        return ERROR_CODE;
    }

    public final void logErrorsAfterBuild(@NotNull Project project, @NotNull Collection<RustcMessage> rustcErrorMessages) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rustcErrorMessages, (String)"rustcErrorMessages");
        Iterable $this$forEach$iv = rustcErrorMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RustcMessage rustcMessage = (RustcMessage)element$iv;
            boolean bl = false;
            Object object = rustcMessage.getCode();
            if (object == null || (object = ((ErrorCode)object).getCode()) == null) {
                object = INSTANCE.findErrorWithoutCodeToReport(rustcMessage.getMessage());
            }
            ERROR_CODE_AFTER_BUILD.log(project, object);
        }
    }

    @VisibleForTesting
    @Nullable
    public final String findErrorWithoutCodeToReport(@NotNull String message) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Iterable iterable = CargoErrorCodesCollectorKt.getERRORS_WITHOUT_CODE_WITH_MESSAGES().entrySet();
            for (Object t : iterable) {
                Map.Entry it2 = (Map.Entry)t;
                boolean bl = false;
                if (!((Regex)it2.getValue()).matches((CharSequence)message)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry2 = v0;
        return entry2 != null ? (String)entry2.getKey() : null;
    }
}

