/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.spelling;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.utils.RsEscapesUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/rust/ide/spelling/StringLiteralTokenizer;", "Lcom/intellij/spellchecker/tokenizer/EscapeSequenceTokenizer;", "Lcom/intellij/psi/impl/source/tree/LeafPsiElement;", "<init>", "()V", "tokenize", "", "element", "consumer", "Lcom/intellij/spellchecker/tokenizer/TokenConsumer;", "processTextWithEscapeSequences", "text", "", "intellij.rustrover.core"})
public final class StringLiteralTokenizer
extends EscapeSequenceTokenizer<LeafPsiElement> {
    @NotNull
    public static final StringLiteralTokenizer INSTANCE = new StringLiteralTokenizer();

    private StringLiteralTokenizer() {
    }

    public void tokenize(@NotNull LeafPsiElement element, @NotNull TokenConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        if (!StringsKt.contains$default((CharSequence)text, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            consumer.consumeToken((PsiElement)element, (Splitter)PlainTextSplitter.getInstance());
        } else {
            this.processTextWithEscapeSequences(element, text, consumer);
        }
    }

    private final void processTextWithEscapeSequences(LeafPsiElement element, String text, TokenConsumer consumer) {
        Triple<StringBuilder, int[], Boolean> triple = RsEscapesUtilsKt.parseRustStringCharacters(text);
        StringBuilder unescapedText = (StringBuilder)triple.component1();
        int[] offsets = (int[])triple.component2();
        boolean success = (Boolean)triple.component3();
        if (success) {
            EscapeSequenceTokenizer.processTextWithOffsets((PsiElement)((PsiElement)element), (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)0);
        }
    }
}

