/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.spelling;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsRawIdentifiersKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/rust/ide/spelling/RsNameIdentifierOwnerTokenizer;", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lorg/rust/lang/core/psi/ext/RsNameIdentifierOwner;", "<init>", "()V", "tokenize", "", "element", "consumer", "Lcom/intellij/spellchecker/tokenizer/TokenConsumer;", "intellij.rustrover.core"})
public final class RsNameIdentifierOwnerTokenizer
extends Tokenizer<RsNameIdentifierOwner> {
    @NotNull
    public static final RsNameIdentifierOwnerTokenizer INSTANCE = new RsNameIdentifierOwnerTokenizer();

    private RsNameIdentifierOwnerTokenizer() {
    }

    public void tokenize(@NotNull RsNameIdentifierOwner element, @NotNull TokenConsumer consumer) {
        Pair pair;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        PsiElement psiElement3 = element.getNameIdentifier();
        if (psiElement3 == null) {
            return;
        }
        PsiElement identifier = psiElement3;
        TextRange range = identifier.getTextRange();
        if (range.isEmpty()) {
            return;
        }
        int offset = range.getStartOffset() - PsiElementKt.getStartOffset(element);
        if (offset < 0) {
            PsiElement psiElement4 = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element);
            if (psiElement4 == null) {
                return;
            }
            PsiElement commonParent = psiElement4;
            offset = range.getStartOffset() - PsiElementKt.getStartOffset(commonParent);
            psiElement2 = commonParent;
        } else {
            psiElement2 = element;
        }
        PsiElement parent2 = psiElement2;
        String text = identifier.getText();
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(identifier), (Object)RsElementTypes.QUOTE_IDENTIFIER)) {
            Intrinsics.checkNotNull((Object)text);
            pair = TuplesKt.to((Object)StringsKt.removePrefix((String)text, (CharSequence)"'"), (Object)1);
        } else {
            Intrinsics.checkNotNull((Object)text);
            pair = StringsKt.startsWith$default((String)text, (String)"r#", (boolean)false, (int)2, null) ? TuplesKt.to((Object)RsRawIdentifiersKt.unescapeIdentifier(text), (Object)2) : TuplesKt.to((Object)text, (Object)0);
        }
        Pair pair2 = pair;
        String unescapedText = (String)pair2.component1();
        int offsetShift = ((Number)pair2.component2()).intValue();
        consumer.consumeToken(parent2, unescapedText, true, offset += offsetShift, TextRange.allOf((String)unescapedText), (Splitter)IdentifierSplitter.getInstance());
    }
}

