/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.search;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.search.RsFindUsagesHandler;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsTraitItemKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/search/RsFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "<init>", "()V", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "findSecondaryElements", "", "findImplDeclarations", "Lorg/rust/lang/core/psi/ext/RsAbstractable;", "declaration", "askWhetherShouldSearchForUsagesOfSuperItem", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsFindUsagesHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsFindUsagesHandlerFactory.kt\norg/rust/ide/search/RsFindUsagesHandlerFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1617#2,9:66\n1869#2:75\n1870#2:77\n1626#2:78\n1#3:76\n*S KotlinDebug\n*F\n+ 1 RsFindUsagesHandlerFactory.kt\norg/rust/ide/search/RsFindUsagesHandlerFactory\n*L\n54#1:66,9\n54#1:75\n54#1:77\n54#1:78\n54#1:76\n*E\n"})
public final class RsFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof RsNamedElement;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<PsiElement> secondaryElements = !forHighlightUsages ? this.findSecondaryElements(element) : CollectionsKt.emptyList();
        return new RsFindUsagesHandler(element, secondaryElements);
    }

    private final List<PsiElement> findSecondaryElements(PsiElement element) {
        if (element instanceof RsModDeclItem) {
            RsFile resolvedFile;
            RsElement rsElement = ((RsModDeclItem)element).getReference().resolve();
            RsFile rsFile = resolvedFile = rsElement instanceof RsFile ? (RsFile)rsElement : null;
            if (resolvedFile != null) {
                return CollectionsKt.listOf((Object)resolvedFile);
            }
        }
        if (!(element instanceof RsAbstractable)) {
            return CollectionsKt.emptyList();
        }
        if (RsAbstractableKt.getOwner((RsAbstractable)element) instanceof RsAbstractableOwner.Trait) {
            return this.findImplDeclarations((RsAbstractable)element);
        }
        RsAbstractable rsAbstractable = RsAbstractableKt.getSuperItem((RsAbstractable)element);
        if (rsAbstractable == null) {
            return CollectionsKt.emptyList();
        }
        RsAbstractable superItem = rsAbstractable;
        Project project = ((RsAbstractable)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.askWhetherShouldSearchForUsagesOfSuperItem(project) ? CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)this.findImplDeclarations(superItem), (Object)element), (Object)superItem) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<RsAbstractable> findImplDeclarations(RsAbstractable declaration) {
        void $this$mapNotNullTo$iv$iv;
        RsAbstractableOwner rsAbstractableOwner = RsAbstractableKt.getOwner(declaration);
        Object object = rsAbstractableOwner instanceof RsAbstractableOwner.Trait ? (RsAbstractableOwner.Trait)rsAbstractableOwner : null;
        if (object == null || (object = ((RsAbstractableOwner.Trait)object).getTrait()) == null) {
            return CollectionsKt.emptyList();
        }
        Object trait = object;
        Iterable $this$mapNotNull$iv = RsTraitItemKt.searchForImplementations((RsTraitItem)trait).asIterable();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RsAbstractable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            RsImplItem it2 = (RsImplItem)element$iv$iv;
            boolean bl2 = false;
            if (RsAbstractableKt.findCorrespondingElement(it2, declaration) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean askWhetherShouldSearchForUsagesOfSuperItem(Project project) {
        return MessageUtil.showYesNoDialog$default((String)RsBundle.INSTANCE.message("dialog.title.find.usages", new Object[0]), (String)RsBundle.INSTANCE.message("dialog.message.do.you.want.to.find.usages.base.declaration", new Object[0]), (Project)project, null, null, (Icon)Messages.getQuestionIcon(), (int)24, null);
    }
}

