/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.suggested;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailability;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRenameData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.changeSignature.RsChangeSignatureHandler;
import org.rust.ide.refactoring.suggested.RsSuggestedRefactoringAvailabilityKt;
import org.rust.ide.refactoring.suggested.RsSuggestedRefactoringSupport;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMembers;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsPatBindingKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/refactoring/suggested/RsSuggestedRefactoringAvailability;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailability;", "support", "Lorg/rust/ide/refactoring/suggested/RsSuggestedRefactoringSupport;", "<init>", "(Lorg/rust/ide/refactoring/suggested/RsSuggestedRefactoringSupport;)V", "detectAvailableRefactoring", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringData;", "state", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "shouldSuppressRefactoringForDeclaration", "", "hasComplexChanges", "function", "Lorg/rust/lang/core/psi/RsFunction;", "oldSignature", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;", "newSignature", "intellij.rustrover.core"})
public final class RsSuggestedRefactoringAvailability
extends SuggestedRefactoringAvailability {
    public RsSuggestedRefactoringAvailability(@NotNull RsSuggestedRefactoringSupport support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        super((SuggestedRefactoringSupport)support);
    }

    @Nullable
    public SuggestedRefactoringData detectAvailableRefactoring(@NotNull SuggestedRefactoringState state) {
        RsFunction function;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PsiElement psiElement2 = state.getDeclaration();
        RsFunction rsFunction = function = psiElement2 instanceof RsFunction ? (RsFunction)psiElement2 : null;
        if (function != null && this.hasComplexChanges(function, state.getOldSignature(), state.getNewSignature())) {
            String string = function.getName();
            if (string == null) {
                string = "";
            }
            return (SuggestedRefactoringData)SuggestedChangeSignatureData.Companion.create(state, string);
        }
        PsiElement psiElement3 = state.getDeclaration();
        PsiNamedElement psiNamedElement = psiElement3 instanceof PsiNamedElement ? (PsiNamedElement)psiElement3 : null;
        if (psiNamedElement == null) {
            return null;
        }
        PsiNamedElement namedElement = psiNamedElement;
        return (SuggestedRefactoringData)new SuggestedRenameData(namedElement, state.getOldSignature().getName());
    }

    public boolean shouldSuppressRefactoringForDeclaration(@NotNull SuggestedRefactoringState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PsiElement psiElement2 = state.getDeclaration();
        if (psiElement2 instanceof RsFunction) {
            PsiElement psiElement3 = state.restoredDeclarationCopy();
            RsFunction rsFunction = psiElement3 instanceof RsFunction ? (RsFunction)psiElement3 : null;
            if (rsFunction == null) {
                return false;
            }
            RsFunction function = rsFunction;
            bl = !RsChangeSignatureHandler.Companion.isChangeSignatureAvailable(function);
        } else if (psiElement2 instanceof RsPatBinding) {
            PsiElement psiElement4 = state.restoredDeclarationCopy();
            RsPatBinding rsPatBinding = psiElement4 instanceof RsPatBinding ? (RsPatBinding)psiElement4 : null;
            if (rsPatBinding == null) {
                return false;
            }
            RsPatBinding binding = rsPatBinding;
            bl = RsPatBindingKt.isReferenceToConstant(binding);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean hasComplexChanges(RsFunction function, SuggestedRefactoringSupport.Signature oldSignature, SuggestedRefactoringSupport.Signature newSignature) {
        if (this.hasParameterAddedRemovedOrReordered(oldSignature, newSignature)) {
            return true;
        }
        if (function.getParent() instanceof RsMembers) {
            PsiElement psiElement2 = function.getParent();
            if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof RsTraitItem && this.hasTypeChanges(oldSignature, newSignature)) {
                return true;
            }
        }
        return RsSuggestedRefactoringAvailabilityKt.access$hasNameChanges(oldSignature, newSignature);
    }
}

