/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.move.common;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.move.common.ElementToMove;
import org.rust.ide.refactoring.move.common.ItemToMove;
import org.rust.ide.refactoring.move.common.ModToMove;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsCodeFragment;
import org.rust.lang.core.psi.RsCodeFragmentFactory;
import org.rust.lang.core.psi.RsModItem;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeArgumentList;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsModKt;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.psi.ext.RsVisibilityKt;
import org.rust.lang.core.psi.ext.RsVisible;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.stubs.common.RsPathPsiOrStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0005J\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0005J\n\u0010\u0012\u001a\u00020\u0010*\u00020\u0005J\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u001c\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eJ\n\u0010\u001f\u001a\u00020\u0010*\u00020\u0005J\u0012\u0010#\u001a\u00020$*\u00020\u000e2\u0006\u0010%\u001a\u00020$J\u0018\u0010&\u001a\u00020\u0010*\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(R\u0015\u0010\u0014\u001a\u00020\u0006*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010 \u001a\u00020\u000e*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0010\u0010*\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/rust/ide/refactoring/move/common/RsMoveUtil;", "", "<init>", "()V", "toRsPath", "Lorg/rust/lang/core/psi/RsPath;", "", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "codeFragmentFactory", "Lorg/rust/lang/core/psi/RsCodeFragmentFactory;", "context", "Lorg/rust/lang/core/psi/ext/RsElement;", "toRsPathInEmptyTmpMod", "Lorg/rust/lang/core/psi/ext/RsMod;", "isAbsolute", "", "startsWithSuper", "startsWithSelf", "startsWithCSelf", "textNormalized", "getTextNormalized", "(Lorg/rust/lang/core/psi/RsPath;)Ljava/lang/String;", "isSimplePath", "path", "convertFromPathOriginal", "pathOriginal", "removeTypeArguments", "resolvesToAndAccessible", "target", "Lorg/rust/lang/core/psi/ext/RsQualifiedNamedElement;", "isTargetOfEachSubpathAccessible", "containingModStrict", "getContainingModStrict", "(Lorg/rust/lang/core/psi/ext/RsElement;)Lorg/rust/lang/core/psi/ext/RsMod;", "addInner", "Lcom/intellij/psi/PsiElement;", "element", "isInsideMovedElements", "elementsToMove", "", "Lorg/rust/ide/refactoring/move/common/ElementToMove;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMoveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMoveUtil.kt\norg/rust/ide/refactoring/move/common/RsMoveUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,304:1\n1232#2,2:305\n1761#3,3:307\n13#4:310\n*S KotlinDebug\n*F\n+ 1 RsMoveUtil.kt\norg/rust/ide/refactoring/move/common/RsMoveUtil\n*L\n154#1:305,2\n221#1:307,3\n230#1:310\n*E\n"})
public final class RsMoveUtil {
    @NotNull
    public static final RsMoveUtil INSTANCE = new RsMoveUtil();
    @JvmField
    @NotNull
    public static final Logger LOG;

    private RsMoveUtil() {
    }

    @Nullable
    public final RsPath toRsPath(@NotNull String $this$toRsPath, @NotNull RsPsiFactory psiFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$toRsPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
        RsPath rsPath = RsPsiFactory.tryCreatePath$default(psiFactory, $this$toRsPath, null, 2, null);
        if (rsPath == null) {
            String $this$toRsPath_u24lambda_u240 = $this$toRsPath;
            boolean bl = false;
            LOG.error("Can't create RsPath from '" + $this$toRsPath_u24lambda_u240 + "'");
            rsPath = null;
        }
        return rsPath;
    }

    @Nullable
    public final RsPath toRsPath(@NotNull String $this$toRsPath, @NotNull RsCodeFragmentFactory codeFragmentFactory, @NotNull RsElement context) {
        Intrinsics.checkNotNullParameter((Object)$this$toRsPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)codeFragmentFactory, (String)"codeFragmentFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RsPath rsPath = RsCodeFragmentFactory.createPath$default(codeFragmentFactory, $this$toRsPath, context, null, null, 12, null);
        if (rsPath == null) {
            String $this$toRsPath_u24lambda_u241 = $this$toRsPath;
            boolean bl = false;
            LOG.error("Can't create RsPath from '" + $this$toRsPath_u24lambda_u241 + "' in context " + context);
            rsPath = null;
        }
        return rsPath;
    }

    @Nullable
    public final RsPath toRsPathInEmptyTmpMod(@NotNull String $this$toRsPathInEmptyTmpMod, @NotNull RsCodeFragmentFactory codeFragmentFactory, @NotNull RsPsiFactory psiFactory, @NotNull RsMod context) {
        Intrinsics.checkNotNullParameter((Object)$this$toRsPathInEmptyTmpMod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)codeFragmentFactory, (String)"codeFragmentFactory");
        Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RsModItem mod = psiFactory.createModItem("__tmp__", "");
        RsExpandedElementKt.setContext(mod, context);
        return this.toRsPath($this$toRsPathInEmptyTmpMod, codeFragmentFactory, mod);
    }

    public final boolean isAbsolute(@NotNull RsPath $this$isAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbsolute, (String)"<this>");
        if (((RsPath)RsPathKt.basePath((RsPathPsiOrStub)$this$isAbsolute)).getHasColonColon()) {
            return true;
        }
        if (this.startsWithSuper($this$isAbsolute)) {
            return false;
        }
        if ($this$isAbsolute.getContainingFile() instanceof DummyHolder) {
            LOG.error("Path '" + $this$isAbsolute.getText() + "' is inside dummy holder");
        }
        RsPathReference rsPathReference = ((RsPath)RsPathKt.basePath((RsPathPsiOrStub)$this$isAbsolute)).getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsMod rsMod = rsElement instanceof RsMod ? (RsMod)rsElement : null;
        if (rsMod == null) {
            return false;
        }
        RsMod basePathTarget = rsMod;
        return basePathTarget.isCrateRoot();
    }

    public final boolean startsWithSuper(@NotNull RsPath $this$startsWithSuper) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWithSuper, (String)"<this>");
        return Intrinsics.areEqual((Object)((RsPath)RsPathKt.basePath((RsPathPsiOrStub)$this$startsWithSuper)).getReferenceName(), (Object)"super");
    }

    public final boolean startsWithSelf(@NotNull RsPath $this$startsWithSelf) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWithSelf, (String)"<this>");
        return Intrinsics.areEqual((Object)((RsPath)RsPathKt.basePath((RsPathPsiOrStub)$this$startsWithSelf)).getReferenceName(), (Object)"self");
    }

    private final boolean startsWithCSelf(RsPath $this$startsWithCSelf) {
        return Intrinsics.areEqual((Object)((RsPath)RsPathKt.basePath((RsPathPsiOrStub)$this$startsWithCSelf)).getReferenceName(), (Object)"Self");
    }

    @NotNull
    public final String getTextNormalized(@NotNull RsPath $this$textNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$textNormalized, (String)"<this>");
        Object[] objectArray = new String[3];
        RsPath rsPath = $this$textNormalized.getPath();
        objectArray[0] = rsPath != null ? this.getTextNormalized(rsPath) : null;
        PsiElement psiElement2 = $this$textNormalized.getColoncolon();
        objectArray[1] = psiElement2 != null ? psiElement2.getText() : null;
        objectArray[2] = $this$textNormalized.getReferenceName();
        List parts = CollectionsKt.listOfNotNull((Object[])objectArray);
        return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean isSimplePath(@NotNull RsPath path) {
        boolean bl;
        block4: {
            Sequence subpaths;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (this.startsWithSelf(path) || this.startsWithCSelf(path)) {
                return false;
            }
            Object object = path.getReference();
            if (object == null || (object = object.resolve()) == null) {
                return false;
            }
            Object target = object;
            if (target instanceof RsMod && path.getParent() instanceof RsPath) {
                return false;
            }
            Sequence $this$all$iv = subpaths = SequencesKt.generateSequence((Object)path.getPath(), RsMoveUtil::isSimplePath$lambda$0);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                RsPath it2 = (RsPath)element$iv;
                boolean bl2 = false;
                RsPathReference rsPathReference = it2.getReference();
                if ((rsPathReference != null ? rsPathReference.resolve() : null) instanceof RsMod) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final RsPath convertFromPathOriginal(@NotNull RsElement pathOriginal, @NotNull RsCodeFragmentFactory codeFragmentFactory) {
        RsPath rsPath;
        Intrinsics.checkNotNullParameter((Object)pathOriginal, (String)"pathOriginal");
        Intrinsics.checkNotNullParameter((Object)codeFragmentFactory, (String)"codeFragmentFactory");
        RsElement rsElement = pathOriginal;
        if (rsElement instanceof RsPath) {
            rsPath = this.removeTypeArguments((RsPath)pathOriginal, codeFragmentFactory);
        } else if (rsElement instanceof RsPatIdent) {
            PsiElement psiElement2 = ((RsPatIdent)pathOriginal).getContext();
            RsElement rsElement2 = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
            if (rsElement2 == null) {
                rsElement2 = pathOriginal;
            }
            RsElement context = rsElement2;
            String string = ((RsPatIdent)pathOriginal).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            RsPath rsPath2 = RsCodeFragmentFactory.createPath$default(codeFragmentFactory, string, context, null, null, 12, null);
            rsPath = rsPath2;
            Intrinsics.checkNotNull((Object)rsPath2);
        } else {
            throw new IllegalStateException(("unexpected pathOriginal: " + pathOriginal + ", text=" + pathOriginal.getText()).toString());
        }
        return rsPath;
    }

    private final RsPath removeTypeArguments(RsPath $this$removeTypeArguments, RsCodeFragmentFactory codeFragmentFactory) {
        if ($this$removeTypeArguments.getTypeArgumentList() == null) {
            return $this$removeTypeArguments;
        }
        PsiElement psiElement2 = $this$removeTypeArguments.copy();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsPath");
        RsPath pathCopy = (RsPath)psiElement2;
        RsTypeArgumentList rsTypeArgumentList = pathCopy.getTypeArgumentList();
        if (rsTypeArgumentList != null) {
            rsTypeArgumentList.delete();
        }
        PsiElement psiElement3 = $this$removeTypeArguments.getContext();
        RsElement rsElement = psiElement3 instanceof RsElement ? (RsElement)psiElement3 : null;
        if (rsElement == null) {
            rsElement = $this$removeTypeArguments;
        }
        RsElement context = rsElement;
        String string = pathCopy.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        RsPath rsPath = this.toRsPath(string, codeFragmentFactory, context);
        if (rsPath == null) {
            rsPath = $this$removeTypeArguments;
        }
        return rsPath;
    }

    public final boolean resolvesToAndAccessible(@NotNull RsPath $this$resolvesToAndAccessible, @NotNull RsQualifiedNamedElement target) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvesToAndAccessible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if ($this$resolvesToAndAccessible.getContainingFile() instanceof DummyHolder) {
            LOG.error("Path '" + $this$resolvesToAndAccessible.getText() + "' is inside dummy holder");
        }
        if (target.getContainingFile() instanceof DummyHolder) {
            LOG.error("Target " + target + " of path '" + $this$resolvesToAndAccessible.getText() + "' is inside dummy holder");
        }
        RsPathReference rsPathReference = $this$resolvesToAndAccessible.getReference();
        if (rsPathReference == null) {
            return false;
        }
        RsPathReference reference = rsPathReference;
        if (!reference.isReferenceTo(target)) {
            return false;
        }
        return this.isTargetOfEachSubpathAccessible($this$resolvesToAndAccessible);
    }

    public final boolean isTargetOfEachSubpathAccessible(@NotNull RsPath $this$isTargetOfEachSubpathAccessible) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetOfEachSubpathAccessible, (String)"<this>");
        for (RsPath subpath : SequencesKt.generateSequence((Object)$this$isTargetOfEachSubpathAccessible, RsMoveUtil::isTargetOfEachSubpathAccessible$lambda$0)) {
            RsVisible subpathTarget;
            RsPathReference rsPathReference = subpath.getReference();
            RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
            RsVisible rsVisible = rsElement instanceof RsVisible ? (RsVisible)rsElement : null;
            if (rsVisible == null || RsVisibilityKt.isVisibleFrom(subpathTarget = rsVisible, $this$isTargetOfEachSubpathAccessible.getContainingMod())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final RsMod getContainingModStrict(@NotNull RsElement $this$containingModStrict) {
        RsMod rsMod;
        Intrinsics.checkNotNullParameter((Object)$this$containingModStrict, (String)"<this>");
        if ($this$containingModStrict instanceof RsMod) {
            rsMod = ((RsMod)$this$containingModStrict).getSuper();
            if (rsMod == null) {
                rsMod = (RsMod)$this$containingModStrict;
            }
        } else {
            rsMod = $this$containingModStrict.getContainingMod();
        }
        return rsMod;
    }

    @NotNull
    public final PsiElement addInner(@NotNull RsMod $this$addInner, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$addInner, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = $this$addInner.addBefore(element, $this$addInner instanceof RsModItem ? ((RsModItem)$this$addInner).getRbrace() : null);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"addBefore(...)");
        return psiElement2;
    }

    public final boolean isInsideMovedElements(@NotNull RsElement $this$isInsideMovedElements, @NotNull List<? extends ElementToMove> elementsToMove) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$isInsideMovedElements, (String)"<this>");
            Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
            if ($this$isInsideMovedElements.getContainingFile() instanceof RsCodeFragment) {
                LOG.error("Unexpected containingFile: " + $this$isInsideMovedElements.getContainingFile());
            }
            Iterable $this$any$iv = elementsToMove;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ElementToMove it2 = (ElementToMove)element$iv;
                    boolean bl3 = false;
                    ElementToMove elementToMove = it2;
                    if (elementToMove instanceof ItemToMove) {
                        bl2 = PsiTreeUtil.isAncestor((PsiElement)((ItemToMove)it2).getItem(), (PsiElement)$this$isInsideMovedElements, (boolean)false);
                    } else if (elementToMove instanceof ModToMove) {
                        bl2 = RsModKt.getSuperMods(RsElementKt.getContainingModOrSelf($this$isInsideMovedElements)).contains(((ModToMove)it2).getMod());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final RsPath isSimplePath$lambda$0(RsPath it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getPath();
    }

    private static final RsPath isTargetOfEachSubpathAccessible$lambda$0(RsPath it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getPath();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsMoveUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

