/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.move.common;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.refactoring.RsImportOptimizer;
import org.rust.ide.refactoring.move.common.RsMoveReferenceInfo;
import org.rust.ide.refactoring.move.common.RsMoveUtil;
import org.rust.ide.refactoring.move.common.RsMoveUtilKt;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.core.psi.RsCodeFragmentFactory;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsUseGroup;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsItemsOwner;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.psi.ext.RsUseGroupKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.stubs.common.RsPathPsiOrStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J&\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001bH\u0002J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0002J\"\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001b2\b\u00102\u001a\u0004\u0018\u00010\u001bH\u0002J\u0006\u00103\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/rust/ide/refactoring/move/common/RsMoveRetargetReferencesProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceMod", "Lorg/rust/lang/core/psi/ext/RsMod;", "targetMod", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/lang/core/psi/ext/RsMod;Lorg/rust/lang/core/psi/ext/RsMod;)V", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "codeFragmentFactory", "Lorg/rust/lang/core/psi/RsCodeFragmentFactory;", "filesToOptimizeImports", "", "Lorg/rust/lang/core/psi/RsFile;", "retargetReferences", "", "referencesAll", "", "Lorg/rust/ide/refactoring/move/common/RsMoveReferenceInfo;", "retargetReferenceDirectly", "reference", "tryRetargetReferenceKeepExistingStyle", "", "doRetargetReferenceKeepExistingStyle", "pathNewSegments", "", "pathNewShortNumberSegments", "", "adjustPathNewNumberSegments", "numberSegments", "replacePathOld", "pathNew", "Lorg/rust/lang/core/psi/RsPath;", "replacePathOldInPatIdent", "pathOldOriginal", "Lorg/rust/lang/core/psi/RsPatIdent;", "replacePathOldWithTypeArguments", "pathNewText", "tryReplacePathOldInUseGroup", "pathOld", "insertUseItemAndCopyAttributes", "useSpeckText", "existingUseItem", "Lorg/rust/lang/core/psi/RsUseItem;", "addImport", "context", "Lorg/rust/lang/core/psi/ext/RsElement;", "usePath", "alias", "optimizeImports", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMoveRetargetReferencesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMoveRetargetReferencesProcessor.kt\norg/rust/ide/refactoring/move/common/RsMoveRetargetReferencesProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,249:1\n3301#2,10:250\n1869#2,2:263\n1#3:260\n9#4:261\n9#4:262\n*S KotlinDebug\n*F\n+ 1 RsMoveRetargetReferencesProcessor.kt\norg/rust/ide/refactoring/move/common/RsMoveRetargetReferencesProcessor\n*L\n35#1:250,10\n246#1:263,2\n199#1:261\n201#1:262\n*E\n"})
public final class RsMoveRetargetReferencesProcessor {
    @NotNull
    private final RsMod sourceMod;
    @NotNull
    private final RsMod targetMod;
    @NotNull
    private final RsPsiFactory psiFactory;
    @NotNull
    private final RsCodeFragmentFactory codeFragmentFactory;
    @NotNull
    private final Set<RsFile> filesToOptimizeImports;

    public RsMoveRetargetReferencesProcessor(@NotNull Project project, @NotNull RsMod sourceMod, @NotNull RsMod targetMod) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceMod, (String)"sourceMod");
        Intrinsics.checkNotNullParameter((Object)targetMod, (String)"targetMod");
        this.sourceMod = sourceMod;
        this.targetMod = targetMod;
        this.psiFactory = new RsPsiFactory(project, false, false, 6, null);
        this.codeFragmentFactory = new RsCodeFragmentFactory(project);
        Object[] objectArray = new RsFile[2];
        Intrinsics.checkNotNull((Object)this.sourceMod.getContainingFile(), (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFile");
        Intrinsics.checkNotNull((Object)this.targetMod.getContainingFile(), (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFile");
        this.filesToOptimizeImports = SetsKt.mutableSetOf((Object[])objectArray);
    }

    public final void retargetReferences(@NotNull List<RsMoveReferenceInfo> referencesAll) {
        Intrinsics.checkNotNullParameter(referencesAll, (String)"referencesAll");
        Iterable $this$partition$iv = referencesAll;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            RsMoveReferenceInfo it2 = (RsMoveReferenceInfo)element$iv;
            boolean bl = false;
            boolean bl2 = it2.isInsideUseDirective() || it2.getForceReplaceDirectly() ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List referencesDirectly = (List)pair.component1();
        List referencesOther = (List)pair.component2();
        for (RsMoveReferenceInfo reference : referencesDirectly) {
            this.retargetReferenceDirectly(reference);
        }
        for (RsMoveReferenceInfo reference : referencesOther) {
            boolean success;
            RsPath pathOld = reference.getPathOld();
            if (RsMoveUtil.INSTANCE.resolvesToAndAccessible(pathOld, reference.getTarget()) || (success = !RsMoveUtil.INSTANCE.isAbsolute(pathOld) && this.tryRetargetReferenceKeepExistingStyle(reference))) continue;
            this.retargetReferenceDirectly(reference);
        }
    }

    private final void retargetReferenceDirectly(RsMoveReferenceInfo reference) {
        RsPath rsPath = reference.getPathNew();
        if (rsPath == null) {
            return;
        }
        RsPath pathNew = rsPath;
        this.replacePathOld(reference, pathNew);
    }

    private final boolean tryRetargetReferenceKeepExistingStyle(RsMoveReferenceInfo reference) {
        RsPath pathOld = reference.getPathOld();
        RsPath rsPath = reference.getPathNew();
        if (rsPath == null) {
            return false;
        }
        RsPath pathNew = rsPath;
        String[] stringArray = new String[]{"::"};
        List pathOldSegments = StringsKt.split$default((CharSequence)RsMoveUtil.INSTANCE.getTextNormalized(pathOld), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"::"};
        List pathNewSegments = StringsKt.split$default((CharSequence)RsMoveUtil.INSTANCE.getTextNormalized(pathNew), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int pathNewShortNumberSegments = this.adjustPathNewNumberSegments(reference, pathOldSegments.size());
        return this.doRetargetReferenceKeepExistingStyle(reference, pathNewSegments, pathNewShortNumberSegments);
    }

    private final boolean doRetargetReferenceKeepExistingStyle(RsMoveReferenceInfo reference, List<String> pathNewSegments, int pathNewShortNumberSegments) {
        RsElement elementToImport;
        Object object;
        RsPath rsPath;
        Object object2;
        if (pathNewShortNumberSegments >= pathNewSegments.size()) {
            return false;
        }
        String pathNewShortText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast(pathNewSegments, (int)pathNewShortNumberSegments), (CharSequence)"::", null, null, (int)0, null, null, (int)62, null);
        String usePath = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)pathNewSegments, (int)(pathNewSegments.size() - pathNewShortNumberSegments + 1)), (CharSequence)"::", null, null, (int)0, null, null, (int)62, null);
        Object it2 = object2 = reference.getPathOld();
        boolean bl = false;
        RsPath rsPath2 = rsPath = it2.getColoncolon() == null && pathNewShortNumberSegments == 1 ? object2 : null;
        if (rsPath != null && (object2 = rsPath.getReferenceName()) != null) {
            Object it3 = it2 = object2;
            boolean bl2 = false;
            object = !Intrinsics.areEqual((Object)it3, (Object)pathNewShortText) ? it2 : null;
        } else {
            object = null;
        }
        String alias = object;
        RsMod containingMod = reference.getPathOldOriginal().getContainingMod();
        String string = alias;
        if (string == null) {
            string = pathNewShortText;
        }
        RsPath rsPath3 = RsMoveUtil.INSTANCE.toRsPath(string, this.codeFragmentFactory, containingMod);
        if (rsPath3 == null) {
            return false;
        }
        RsPath pathNewShort = rsPath3;
        RsPathReference rsPathReference = ((RsPath)RsPathKt.basePath((RsPathPsiOrStub)pathNewShort)).getReference();
        RsElement it4 = rsPathReference != null ? rsPathReference.resolve() : null;
        boolean bl3 = false;
        Object object3 = RsMoveUtil.INSTANCE.toRsPath(usePath, this.codeFragmentFactory, containingMod);
        RsElement rsElement = object3 != null && (object3 = object3.getReference()) != null ? object3.resolve() : (elementToImport = null);
        boolean bl4 = it4 != null && !Intrinsics.areEqual((Object)it4, (Object)elementToImport) && elementToImport != null;
        boolean containingModHasSameNameInScope = bl4;
        if (containingModHasSameNameInScope) {
            return this.doRetargetReferenceKeepExistingStyle(reference, pathNewSegments, pathNewShortNumberSegments + 1);
        }
        this.addImport(reference.getPathOldOriginal(), usePath, alias);
        this.replacePathOld(reference, pathNewShort);
        return true;
    }

    private final int adjustPathNewNumberSegments(RsMoveReferenceInfo reference, int numberSegments) {
        RsElement pathOldOriginal = reference.getPathOldOriginal();
        RsQualifiedNamedElement target = reference.getTarget();
        if (RsMoveUtil.INSTANCE.startsWithSuper(reference.getPathOld())) {
            return target instanceof RsFunction ? 2 : 1;
        }
        if (numberSegments != 1 || !(target instanceof RsFunction)) {
            return numberSegments;
        }
        boolean isReferenceBetweenElementsInSourceMod = Intrinsics.areEqual((Object)pathOldOriginal.getContainingMod(), (Object)this.sourceMod) && Intrinsics.areEqual((Object)RsMoveUtil.INSTANCE.getContainingModStrict(target), (Object)this.targetMod) || Intrinsics.areEqual((Object)pathOldOriginal.getContainingMod(), (Object)this.targetMod) && Intrinsics.areEqual((Object)RsMoveUtil.INSTANCE.getContainingModStrict(target), (Object)this.sourceMod);
        return isReferenceBetweenElementsInSourceMod ? 2 : numberSegments;
    }

    private final void replacePathOld(RsMoveReferenceInfo reference, RsPath pathNew) {
        RsPath pathOld = reference.getPathOld();
        RsElement pathOldOriginal = reference.getPathOldOriginal();
        if (!(pathOldOriginal instanceof RsPath)) {
            Intrinsics.checkNotNull((Object)pathOldOriginal, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsPatIdent");
            this.replacePathOldInPatIdent((RsPatIdent)pathOldOriginal, pathNew);
            return;
        }
        if (this.tryReplacePathOldInUseGroup((RsPath)pathOldOriginal, pathNew)) {
            return;
        }
        if (Intrinsics.areEqual((Object)RsMoveUtil.INSTANCE.getTextNormalized(pathOld), (Object)RsMoveUtil.INSTANCE.getTextNormalized(pathNew))) {
            return;
        }
        if (!Intrinsics.areEqual((Object)pathOld, (Object)pathOldOriginal)) {
            RsMoveRetargetReferencesProcessor $this$replacePathOld_u24lambda_u240 = this;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)RsMoveUtil.INSTANCE.getTextNormalized((RsPath)pathOldOriginal), (String)RsMoveUtil.INSTANCE.getTextNormalized(pathOld), (boolean)false, (int)2, null)) {
                RsMoveUtil.LOG.error("Expected '" + ((RsPath)pathOldOriginal).getText() + "' to start with '" + pathOld.getText() + "'");
            } else if ($this$replacePathOld_u24lambda_u240.replacePathOldWithTypeArguments((RsPath)pathOldOriginal, RsMoveUtil.INSTANCE.getTextNormalized(pathNew))) {
                return;
            }
        }
        if (pathOld.getParent() instanceof RsUseSpeck && pathOld.getParent().getParent() instanceof RsUseItem && !pathNew.getHasColonColon()) {
            pathOld.getParent().getParent().delete();
            return;
        }
        pathOldOriginal.replace(pathNew);
    }

    private final void replacePathOldInPatIdent(RsPatIdent pathOldOriginal, RsPath pathNew) {
        if (pathNew.getColoncolon() != null) {
            RsMoveUtil.LOG.error("Expected paths in patIdent to be one-segment, got: '" + pathNew.getText() + "'");
            return;
        }
        String string = pathNew.getReferenceName();
        if (string == null) {
            throw new IllegalStateException("Generated paths can't be incomplete".toString());
        }
        String referenceName = string;
        PsiElement patBindingNew = this.psiFactory.createIdentifier(referenceName);
        pathOldOriginal.getPatBinding().getIdentifier().replace(patBindingNew);
    }

    private final boolean replacePathOldWithTypeArguments(RsPath pathOldOriginal, String pathNewText) {
        RsPath $this$replacePathOldWithTypeArguments_u24lambda_u240 = pathOldOriginal;
        boolean bl = false;
        if (!($this$replacePathOldWithTypeArguments_u24lambda_u240.getTypeArgumentList() != null)) {
            throw new IllegalStateException("Check failed.");
        }
        RsPath rsPath = $this$replacePathOldWithTypeArguments_u24lambda_u240.getPath();
        if (rsPath != null) {
            rsPath.delete();
        }
        PsiElement psiElement2 = $this$replacePathOldWithTypeArguments_u24lambda_u240.getColoncolon();
        if (psiElement2 != null) {
            psiElement2.delete();
        }
        PsiElement psiElement3 = $this$replacePathOldWithTypeArguments_u24lambda_u240.getReferenceNameElement();
        if (psiElement3 != null) {
            psiElement3.delete();
        }
        if (!($this$replacePathOldWithTypeArguments_u24lambda_u240.getTypeArgumentList() != null)) {
            throw new IllegalStateException("Check failed.");
        }
        RsPath rsPath2 = RsMoveUtil.INSTANCE.toRsPath(pathNewText, this.psiFactory);
        if (rsPath2 == null) {
            return false;
        }
        RsPath pathNew = rsPath2;
        PsiElement[] psiElementArray = new PsiElement[]{pathNew.getPath(), pathNew.getColoncolon(), pathNew.getReferenceNameElement()};
        List elements2 = CollectionsKt.listOfNotNull((Object[])psiElementArray);
        for (PsiElement element : CollectionsKt.asReversed((List)elements2)) {
            pathOldOriginal.addAfter(element, null);
        }
        if (!StringsKt.startsWith$default((String)RsMoveUtil.INSTANCE.getTextNormalized(pathOldOriginal), (String)pathNewText, (boolean)false, (int)2, null)) {
            RsMoveUtil.LOG.error("Expected '" + pathOldOriginal.getText() + "' to start with '" + pathNewText + "'");
        }
        return true;
    }

    private final boolean tryReplacePathOldInUseGroup(RsPath pathOld, RsPath pathNew) {
        PsiElement $this$ancestorStrict$iv = pathOld;
        boolean $i$f$ancestorStrict22 = false;
        RsUseSpeck rsUseSpeck = (RsUseSpeck)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsUseSpeck.class, (boolean)true);
        if (rsUseSpeck == null) {
            return false;
        }
        RsUseSpeck useSpeck = rsUseSpeck;
        PsiElement $i$f$ancestorStrict22 = useSpeck.getParent();
        RsUseGroup rsUseGroup = $i$f$ancestorStrict22 instanceof RsUseGroup ? (RsUseGroup)$i$f$ancestorStrict22 : null;
        if (rsUseGroup == null) {
            return false;
        }
        RsUseGroup useGroup = rsUseGroup;
        PsiElement $this$ancestorStrict$iv2 = useGroup;
        boolean $i$f$ancestorStrict = false;
        RsUseItem rsUseItem = (RsUseItem)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv2, RsUseItem.class, (boolean)true);
        if (rsUseItem == null) {
            return false;
        }
        RsUseItem useItem = rsUseItem;
        pathOld.replace(pathNew);
        String useSpeckText = useSpeck.getText();
        RsElementKt.deleteWithSurroundingComma(useSpeck);
        Intrinsics.checkNotNull((Object)useSpeckText);
        if (StringsKt.contains$default((CharSequence)useSpeckText, (CharSequence)"::", (boolean)false, (int)2, null)) {
            this.insertUseItemAndCopyAttributes(useSpeckText, useItem);
        }
        RsUseSpeck it2 = RsUseGroupKt.getParentUseSpeck(useGroup);
        boolean bl = false;
        Collection collection = this.filesToOptimizeImports;
        PsiFile psiFile = it2.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFile");
        collection.add((RsFile)psiFile);
        return true;
    }

    private final void insertUseItemAndCopyAttributes(String useSpeckText, RsUseItem existingUseItem) {
        RsMod containingMod = existingUseItem.getContainingMod();
        PsiElement psiElement2 = existingUseItem.copy();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsUseItem");
        RsUseItem useItem = (RsUseItem)psiElement2;
        RsUseSpeck useSpeck = this.psiFactory.createUseSpeck(useSpeckText);
        RsUseSpeck rsUseSpeck = useItem.getUseSpeck();
        Intrinsics.checkNotNull((Object)rsUseSpeck);
        rsUseSpeck.replace(useSpeck);
        ImportUtilsKt.insertUseItem((RsItemsOwner)containingMod, this.psiFactory, useItem);
        PsiFile psiFile = containingMod.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFile");
        this.filesToOptimizeImports.add((RsFile)psiFile);
    }

    private final void addImport(RsElement context, String usePath, String alias) {
        RsMoveUtilKt.addImport(this.psiFactory, context, usePath, alias);
        PsiFile psiFile = context.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFile");
        this.filesToOptimizeImports.add((RsFile)psiFile);
    }

    public final void optimizeImports() {
        Iterable $this$forEach$iv = this.filesToOptimizeImports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RsFile it2 = (RsFile)element$iv;
            boolean bl = false;
            new RsImportOptimizer().optimizeUseItems(it2);
        }
    }
}

