/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.move.common;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.move.common.RsMoveUtil;
import org.rust.ide.utils.import.RsImportHelper;
import org.rust.lang.core.psi.RsCodeFragmentFactory;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElementKt;
import org.rust.lang.core.psi.ext.RsVisibility;
import org.rust.lang.core.psi.ext.RsVisibilityOwner;
import org.rust.lang.core.resolve.ref.RsPathReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/refactoring/move/common/RsMovePathHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "mod", "Lorg/rust/lang/core/psi/ext/RsMod;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/lang/core/psi/ext/RsMod;)V", "codeFragmentFactory", "Lorg/rust/lang/core/psi/RsCodeFragmentFactory;", "existingPublicItem", "Lorg/rust/lang/core/psi/ext/RsQualifiedNamedElement;", "findExistingPublicItem", "findPathAfterMove", "Lorg/rust/lang/core/psi/RsPath;", "context", "Lorg/rust/lang/core/psi/ext/RsElement;", "element", "findPathAfterMoveUsingOtherItemInMod", "elementName", "", "findPathAfterMoveUsingMod", "findPath", "findPathSimple", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMovePathHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMovePathHelper.kt\norg/rust/ide/refactoring/move/common/RsMovePathHelper\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,96:1\n31#2:97\n774#3:98\n865#3,2:99\n1068#3:101\n295#3:102\n2746#3,2:103\n2748#3:107\n296#3:108\n66#4,2:105\n*S KotlinDebug\n*F\n+ 1 RsMovePathHelper.kt\norg/rust/ide/refactoring/move/common/RsMovePathHelper\n*L\n39#1:97\n40#1:98\n40#1:99,2\n42#1:101\n43#1:102\n47#1:103,2\n47#1:107\n43#1:108\n47#1:105,2\n*E\n"})
public final class RsMovePathHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final RsMod mod;
    @NotNull
    private final RsCodeFragmentFactory codeFragmentFactory;
    @Nullable
    private final RsQualifiedNamedElement existingPublicItem;

    public RsMovePathHelper(@NotNull Project project, @NotNull RsMod mod) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        this.project = project;
        this.mod = mod;
        this.codeFragmentFactory = new RsCodeFragmentFactory(this.project);
        this.existingPublicItem = this.findExistingPublicItem();
    }

    /*
     * WARNING - void declaration
     */
    private final RsQualifiedNamedElement findExistingPublicItem() {
        Object v3;
        block6: {
            void $this$filterTo$iv$iv;
            PsiElement $this$childrenOfType$iv = this.mod;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, RsQualifiedNamedElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RsQualifiedNamedElement it2 = (RsQualifiedNamedElement)element$iv$iv;
                boolean bl = false;
                if (!(it2 instanceof RsVisibilityOwner && Intrinsics.areEqual((Object)((RsVisibilityOwner)((Object)it2)).getVisibility(), (Object)RsVisibility.Public.INSTANCE) && ((RsNamedElement)it2).getName() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RsQualifiedNamedElement it2 = (RsQualifiedNamedElement)b;
                    boolean bl = false;
                    String string = it2.getName();
                    it2 = (RsQualifiedNamedElement)a;
                    Comparable comparable = string != null ? Integer.valueOf(string.length()) : null;
                    bl = false;
                    String string2 = it2.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(string2 != null ? Integer.valueOf(string2.length()) : null));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    Iterable itemUsages;
                    RsQualifiedNamedElement item = (RsQualifiedNamedElement)element$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = itemUsages = ReferencesSearch.search((PsiElement)item, (SearchScope)((SearchScope)GlobalSearchScope.projectScope((Project)this.project))).asIterable();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            PsiElement $this$parentOfType_u24default$iv;
                            PsiReference it3 = (PsiReference)element$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it3.getElement(), (String)"getElement(...)");
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            RsUseItem rsUseItem = (RsUseItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsUseItem.class, (boolean)true);
                            if (!((rsUseItem != null ? rsUseItem.getVis() : null) != null)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    @Nullable
    public final RsPath findPathAfterMove(@NotNull RsElement context, @NotNull RsQualifiedNamedElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element instanceof RsFile ? (RsFile)element : null;
        if ((object == null || (object = ((RsFile)object).getModName()) == null) && (object = element.getName()) == null) {
            return null;
        }
        Object elementName = object;
        if (Intrinsics.areEqual((Object)RsElementKt.getContainingModOrSelf(context), (Object)this.mod)) {
            return RsCodeFragmentFactory.createPath$default(this.codeFragmentFactory, (String)elementName, context, null, null, 12, null);
        }
        RsPath rsPath = this.findPathAfterMoveUsingOtherItemInMod(context, (String)elementName);
        if (rsPath == null) {
            rsPath = this.findPathAfterMoveUsingMod(context, (String)elementName);
        }
        return rsPath;
    }

    private final RsPath findPathAfterMoveUsingOtherItemInMod(RsElement context, String elementName) {
        RsQualifiedNamedElement rsQualifiedNamedElement = this.existingPublicItem;
        if (rsQualifiedNamedElement == null) {
            return null;
        }
        RsQualifiedNamedElement secondaryElement = rsQualifiedNamedElement;
        String string = secondaryElement.getName();
        if (string == null) {
            return null;
        }
        String secondaryElementName = string;
        String string2 = this.findPath(context, secondaryElement);
        if (string2 == null) {
            return null;
        }
        String secondaryPathText = string2;
        RsPath rsPath = RsCodeFragmentFactory.createPath$default(this.codeFragmentFactory, secondaryPathText, context, null, null, 12, null);
        if (rsPath == null) {
            return null;
        }
        RsPath secondaryPath = rsPath;
        RsPathReference rsPathReference = secondaryPath.getReference();
        Intrinsics.checkNotNull((Object)rsPathReference);
        if (!Intrinsics.areEqual((Object)rsPathReference.resolve(), (Object)secondaryElement)) {
            return null;
        }
        if (!StringsKt.endsWith$default((String)secondaryPathText, (String)("::" + secondaryElementName), (boolean)false, (int)2, null)) {
            return null;
        }
        String pathText = StringsKt.removeSuffix((String)secondaryPathText, (CharSequence)secondaryElementName) + elementName;
        return RsCodeFragmentFactory.createPath$default(this.codeFragmentFactory, pathText, context, null, null, 12, null);
    }

    private final RsPath findPathAfterMoveUsingMod(RsElement context, String elementName) {
        String string = this.findPath(context, this.mod);
        if (string == null) {
            return null;
        }
        String modPath = string;
        String elementPath = modPath + "::" + elementName;
        return RsCodeFragmentFactory.createPath$default(this.codeFragmentFactory, elementPath, context, null, null, 12, null);
    }

    private final String findPath(RsElement context, RsQualifiedNamedElement element) {
        String pathSimple = this.findPathSimple(context, element);
        if (pathSimple != null) {
            return pathSimple;
        }
        String string = RsImportHelper.INSTANCE.findPath(context, element);
        if (string == null) {
            return null;
        }
        String path = string;
        return RsQualifiedNamedElementKt.convertPathToRelativeIfPossible(RsElementKt.getContainingModOrSelf(context), path);
    }

    private final String findPathSimple(RsElement context, RsQualifiedNamedElement element) {
        RsMod contextMod = RsElementKt.getContainingModOrSelf(context);
        String string = RsQualifiedNamedElementKt.qualifiedNameRelativeTo(element, contextMod);
        if (string == null) {
            return null;
        }
        String pathText = string;
        RsPath rsPath = RsCodeFragmentFactory.createPath$default(this.codeFragmentFactory, pathText, context, null, null, 12, null);
        if (rsPath == null) {
            return null;
        }
        RsPath path = rsPath;
        return RsMoveUtil.INSTANCE.resolvesToAndAccessible(path, element) ? path.getText() : null;
    }
}

