/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.refactoring.move.RsMoveFilesOrDirectoriesDialogKt;
import org.rust.ide.refactoring.move.RsMoveFilesOrDirectoriesProcessorKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0002\u001aE\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u0001H\u00140\u0018H\u0002\u00a2\u0006\u0002\u0010\u001a\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\u00a8\u0006\u001b"}, d2={"MOVE_TARGET_MOD_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/rust/lang/core/psi/ext/RsMod;", "getMOVE_TARGET_MOD_KEY", "()Lcom/intellij/openapi/util/Key;", "MOVE_TARGET_FILE_PATH_KEY", "Ljava/nio/file/Path;", "getMOVE_TARGET_FILE_PATH_KEY", "createNewRustFile", "Lorg/rust/lang/core/psi/RsFile;", "filePath", "project", "Lcom/intellij/openapi/project/Project;", "crateRoot", "requestor", "", "attachFileToParentMod", "", "file", "createNewFile", "T", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/vfs/VirtualFileSystem;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMoveTopLevelItemsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMoveTopLevelItemsDialog.kt\norg/rust/ide/refactoring/move/RsMoveTopLevelItemsDialogKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
public final class RsMoveTopLevelItemsDialogKt {
    @NotNull
    private static final Key<RsMod> MOVE_TARGET_MOD_KEY = new Key("RS_MOVE_TARGET_MOD_KEY");
    @NotNull
    private static final Key<Path> MOVE_TARGET_FILE_PATH_KEY = new Key("RS_MOVE_TARGET_FILE_PATH_KEY");

    @NotNull
    public static final Key<RsMod> getMOVE_TARGET_MOD_KEY() {
        return MOVE_TARGET_MOD_KEY;
    }

    @NotNull
    public static final Key<Path> getMOVE_TARGET_FILE_PATH_KEY() {
        return MOVE_TARGET_FILE_PATH_KEY;
    }

    private static final RsFile createNewRustFile(Path filePath, Project project, RsMod crateRoot, Object requestor) {
        String string = RefactoringBundle.message((String)"move.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return (RsFile)UtilsKt.runWriteCommandAction(project, string, new PsiFile[0], () -> RsMoveTopLevelItemsDialogKt.createNewRustFile$lambda$0(crateRoot, filePath, requestor, project));
    }

    private static final boolean attachFileToParentMod(RsFile file, Project project, RsMod crateRoot) {
        RsMod parentMod;
        Pair pair;
        if (file.isCrateRoot()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)file.getName(), (Object)"mod.rs")) {
            PsiDirectory psiDirectory = file.getParent();
            PsiDirectory psiDirectory2 = file.getParent();
            pair = TuplesKt.to((Object)(psiDirectory != null ? psiDirectory.getParent() : null), (Object)(psiDirectory2 != null ? psiDirectory2.getName() : null));
        } else {
            pair = TuplesKt.to((Object)file.getParent(), (Object)FileUtil.getNameWithoutExtension((String)file.getName()));
        }
        Pair pair2 = pair;
        PsiDirectory parentModOwningDirectory = (PsiDirectory)pair2.component1();
        String modName = (String)pair2.component2();
        PsiDirectory psiDirectory = parentModOwningDirectory;
        RsMod rsMod = parentMod = psiDirectory != null ? RsMoveFilesOrDirectoriesDialogKt.getOwningMod(psiDirectory, crateRoot) : null;
        if (parentMod == null || modName == null) {
            return false;
        }
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        RsMoveFilesOrDirectoriesProcessorKt.insertModDecl(parentMod, psiFactory.createModDeclItem(modName));
        return true;
    }

    private static final <T> T createNewFile(Path filePath, VirtualFileSystem fileSystem, Object requestor, Function1<? super VirtualFile, ? extends T> action2) {
        Path directoryPath = filePath.getParent();
        List directoriesToCreate = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)directoryPath, RsMoveTopLevelItemsDialogKt::createNewFile$lambda$0), arg_0 -> RsMoveTopLevelItemsDialogKt.createNewFile$lambda$1(fileSystem, arg_0)));
        VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((VirtualFileSystem)fileSystem, (String)((Object)directoryPath).toString());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parentDirectory = virtualFile;
        VirtualFile virtualFile2 = parentDirectory.createChildData(requestor, ((Object)filePath.getFileName()).toString());
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
        VirtualFile file = virtualFile2;
        Iterator iterator2 = action2.invoke((Object)file);
        if (iterator2 != null) {
            Iterator it2 = iterator2;
            boolean bl = false;
            return (T)it2;
        }
        file.delete(null);
        for (Path directory : directoriesToCreate) {
            VirtualFile virtualFile3 = fileSystem.findFileByPath(((Object)directory).toString());
            if (virtualFile3 == null) continue;
            virtualFile3.delete(requestor);
        }
        return null;
    }

    private static final RsFile createNewRustFile$lambda$0(RsMod $crateRoot, Path $filePath, Object $requestor, Project $project) {
        RsFile rsFile = $crateRoot instanceof RsFile ? (RsFile)$crateRoot : null;
        if (rsFile == null || (rsFile = rsFile.getVirtualFile()) == null || (rsFile = rsFile.getFileSystem()) == null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            rsFile = (VirtualFileSystem)localFileSystem;
        }
        RsFile fileSystem = rsFile;
        return (RsFile)RsMoveTopLevelItemsDialogKt.createNewFile($filePath, (VirtualFileSystem)fileSystem, $requestor, arg_0 -> RsMoveTopLevelItemsDialogKt.createNewRustFile$lambda$0$0($project, $crateRoot, arg_0));
    }

    private static final RsFile createNewRustFile$lambda$0$0(Project $project, RsMod $crateRoot, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Object object = UtilsKt.toPsiFile(virtualFile, $project);
        if (object == null || (object = RsFileKt.getRustFile(object)) == null) {
            return null;
        }
        Object file = object;
        if (!RsMoveTopLevelItemsDialogKt.attachFileToParentMod((RsFile)file, $project, $crateRoot)) {
            return null;
        }
        return file;
    }

    private static final Path createNewFile$lambda$0(Path it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getParent();
    }

    private static final boolean createNewFile$lambda$1(VirtualFileSystem $fileSystem, Path it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return $fileSystem.findFileByPath(((Object)it2).toString()) == null;
    }

    public static final /* synthetic */ RsFile access$createNewRustFile(Path filePath, Project project, RsMod crateRoot, Object requestor) {
        return RsMoveTopLevelItemsDialogKt.createNewRustFile(filePath, project, crateRoot, requestor);
    }
}

