/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.refactoring.move.RsMoveFilesOrDirectoriesDialogKt;
import org.rust.ide.refactoring.move.RsMoveFilesOrDirectoriesProcessor;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0014J\u0014\u0010\u0011\u001a\u00020\u000f2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/refactoring/move/RsMoveFilesOrDirectoriesDialog;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesDialog;", "project", "Lcom/intellij/openapi/project/Project;", "filesOrDirectoriesToMove", "", "Lcom/intellij/psi/PsiElement;", "initialTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/refactoring/move/MoveCallback;)V", "[Lcom/intellij/psi/PsiElement;", "performMove", "", "targetDirectory", "showError", "message", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMoveFilesOrDirectoriesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMoveFilesOrDirectoriesDialog.kt\norg/rust/ide/refactoring/move/RsMoveFilesOrDirectoriesDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,194:1\n13#2:195\n*S KotlinDebug\n*F\n+ 1 RsMoveFilesOrDirectoriesDialog.kt\norg/rust/ide/refactoring/move/RsMoveFilesOrDirectoriesDialog\n*L\n79#1:195\n*E\n"})
public final class RsMoveFilesOrDirectoriesDialog
extends MoveFilesOrDirectoriesDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement[] filesOrDirectoriesToMove;
    @Nullable
    private final MoveCallback moveCallback;

    public RsMoveFilesOrDirectoriesDialog(@NotNull Project project, @NotNull PsiElement[] filesOrDirectoriesToMove, @Nullable PsiDirectory initialTargetDirectory, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filesOrDirectoriesToMove, (String)"filesOrDirectoriesToMove");
        super(project, filesOrDirectoriesToMove, initialTargetDirectory);
        this.filesOrDirectoriesToMove = filesOrDirectoriesToMove;
        this.moveCallback = moveCallback;
        if (!(!UtilsKt.isUnitTestMode())) {
            throw new IllegalStateException("Check failed.");
        }
        this.setTitle(RsBundle.INSTANCE.message("dialog.title.move.rust", new Object[0]));
    }

    protected void performMove(@NotNull PsiDirectory targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.getProject(), (PsiElement)((PsiElement)targetDirectory))) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.getProject(), (Collection)ArraysKt.toList((Object[])this.filesOrDirectoriesToMove), (boolean)true)) {
            return;
        }
        try {
            for (PsiElement element : this.filesOrDirectoriesToMove) {
                if (element instanceof RsFile) {
                    if (Intrinsics.areEqual((Object)((RsFile)element).getParent(), (Object)targetDirectory)) {
                        this.showError(RsBundle.INSTANCE.message("dialog.message.please.choose.target.directory.different.from.current", new Object[0]));
                        return;
                    }
                    CopyFilesOrDirectoriesHandler.checkFileExist((PsiDirectory)targetDirectory, null, (PsiFile)((PsiFile)element), (String)((RsFile)element).getName(), (String)RsBundle.INSTANCE.message("dialog.title.move", new Object[0]));
                }
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)element, (PsiElement)((PsiElement)targetDirectory));
            }
            Runnable doneCallback = () -> RsMoveFilesOrDirectoriesDialog.performMove$lambda$0(this);
            boolean searchForReferences = RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Companion.doPerformMove(project, this.filesOrDirectoriesToMove, this.moveCallback, targetDirectory, searchForReferences, doneCallback);
        }
        catch (Exception e) {
            if (!(e instanceof IncorrectOperationException)) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(RsMoveFilesOrDirectoriesDialog.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
            }
            this.showError(e.getMessage());
        }
    }

    private final void showError(@NlsContexts.DialogMessage String message) {
        String string = RefactoringBundle.message((String)"error.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        CommonRefactoringUtil.showErrorMessage((String)title, (String)message, (String)"refactoring.moveFile", (Project)this.getProject());
    }

    private static final void performMove$lambda$0(RsMoveFilesOrDirectoriesDialog this$0) {
        this$0.close(0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/refactoring/move/RsMoveFilesOrDirectoriesDialog$Companion;", "", "<init>", "()V", "doPerformMove", "", "project", "Lcom/intellij/openapi/project/Project;", "filesOrDirectoriesToMove", "", "Lcom/intellij/psi/PsiElement;", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "searchForReferences", "", "doneCallback", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;Lcom/intellij/psi/PsiDirectory;ZLjava/lang/Runnable;)V", "askShouldMoveIfNoNewParentMod", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void doPerformMove(@NotNull Project project, @NotNull PsiElement[] filesOrDirectoriesToMove, @Nullable MoveCallback moveCallback, @NotNull PsiDirectory targetDirectory, boolean searchForReferences, @NotNull Runnable doneCallback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filesOrDirectoriesToMove, (String)"filesOrDirectoriesToMove");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            Intrinsics.checkNotNullParameter((Object)doneCallback, (String)"doneCallback");
            if (!searchForReferences) {
                org.rust.ide.refactoring.move.RsMoveFilesOrDirectoriesDialog$Companion.doPerformMove$runDefaultProcessor(project, filesOrDirectoriesToMove, targetDirectory, moveCallback, doneCallback);
                return;
            }
            RsMod rsMod = PsiElementKt.adjustForMove((PsiElement)ArraysKt.first((Object[])filesOrDirectoriesToMove));
            if (rsMod == null || (rsMod = rsMod.getCrateRoot()) == null) {
                throw new IllegalStateException("One of moved file is not included in module tree".toString());
            }
            RsMod crateRoot = rsMod;
            RsMod targetMod = RsMoveFilesOrDirectoriesDialogKt.getOwningMod(targetDirectory, crateRoot);
            if (targetMod == null) {
                if (this.askShouldMoveIfNoNewParentMod(project)) {
                    org.rust.ide.refactoring.move.RsMoveFilesOrDirectoriesDialog$Companion.doPerformMove$runDefaultProcessor(project, filesOrDirectoriesToMove, targetDirectory, moveCallback, doneCallback);
                }
                return;
            }
            new RsMoveFilesOrDirectoriesProcessor(project, filesOrDirectoriesToMove, targetDirectory, targetMod, moveCallback, doneCallback).run();
        }

        private final boolean askShouldMoveIfNoNewParentMod(Project project) {
            String string = RsBundle.INSTANCE.message("dialog.title.move", new Object[0]);
            String string2 = RsBundle.INSTANCE.message("dialog.message.file.will.not.be.included.in.module.tree.after.move.continue", new Object[0]);
            String string3 = Messages.getOkButton();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getOkButton(...)");
            int result2 = MessageUtil.showOkCancelDialog$default((String)string, (String)string2, (String)string3, null, null, null, (Project)project, (int)56, null);
            return result2 == 0;
        }

        private static final void doPerformMove$runDefaultProcessor(Project $project, PsiElement[] $filesOrDirectoriesToMove, PsiDirectory $targetDirectory, MoveCallback $moveCallback, Runnable $doneCallback) {
            new MoveFilesOrDirectoriesProcessor($project, $filesOrDirectoriesToMove, $targetDirectory, false, true, true, $moveCallback, $doneCallback).run();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

