/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.introduceParameter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.refactoring.ExtraxtExpressionUtilsKt;
import org.rust.ide.refactoring.RsInPlaceVariableIntroducer;
import org.rust.ide.refactoring.RsNameSuggestionsKt;
import org.rust.ide.refactoring.SuggestedNames;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010-\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/rust/ide/refactoring/introduceParameter/ParamIntroducer;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "replaceExpressions", "", "function", "Lorg/rust/lang/core/psi/RsFunction;", "exprs", "", "Lorg/rust/lang/core/psi/RsExpr;", "replaceForTrait", "", "appendNewArgument", "usages", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiElement;", "value", "findFunctionUsages", "chosenFunction", "getTraitAndImpls", "traitFunction", "findFunctionUsagesWithImpl", "findDescendantFunction", "traitImplRef", "Lcom/intellij/psi/PsiReference;", "functionToSearch", "createParam", "Lorg/rust/lang/core/psi/RsValueParameter;", "name", "", "typeRef", "Lorg/rust/lang/core/psi/RsTypeReference;", "createParamList", "Lorg/rust/lang/core/psi/RsValueParameterList;", "introduceValueArgument", "argumentList", "Lorg/rust/lang/core/psi/RsValueArgumentList;", "introduceParam", "func", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\norg/rust/ide/refactoring/introduceParameter/ParamIntroducer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,182:1\n1321#2:183\n1322#2:185\n1321#2,2:206\n15#3:184\n1563#4:186\n1634#4,3:187\n1617#4,9:190\n1869#4:199\n1870#4:201\n1626#4:202\n230#4,2:204\n1869#4,2:208\n1#5:200\n127#6:203\n*S KotlinDebug\n*F\n+ 1 impl.kt\norg/rust/ide/refactoring/introduceParameter/ParamIntroducer\n*L\n106#1:183\n106#1:185\n90#1:206,2\n108#1:184\n119#1:186\n119#1:187,3\n126#1:190,9\n126#1:199\n126#1:201\n126#1:202\n139#1:204,2\n94#1:208,2\n126#1:200\n138#1:203\n*E\n"})
final class ParamIntroducer {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final RsPsiFactory psiFactory;

    public ParamIntroducer(@NotNull Project project, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.project = project;
        this.editor = editor2;
        this.psiFactory = new RsPsiFactory(this.project, false, false, 6, null);
    }

    public final void replaceExpressions(@NotNull RsFunction function, @NotNull List<? extends RsExpr> exprs, boolean replaceForTrait) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(exprs, (String)"exprs");
        if (exprs.isEmpty()) {
            return;
        }
        RsExpr expr = (RsExpr)CollectionsKt.first(exprs);
        RsTypeReference rsTypeReference = this.psiFactory.tryCreateType(TypeRenderingKt.renderInsertionSafe$default(ExtensionsKt.getType(expr), null, 0, null, false, false, false, false, 127, null));
        if (rsTypeReference == null) {
            return;
        }
        RsTypeReference typeRef = rsTypeReference;
        SuggestedNames suggestedNames = RsNameSuggestionsKt.suggestedNames(expr);
        RsAbstractable rsAbstractable = RsAbstractableKt.getSuperItem(function);
        RsFunction rsFunction = rsAbstractable instanceof RsFunction ? (RsFunction)rsAbstractable : null;
        if (rsFunction == null) {
            rsFunction = function;
        }
        RsFunction traitFunction = rsFunction;
        Sequence<PsiElement> functionUsages = replaceForTrait ? this.findFunctionUsagesWithImpl(traitFunction) : this.findFunctionUsages(function);
        String string = RefactoringBundle.message((String)"introduce.parameter.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        UtilsKt.runWriteCommandAction(this.project, string, new PsiFile[0], () -> ParamIntroducer.replaceExpressions$lambda$0(this, functionUsages, expr, replaceForTrait, traitFunction, function, suggestedNames, typeRef, exprs));
    }

    public static /* synthetic */ void replaceExpressions$default(ParamIntroducer paramIntroducer, RsFunction rsFunction, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        paramIntroducer.replaceExpressions(rsFunction, list, bl);
    }

    private final void appendNewArgument(Sequence<? extends PsiElement> usages, RsExpr value) {
        Sequence<? extends PsiElement> $this$forEach$iv = usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            if (it2 instanceof RsPath) {
                RsCallExpr expr;
                PsiElement $this$ancestorOrSelf$iv = it2;
                boolean $i$f$ancestorOrSelf = false;
                if ((RsCallExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsCallExpr.class, (boolean)false) == null) {
                    return;
                }
                RsValueArgumentList rsValueArgumentList = expr.getValueArgumentList();
                Intrinsics.checkNotNullExpressionValue((Object)rsValueArgumentList, (String)"getValueArgumentList(...)");
                this.introduceValueArgument(value, rsValueArgumentList);
                continue;
            }
            if (!(it2 instanceof RsMethodCall)) continue;
            RsValueArgumentList rsValueArgumentList = ((RsMethodCall)it2).getValueArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)rsValueArgumentList, (String)"getValueArgumentList(...)");
            this.introduceValueArgument(value, rsValueArgumentList);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<PsiElement> findFunctionUsages(RsFunction chosenFunction) {
        void $this$mapTo$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)chosenFunction.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope projectScope = globalSearchScope;
        Collection functionUsages = ReferencesSearch.search((PsiElement)chosenFunction, (SearchScope)((SearchScope)projectScope), (boolean)false).findAll();
        Iterable $this$map$iv = functionUsages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            PsiReference psiReference = (PsiReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getElement());
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<RsFunction> getTraitAndImpls(RsFunction traitFunction) {
        void $this$mapNotNullTo$iv$iv;
        RsAbstractableOwner rsAbstractableOwner = RsAbstractableKt.getOwner(traitFunction);
        Object object = rsAbstractableOwner instanceof RsAbstractableOwner.Trait ? (RsAbstractableOwner.Trait)rsAbstractableOwner : null;
        if (object == null || (object = ((RsAbstractableOwner.Trait)object).getTrait()) == null) {
            return SequencesKt.emptySequence();
        }
        Object trait = object;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)traitFunction.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope projectScope = globalSearchScope;
        Collection traitUsages = ReferencesSearch.search((PsiElement)((PsiElement)trait), (SearchScope)((SearchScope)projectScope), (boolean)false).findAll();
        Iterable $this$mapNotNull$iv = traitUsages;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RsFunction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiReference it2 = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            if (this.findDescendantFunction(it2, traitFunction) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List refs = (List)destination$iv$iv;
        return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)refs), (Object)traitFunction);
    }

    private final Sequence<PsiElement> findFunctionUsagesWithImpl(RsFunction traitFunction) {
        return SequencesKt.flatten((Sequence)SequencesKt.map(this.getTraitAndImpls(traitFunction), arg_0 -> ParamIntroducer.findFunctionUsagesWithImpl$lambda$0(this, arg_0)));
    }

    private final RsFunction findDescendantFunction(PsiReference traitImplRef, RsFunction functionToSearch) {
        Object element$iv2;
        block2: {
            PsiElement psiElement2 = traitImplRef.getElement().getParent();
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
            RsImplItem rsImplItem = psiElement3 instanceof RsImplItem ? (RsImplItem)psiElement3 : null;
            if (rsImplItem == null) {
                return null;
            }
            RsImplItem traitImpl = rsImplItem;
            PsiElement $this$descendantsOfType$iv = traitImpl;
            boolean $i$f$descendantsOfType = false;
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsFunction.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            Collection functions = collection;
            Iterable $this$first$iv = functions;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RsFunction it2 = (RsFunction)element$iv2;
                boolean bl = false;
                if (!StringsKt.equals$default((String)it2.getName(), (String)functionToSearch.getName(), (boolean)false, (int)2, null)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (RsFunction)element$iv2;
    }

    private final RsValueParameter createParam(String name2, RsTypeReference typeRef) {
        List<RsValueParameter> list = this.createParamList(name2, typeRef).getValueParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameterList(...)");
        Object object = CollectionsKt.first(list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (RsValueParameter)object;
    }

    private final RsValueParameterList createParamList(String name2, RsTypeReference typeRef) {
        return this.psiFactory.createSimpleValueParameterList(name2, typeRef);
    }

    private final void introduceValueArgument(RsExpr value, RsValueArgumentList argumentList) {
        List<RsExpr> list = argumentList.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        List<RsExpr> args = list;
        if (args.isEmpty()) {
            v1 = argumentList.addAfter(value, argumentList.getFirstChild());
        } else {
            argumentList.addAfter(value, (PsiElement)CollectionsKt.last(args));
            PsiElement comma = this.psiFactory.createComma();
            v1 = argumentList.addAfter(comma, (PsiElement)CollectionsKt.last(args));
        }
    }

    private final PsiElement introduceParam(RsFunction func, String name2, RsTypeReference typeRef) {
        PsiElement psiElement2;
        List<RsValueParameter> params = RsFunctionKt.getRawValueParameters(func);
        RsValueParameterList rsValueParameterList = func.getValueParameterList();
        if (rsValueParameterList == null) {
            return null;
        }
        RsValueParameterList parent2 = rsValueParameterList;
        RsValueParameter newParam = this.createParam(name2, typeRef);
        if (params.isEmpty()) {
            if (parent2.getSelfParameter() != null) {
                PsiElement newElem = parent2.addAfter(newParam, parent2.getSelfParameter());
                PsiElement comma = this.psiFactory.createComma();
                parent2.addAfter(comma, parent2.getSelfParameter());
                psiElement2 = newElem;
            } else {
                psiElement2 = parent2.addAfter(newParam, parent2.getFirstChild());
            }
        } else {
            PsiElement newElem = parent2.addAfter(newParam, (PsiElement)CollectionsKt.last(params));
            PsiElement comma = this.psiFactory.createComma();
            parent2.addAfter(comma, (PsiElement)CollectionsKt.last(params));
            psiElement2 = newElem;
        }
        return psiElement2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit replaceExpressions$lambda$0(ParamIntroducer this$0, Sequence $functionUsages, RsExpr $expr, boolean $replaceForTrait, RsFunction $traitFunction, RsFunction $function, SuggestedNames $suggestedNames, RsTypeReference $typeRef, List $exprs) {
        this$0.appendNewArgument((Sequence<? extends PsiElement>)$functionUsages, $expr);
        if ($replaceForTrait) {
            void $this$forEach$iv;
            Sequence sequence2 = SequencesKt.filter(this$0.getTraitAndImpls($traitFunction), arg_0 -> ParamIntroducer.replaceExpressions$lambda$0$0($function, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsFunction it2 = (RsFunction)element$iv;
                boolean bl = false;
                this$0.introduceParam(it2, $suggestedNames.getDefault(), $typeRef);
            }
        }
        PsiElement newParam = this$0.introduceParam($function, $suggestedNames.getDefault(), $typeRef);
        RsExpr name2 = this$0.psiFactory.createExpression($suggestedNames.getDefault());
        Iterable $this$forEach$iv = $exprs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RsExpr it3 = (RsExpr)element$iv;
            boolean bl = false;
            it3.replace(name2);
        }
        RsPatBinding newParameter = ExtraxtExpressionUtilsKt.moveEditorToNameElement(this$0.editor, newParam);
        if (newParameter != null) {
            PsiDocumentManager.getInstance((Project)this$0.project).doPostponedOperationsAndUnblockDocument(this$0.editor.getDocument());
            new RsInPlaceVariableIntroducer(newParameter, this$0.editor, this$0.project, RsBundle.INSTANCE.message("command.name.choose.parameter", new Object[0]), null, 16, null).performInplaceRefactoring($suggestedNames.getAll());
        }
        return Unit.INSTANCE;
    }

    private static final boolean replaceExpressions$lambda$0$0(RsFunction $function, RsFunction it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !Intrinsics.areEqual((Object)it2, (Object)$function);
    }

    private static final Sequence findFunctionUsagesWithImpl$lambda$0(ParamIntroducer this$0, RsFunction it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.findFunctionUsages(it2);
    }
}

