/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.introduceParameter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.refactoring.ExtraxtExpressionUiKt;
import org.rust.ide.refactoring.ExtraxtExpressionUtilsKt;
import org.rust.ide.refactoring.introduceParameter.ImplKt$findEnclosingFunctions$;
import org.rust.ide.refactoring.introduceParameter.ParamIntroducer;
import org.rust.ide.refactoring.introduceParameter.UiKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a.\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"extractExpression", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "replaceExpressionOccurrences", "function", "Lorg/rust/lang/core/psi/RsFunction;", "replaceExpression", "project", "Lcom/intellij/openapi/project/Project;", "exprs", "", "findEnclosingFunctions", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\norg/rust/ide/refactoring/introduceParameter/ImplKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,182:1\n477#2:183\n*S KotlinDebug\n*F\n+ 1 impl.kt\norg/rust/ide/refactoring/introduceParameter/ImplKt\n*L\n58#1:183\n*E\n"})
public final class ImplKt {
    public static final void extractExpression(@NotNull Editor editor2, @NotNull RsExpr expr) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Project project = expr.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        List<RsFunction> enclosingFunctions = ImplKt.findEnclosingFunctions(expr);
        switch (enclosingFunctions.size()) {
            case 0: {
                String message = RsBundle.INSTANCE.message("dialog.message.no.suitable.function.to.extract.parameter.found", new Object[0]);
                String string = RefactoringBundle.message((String)"introduce.parameter.title");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String title = string;
                String helpId = "refactoring.extractParameter";
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)title, (String)helpId);
                break;
            }
            case 1: {
                ImplKt.replaceExpressionOccurrences(editor2, expr, (RsFunction)CollectionsKt.first(enclosingFunctions));
                break;
            }
            default: {
                UiKt.showEnclosingFunctionsChooser(editor2, enclosingFunctions, (Function1<? super RsFunction, Unit>)((Function1)arg_0 -> ImplKt.extractExpression$lambda$0(editor2, expr, arg_0)));
            }
        }
    }

    private static final void replaceExpressionOccurrences(Editor editor2, RsExpr expr, RsFunction function) {
        List<RsExpr> occurrences = ExtraxtExpressionUtilsKt.findOccurrences(function, expr);
        ExtraxtExpressionUiKt.showOccurrencesChooser(editor2, expr, occurrences, (Function1<? super List<? extends RsExpr>, Unit>)((Function1)arg_0 -> ImplKt.replaceExpressionOccurrences$lambda$0(expr, editor2, function, arg_0)));
    }

    private static final void replaceExpression(Project project, Editor editor2, RsFunction function, List<? extends RsExpr> exprs) {
        if (exprs.isEmpty()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)function)) {
            return;
        }
        boolean replaceForTrait = RsAbstractableKt.getOwner(function) instanceof RsAbstractableOwner.Trait || RsAbstractableKt.getOwner(function).isTraitImpl();
        ParamIntroducer paramIntroducer = new ParamIntroducer(project, editor2);
        paramIntroducer.replaceExpressions(function, exprs, replaceForTrait);
    }

    private static final List<RsFunction> findEnclosingFunctions(RsExpr expr) {
        Sequence<PsiElement> $this$filterIsInstance$iv = PsiElementKt.getAncestors(expr);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, (Function1)findEnclosingFunctions$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toList((Sequence)sequence2);
    }

    private static final Unit extractExpression$lambda$0(Editor $editor, RsExpr $expr, RsFunction chosenFunction) {
        Intrinsics.checkNotNullParameter((Object)chosenFunction, (String)"chosenFunction");
        ImplKt.replaceExpressionOccurrences($editor, $expr, chosenFunction);
        return Unit.INSTANCE;
    }

    private static final Unit replaceExpressionOccurrences$lambda$0(RsExpr $expr, Editor $editor, RsFunction $function, List occurrencesToReplace) {
        Intrinsics.checkNotNullParameter((Object)occurrencesToReplace, (String)"occurrencesToReplace");
        Project project = $expr.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ImplKt.replaceExpression(project, $editor, $function, occurrencesToReplace);
        return Unit.INSTANCE;
    }
}

