/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.introduceConstant;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.RsBundle;
import org.rust.ide.refactoring.introduceConstant.ExtractConstantUi;
import org.rust.ide.refactoring.introduceConstant.Highlighter;
import org.rust.ide.refactoring.introduceConstant.InsertionCandidate;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsModItem;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014H\u0007\"\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"showInsertionChooser", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "callback", "Lkotlin/Function1;", "Lorg/rust/ide/refactoring/introduceConstant/InsertionCandidate;", "findInsertionCandidates", "", "MOCK", "Lorg/rust/ide/refactoring/introduceConstant/ExtractConstantUi;", "getMOCK", "()Lorg/rust/ide/refactoring/introduceConstant/ExtractConstantUi;", "setMOCK", "(Lorg/rust/ide/refactoring/introduceConstant/ExtractConstantUi;)V", "withMockExtractConstantChooser", "mock", "f", "Lkotlin/Function0;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ui.kt\norg/rust/ide/refactoring/introduceConstant/UiKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class UiKt {
    @Nullable
    private static ExtractConstantUi MOCK;

    public static final void showInsertionChooser(@NotNull Editor editor2, @NotNull RsExpr expr, @NotNull Function1<? super InsertionCandidate, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        List<InsertionCandidate> candidates2 = UiKt.findInsertionCandidates(expr);
        if (UtilsKt.isUnitTestMode()) {
            ExtractConstantUi extractConstantUi = MOCK;
            Intrinsics.checkNotNull((Object)extractConstantUi);
            callback.invoke((Object)extractConstantUi.chooseInsertionPoint(expr, candidates2));
        } else {
            Highlighter highlighter = new Highlighter(editor2);
            IPopupChooserBuilder iPopupChooserBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(candidates2).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    InsertionCandidate candidate = (InsertionCandidate)value;
                    String text = candidate.getDescription();
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            }).setItemSelectedCallback(arg_0 -> UiKt.showInsertionChooser$lambda$1(arg_0 -> UiKt.showInsertionChooser$lambda$0(highlighter, arg_0), arg_0));
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)expr.getText(), (String)"getText(...)");
            iPopupChooserBuilder.setTitle(RsBundle.INSTANCE.message("popup.title.choose.scope.to.introduce.constant", objectArray)).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> UiKt.showInsertionChooser$lambda$3(arg_0 -> UiKt.showInsertionChooser$lambda$2(callback, arg_0), arg_0)).addListener((JBPopupListener)highlighter).createPopup().showInBestPositionFor(editor2);
        }
    }

    private static final List<InsertionCandidate> findInsertionCandidates(RsExpr expr) {
        RsExpr parent2 = null;
        parent2 = expr;
        RsExpr anchor = null;
        anchor = expr;
        List points = new ArrayList();
        boolean moduleVisited = false;
        while (!(parent2 instanceof RsFile)) {
            Intrinsics.checkNotNullExpressionValue((Object)((PsiElement)parent2).getParent(), (String)"getParent(...)");
            RsExpr rsExpr = parent2;
            if (rsExpr instanceof RsFunction) {
                if (moduleVisited) continue;
                if (RsFunctionKt.getBlock((RsFunction)((Object)parent2)) != null) {
                    RsBlock it2;
                    boolean bl = false;
                    points.add(new InsertionCandidate(parent2, it2, UiKt.findInsertionCandidates$getAnchor(it2, anchor)));
                    anchor = parent2;
                }
                continue;
            }
            if (!(rsExpr instanceof RsModItem) && !(rsExpr instanceof RsFile)) continue;
            points.add(new InsertionCandidate(parent2, parent2, UiKt.findInsertionCandidates$getAnchor(parent2, anchor)));
            anchor = parent2;
            moduleVisited = true;
        }
        return points;
    }

    @Nullable
    public static final ExtractConstantUi getMOCK() {
        return MOCK;
    }

    public static final void setMOCK(@Nullable ExtractConstantUi extractConstantUi) {
        MOCK = extractConstantUi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static final void withMockExtractConstantChooser(@NotNull ExtractConstantUi mock, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        MOCK = mock;
        try {
            f.invoke();
        }
        finally {
            MOCK = null;
        }
    }

    private static final Unit showInsertionChooser$lambda$0(Highlighter $highlighter, InsertionCandidate value) {
        if (value == null) {
            return Unit.INSTANCE;
        }
        $highlighter.onSelect(value);
        return Unit.INSTANCE;
    }

    private static final void showInsertionChooser$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit showInsertionChooser$lambda$2(Function1 $callback, InsertionCandidate it2) {
        block0: {
            InsertionCandidate insertionCandidate = it2;
            if (insertionCandidate == null) break block0;
            InsertionCandidate it3 = insertionCandidate;
            boolean bl = false;
            $callback.invoke((Object)it3);
        }
        return Unit.INSTANCE;
    }

    private static final void showInsertionChooser$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final PsiElement findInsertionCandidates$getAnchor(PsiElement parent2, PsiElement anchor) {
        PsiElement found = anchor;
        while (!Intrinsics.areEqual((Object)found.getParent(), (Object)parent2)) {
            Intrinsics.checkNotNullExpressionValue((Object)found.getParent(), (String)"getParent(...)");
        }
        return found;
    }
}

