/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.introduceConstant;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.concurrency.CancellablePromise;
import org.rust.RsBundle;
import org.rust.ide.refactoring.ExtraxtExpressionUiKt;
import org.rust.ide.refactoring.ExtraxtExpressionUtilsKt;
import org.rust.ide.refactoring.RsInPlaceVariableIntroducer;
import org.rust.ide.refactoring.RsNameSuggestionsKt;
import org.rust.ide.refactoring.SuggestedNames;
import org.rust.ide.refactoring.introduceConstant.InsertionCandidate;
import org.rust.ide.refactoring.introduceConstant.UiKt;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.ide.utils.import.RsImportHelper;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.openapiext.RsPluginDisposable;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a<\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0011"}, d2={"isExtractable", "", "Lorg/rust/lang/core/psi/RsExpr;", "findExistingBindings", "", "", "candidate", "Lorg/rust/ide/refactoring/introduceConstant/InsertionCandidate;", "occurrences", "", "replaceWithConstant", "", "expr", "existingBindings", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractExpression", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsIntroduceConstantHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsIntroduceConstantHandler.kt\norg/rust/ide/refactoring/introduceConstant/RsIntroduceConstantHandlerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,131:1\n1374#2:132\n1460#2,5:133\n1563#2:138\n1634#2,3:139\n295#2,2:142\n1563#2:144\n1634#2,3:145\n450#3,14:148\n*S KotlinDebug\n*F\n+ 1 RsIntroduceConstantHandler.kt\norg/rust/ide/refactoring/introduceConstant/RsIntroduceConstantHandlerKt\n*L\n78#1:132\n78#1:133,5\n92#1:138\n92#1:139,3\n92#1:142,2\n99#1:144\n99#1:145,3\n123#1:148,14\n*E\n"})
public final class RsIntroduceConstantHandlerKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExtractable(RsExpr $this$isExtractable) {
        RsConstant target;
        RsExpr rsExpr = $this$isExtractable;
        if (rsExpr instanceof RsLitExpr) {
            return true;
        }
        if (rsExpr instanceof RsBinaryExpr) {
            RsExpr rsExpr2 = ((RsBinaryExpr)$this$isExtractable).getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"getLeft(...)");
            if (!RsIntroduceConstantHandlerKt.isExtractable(rsExpr2)) return false;
            RsExpr rsExpr3 = ((RsBinaryExpr)$this$isExtractable).getRight();
            if (rsExpr3 == null) return true;
            boolean bl = RsIntroduceConstantHandlerKt.isExtractable(rsExpr3);
            if (!bl) return false;
            return true;
        }
        if (!(rsExpr instanceof RsPathExpr)) return false;
        RsPathReference rsPathReference = ((RsPathExpr)$this$isExtractable).getPath().getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        if (!(rsElement instanceof RsConstant)) return false;
        RsConstant rsConstant = (RsConstant)rsElement;
        RsConstant rsConstant2 = target = rsConstant;
        if (rsConstant2 == null) return false;
        if (!RsConstantKt.isConst(rsConstant2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> findExistingBindings(InsertionCandidate candidate, List<? extends RsExpr> occurrences) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsiElement owner = candidate.getParent();
        PsiElement[] psiElementArray = owner.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object object = ArraysKt.first((Object[])psiElementArray);
        RsElement rsElement = object instanceof RsElement ? (RsElement)object : null;
        Set set = rsElement != null ? RsElementKt.getAllVisibleBindings(rsElement) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable iterable = occurrences;
        Set set2 = set;
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RsExpr it2 = (RsExpr)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = RsElementKt.getLocalVariableVisibleBindings(it2).keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return SetsKt.plus((Set)set2, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final void replaceWithConstant(RsExpr expr, List<? extends RsExpr> occurrences, InsertionCandidate candidate, Set<String> existingBindings, Editor editor2) {
        String string;
        Object v2;
        SuggestedNames suggestedNames;
        RsPsiFactory factory2;
        Project project;
        block3: {
            void $this$mapTo$iv$iv;
            Project project2 = expr.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            factory2 = new RsPsiFactory(project, false, false, 6, null);
            suggestedNames = RsNameSuggestionsKt.suggestedNames(expr);
            Iterable $this$map$iv = suggestedNames.getAll();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                collection.add(string3);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it3 = (String)element$iv;
                boolean bl = false;
                if (!(!existingBindings.contains(it3))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((string = (String)v2) == null) {
            String string4 = suggestedNames.getDefault().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            string = RsNameSuggestionsKt.freshenName(string4, existingBindings);
        }
        String name2 = string;
        RsConstant rsConstant = factory2.createConstant(name2, expr);
        String string5 = RefactoringBundle.message((String)"introduce.constant.title");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        UtilsKt.runWriteCommandAction(project, string5, new PsiFile[0], () -> RsIntroduceConstantHandlerKt.replaceWithConstant$lambda$2(candidate, rsConstant, occurrences, editor2, project, name2, factory2));
    }

    private static final void extractExpression(Editor editor2, RsExpr expr) {
        if (!expr.isValid()) {
            return;
        }
        List<RsExpr> occurrences = ExtraxtExpressionUtilsKt.findOccurrences(expr);
        ExtraxtExpressionUiKt.showOccurrencesChooser(editor2, expr, occurrences, (Function1<? super List<? extends RsExpr>, Unit>)((Function1)arg_0 -> RsIntroduceConstantHandlerKt.extractExpression$lambda$0(editor2, expr, occurrences, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit replaceWithConstant$lambda$2(InsertionCandidate $candidate, RsConstant $const, List $occurrences, Editor $editor, Project $project, String $name, RsPsiFactory $factory) {
        void $this$mapTo$iv$iv;
        Object object = PsiInsertionPlace.Companion.before($candidate.getAnchor());
        if (object == null || (object = (RsConstant)object.insert((PsiElement)$const)) == null) {
            return Unit.INSTANCE;
        }
        Object insertedConstant = object;
        Iterable $this$map$iv = $occurrences;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsExpr rsExpr = (RsExpr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RsExpr created = $factory.createExpression($name);
            PsiElement psiElement2 = it2.replace((PsiElement)created);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsPathExpr");
            RsPathExpr element = (RsPathExpr)psiElement2;
            RsPathReference rsPathReference = element.getPath().getReference();
            if ((rsPathReference != null ? rsPathReference.resolve() : null) == null) {
                RsImportHelper.INSTANCE.importElement(element, (RsQualifiedNamedElement)insertedConstant);
            }
            collection.add(element);
        }
        List replaced = (List)destination$iv$iv;
        PsiElement psiElement3 = insertedConstant.getIdentifier();
        if (psiElement3 == null || (psiElement3 = psiElement3.getTextRange()) == null) {
            throw new IllegalStateException("Impossible because we just created a constant with a name".toString());
        }
        $editor.getCaretModel().moveToOffset(psiElement3.getStartOffset());
        PsiDocumentManager.getInstance((Project)$project).doPostponedOperationsAndUnblockDocument($editor.getDocument());
        Object[] objectArray = new String[]{$name};
        new RsInPlaceVariableIntroducer((PsiNamedElement)insertedConstant, $editor, $project, RsBundle.INSTANCE.message("command.name.choose.constant.name", new Object[0]), replaced).performInplaceRefactoring(SetsKt.linkedSetOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit extractExpression$lambda$0(Editor $editor, RsExpr $expr, List $occurrences, List occurrencesToReplace) {
        Intrinsics.checkNotNullParameter((Object)occurrencesToReplace, (String)"occurrencesToReplace");
        UiKt.showInsertionChooser($editor, $expr, (Function1<? super InsertionCandidate, Unit>)((Function1)arg_0 -> RsIntroduceConstantHandlerKt.extractExpression$lambda$0$0($editor, $occurrences, $expr, occurrencesToReplace, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit extractExpression$lambda$0$0(Editor $editor, List $occurrences, RsExpr $expr, List $occurrencesToReplace, InsertionCandidate candidate) {
        Project project;
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Project project2 = $editor.getProject();
        if (project2 == null) {
            return Unit.INSTANCE;
        }
        Project $this$nonBlocking$iv = project = project2;
        boolean $i$f$nonBlocking = false;
        if (UtilsKt.isUnitTestMode()) {
            Set result$iv;
            boolean bl = false;
            Set bindings = result$iv = RsIntroduceConstantHandlerKt.findExistingBindings(candidate, $occurrences);
            boolean bl2 = false;
            RsIntroduceConstantHandlerKt.replaceWithConstant($expr, $occurrencesToReplace, candidate, bindings, $editor);
        } else {
            Function1 function1 = (Function1)new Function1<Set<? extends String>, Unit>($expr, $occurrencesToReplace, candidate, $editor){
                final /* synthetic */ RsExpr $expr$inlined;
                final /* synthetic */ List $occurrencesToReplace$inlined;
                final /* synthetic */ InsertionCandidate $candidate$inlined;
                final /* synthetic */ Editor $editor$inlined;
                {
                    this.$expr$inlined = rsExpr;
                    this.$occurrencesToReplace$inlined = list;
                    this.$candidate$inlined = insertionCandidate;
                    this.$editor$inlined = editor2;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(Object result2) {
                    Set bindings = (Set)result2;
                    boolean bl = false;
                    RsIntroduceConstantHandlerKt.access$replaceWithConstant(this.$expr$inlined, this.$occurrencesToReplace$inlined, this.$candidate$inlined, bindings, this.$editor$inlined);
                }
            };
            CancellablePromise cancellablePromise = ReadAction.nonBlocking((Callable)new Callable(candidate, $occurrences){
                final /* synthetic */ InsertionCandidate $candidate$inlined;
                final /* synthetic */ List $occurrences$inlined;
                {
                    this.$candidate$inlined = insertionCandidate;
                    this.$occurrences$inlined = list;
                }

                public final Set<? extends String> call() {
                    boolean bl = false;
                    return RsIntroduceConstantHandlerKt.access$findExistingBindings(this.$candidate$inlined, this.$occurrences$inlined);
                }
            }).inSmartMode($this$nonBlocking$iv).expireWith(RsPluginDisposable.Companion.getInstance($this$nonBlocking$iv)).finishOnUiThread(ModalityState.current(), new Consumer(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void accept(Object p0) {
                    this.function.invoke(p0);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            Intrinsics.checkNotNull((Object)cancellablePromise);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$extractExpression(Editor editor2, RsExpr expr) {
        RsIntroduceConstantHandlerKt.extractExpression(editor2, expr);
    }
}

