/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineValue;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.refactoring.RsInlineDialog;
import org.rust.ide.refactoring.inlineValue.InlineValueContext;
import org.rust.ide.refactoring.inlineValue.InlineValueMode;
import org.rust.ide.refactoring.inlineValue.RsInlineValueDialogKt;
import org.rust.ide.refactoring.inlineValue.RsInlineValueProcessor;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0014J\b\u0010\u0013\u001a\u00020\u000fH\u0014J\b\u0010\u0014\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/refactoring/inlineValue/RsInlineValueDialog;", "Lorg/rust/ide/refactoring/RsInlineDialog;", "context", "Lorg/rust/ide/refactoring/inlineValue/InlineValueContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/rust/ide/refactoring/inlineValue/InlineValueContext;Lcom/intellij/openapi/project/Project;)V", "occurrencesNumber", "", "doAction", "", "getProcessor", "Lorg/rust/ide/refactoring/inlineValue/RsInlineValueProcessor;", "getBorderTitle", "", "getNameLabelText", "getInlineAllText", "getInlineThisText", "getKeepTheDeclarationText", "getHelpId", "intellij.rustrover.core"})
public final class RsInlineValueDialog
extends RsInlineDialog {
    @NotNull
    private final InlineValueContext context;
    private final int occurrencesNumber;

    public RsInlineValueDialog(@NotNull InlineValueContext context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context.getElement(), context.getReference(), project);
        this.context = context;
        this.occurrencesNumber = InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)this.context.getElement());
        this.init();
    }

    public /* synthetic */ RsInlineValueDialog(InlineValueContext inlineValueContext, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Project project2 = inlineValueContext.getElement().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
        }
        this(inlineValueContext, project);
    }

    protected void doAction() {
        this.invokeRefactoring(this.getProcessor());
    }

    private final RsInlineValueProcessor getProcessor() {
        InlineValueMode mode = this.isInlineThisOnly() ? (InlineValueMode)InlineValueMode.InlineThisOnly.INSTANCE : (this.isKeepTheDeclaration() ? (InlineValueMode)InlineValueMode.InlineAllAndKeepOriginal.INSTANCE : (InlineValueMode)InlineValueMode.InlineAllAndRemoveOriginal.INSTANCE);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new RsInlineValueProcessor(project, this.context, mode);
    }

    @NotNull
    protected String getBorderTitle() {
        String string = RefactoringBundle.message((String)"inline.field.border.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getNameLabelText() {
        return UtilsKt.capitalized(RsInlineValueDialogKt.getType(this.context)) + " " + RsInlineValueDialogKt.getName(this.context) + " " + this.getOccurrencesText(this.occurrencesNumber);
    }

    @NotNull
    protected String getInlineAllText() {
        String text = this.context.getElement().isWritable() ? "all.references.and.remove.the.local" : "all.invocations.in.project";
        String string = RefactoringBundle.message((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getInlineThisText() {
        Object[] objectArray = new Object[]{RsInlineValueDialogKt.getType(this.context)};
        return RsBundle.INSTANCE.message("radio.inline.this.only.keep", objectArray);
    }

    @NotNull
    protected String getKeepTheDeclarationText() {
        String string;
        if (this.context.getElement().isWritable()) {
            Object[] objectArray = new Object[]{RsInlineValueDialogKt.getType(this.context)};
            string = RsBundle.INSTANCE.message("radio.inline.all.references.keep", objectArray);
        } else {
            String string2 = super.getKeepTheDeclarationText();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.inlineVariable";
    }
}

