/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineTypeAlias;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.refactoring.RsInlineDialog;
import org.rust.ide.refactoring.inlineTypeAlias.RsInlineTypeAliasProcessor;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;
import org.rust.lang.core.resolve.ref.RsReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/refactoring/inlineTypeAlias/RsInlineTypeAliasDialog;", "Lorg/rust/ide/refactoring/RsInlineDialog;", "typeAlias", "Lorg/rust/lang/core/psi/RsTypeAlias;", "reference", "Lorg/rust/lang/core/resolve/ref/RsReference;", "<init>", "(Lorg/rust/lang/core/psi/RsTypeAlias;Lorg/rust/lang/core/resolve/ref/RsReference;)V", "getBorderTitle", "", "getNameLabelText", "getInlineAllText", "getInlineThisText", "doAction", "", "intellij.rustrover.core"})
public final class RsInlineTypeAliasDialog
extends RsInlineDialog {
    @NotNull
    private final RsTypeAlias typeAlias;
    @Nullable
    private final RsReference reference;

    public RsInlineTypeAliasDialog(@NotNull RsTypeAlias typeAlias, @Nullable RsReference reference) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        RsNameIdentifierOwner rsNameIdentifierOwner = typeAlias;
        Project project = typeAlias.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(rsNameIdentifierOwner, reference, project);
        this.typeAlias = typeAlias;
        this.reference = reference;
        this.init();
    }

    @NotNull
    protected String getBorderTitle() {
        return RsBundle.INSTANCE.message("border.title.inline.type.alias", new Object[0]);
    }

    @NotNull
    protected String getNameLabelText() {
        Object[] objectArray = new Object[1];
        String string = this.typeAlias.getName();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return RsBundle.INSTANCE.message("label.type.alias", objectArray);
    }

    @NotNull
    protected String getInlineAllText() {
        return RsBundle.INSTANCE.message("radio.inline.all.remove.type.alias", new Object[0]);
    }

    @NotNull
    protected String getInlineThisText() {
        return RsBundle.INSTANCE.message("radio.inline.this.only.keep.type.alias", new Object[0]);
    }

    protected void doAction() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsInlineTypeAliasProcessor processor2 = new RsInlineTypeAliasProcessor(project, this.typeAlias, this.reference, this.isInlineThisOnly());
        this.invokeRefactoring(processor2);
    }
}

