/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineFunction;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveImportFixKt;
import org.rust.ide.refactoring.RsInlineUsageViewDescriptor;
import org.rust.ide.refactoring.RsNameSuggestionsKt;
import org.rust.ide.refactoring.inlineFunction.CallUsage;
import org.rust.ide.refactoring.inlineFunction.FunctionCallUsage;
import org.rust.ide.refactoring.inlineFunction.InlineSingleUsage;
import org.rust.ide.refactoring.inlineFunction.MethodCallUsage;
import org.rust.ide.refactoring.inlineFunction.ReferenceUsage;
import org.rust.ide.refactoring.inlineFunction.RsInlineFunctionProcessorKt;
import org.rust.ide.refactoring.inlineFunction.UseSpeckUsage;
import org.rust.lang.core.dfa.ExitPoint;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRefLikeType;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.RsWhileExpr;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;
import org.rust.lang.core.psi.ext.RsRefLikeTypeKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0017H\u0014J\u001b\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J \u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\f\u0010&\u001a\u00020\t*\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020,H\u0014J\u001b\u0010-\u001a\u00020.2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u00020.H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/RsInlineFunctionProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "originalFunction", "Lorg/rust/lang/core/psi/RsFunction;", "reference", "Lorg/rust/lang/core/resolve/ref/RsReference;", "inlineThisOnly", "", "removeDefinition", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/lang/core/psi/RsFunction;Lorg/rust/lang/core/resolve/ref/RsReference;ZZ)V", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "createUsageInfo", "Lcom/intellij/psi/PsiReference;", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "performRefactoring", "", "usages", "([Lcom/intellij/usageView/UsageInfo;)V", "handleUsage", "usage", "function", "inlineCallUsage", "Lorg/rust/ide/refactoring/inlineFunction/CallUsage;", "getArgumentsOfMethodCall", "", "Lorg/rust/lang/core/psi/RsExpr;", "methodCall", "Lorg/rust/lang/core/psi/RsMethodCall;", "isFirstParameterReference", "preprocessFunction", "replaceSelfParameter", "method", "replaceReturnWithTailExpr", "getCommandName", "", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "getElementsToWrite", "", "Lcom/intellij/psi/PsiElement;", "descriptor", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsInlineFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/RsInlineFunctionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 8 Collections.kt\norg/rust/stdext/CollectionsKt\n*L\n1#1,809:1\n1563#2:810\n1634#2,3:811\n1068#2:814\n1625#2:824\n1869#2:825\n1870#2:827\n1626#2:828\n37#3,2:815\n15#4:817\n1#5:818\n1#5:826\n3919#6:819\n4434#6,2:820\n127#7:822\n153#8:823\n*S KotlinDebug\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/RsInlineFunctionProcessor\n*L\n87#1:810\n87#1:811,3\n89#1:814\n182#1:824\n182#1:825\n182#1:827\n182#1:828\n90#1:815,2\n95#1:817\n182#1:826\n122#1:819\n122#1:820,2\n181#1:822\n182#1:823\n*E\n"})
public final class RsInlineFunctionProcessor
extends BaseRefactoringProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RsFunction originalFunction;
    @Nullable
    private final RsReference reference;
    private final boolean inlineThisOnly;
    private final boolean removeDefinition;
    @NotNull
    private final RsPsiFactory factory;

    public RsInlineFunctionProcessor(@NotNull Project project, @NotNull RsFunction originalFunction, @Nullable RsReference reference, boolean inlineThisOnly, boolean removeDefinition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalFunction, (String)"originalFunction");
        super(project);
        this.project = project;
        this.originalFunction = originalFunction;
        this.reference = reference;
        this.inlineThisOnly = inlineThisOnly;
        this.removeDefinition = removeDefinition;
        this.factory = new RsPsiFactory(this.project, false, false, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$mapTo$iv$iv;
        Iterable usages;
        Iterable iterable;
        if (this.inlineThisOnly && this.reference != null) {
            iterable = CollectionsKt.listOf((Object)this.reference);
        } else {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope projectScope = globalSearchScope;
            iterable = RsElementKt.searchReferences(this.originalFunction, (SearchScope)projectScope).asIterable();
        }
        Iterable $this$map$iv = usages = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PsiReference psiReference = (PsiReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createUsageInfo((PsiReference)p0));
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                UsageInfo it2 = (UsageInfo)b;
                boolean bl = false;
                PsiElement psiElement2 = it2.getElement();
                it2 = (UsageInfo)a;
                Comparable comparable = Integer.valueOf(psiElement2 != null ? PsiElementKt.getStartOffset(psiElement2) : 0);
                bl = false;
                PsiElement psiElement3 = it2.getElement();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(psiElement3 != null ? PsiElementKt.getStartOffset(psiElement3) : 0));
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    private final UsageInfo createUsageInfo(PsiReference reference) {
        Object object;
        PsiElement element;
        PsiElement psiElement2 = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        PsiElement $this$ancestorOrSelf$iv = element = psiElement2;
        boolean $i$f$ancestorOrSelf = false;
        RsUseSpeck useSpeck = (RsUseSpeck)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsUseSpeck.class, (boolean)false);
        RsInlineFunctionProcessor $this$createUsageInfo_u24lambda_u240 = this;
        boolean bl = false;
        RsPath rsPath = element instanceof RsPath ? (RsPath)element : null;
        PsiElement psiElement3 = rsPath != null ? rsPath.getParent() : null;
        RsPathExpr rsPathExpr = psiElement3 instanceof RsPathExpr ? (RsPathExpr)psiElement3 : null;
        if (rsPathExpr == null) {
            object = null;
        } else {
            RsPathExpr pathExpr = rsPathExpr;
            psiElement3 = pathExpr.getParent();
            RsCallExpr rsCallExpr = psiElement3 instanceof RsCallExpr ? (RsCallExpr)psiElement3 : null;
            if (rsCallExpr != null) {
                PsiElement it2 = psiElement3 = rsCallExpr;
                boolean bl2 = false;
                object = Intrinsics.areEqual((Object)it2.getExpr(), (Object)pathExpr) ? psiElement3 : null;
            } else {
                object = null;
            }
        }
        PsiElement functionCall = object;
        return element instanceof RsMethodCall && ((RsMethodCall)element).getParent() instanceof RsDotExpr ? (UsageInfo)new MethodCallUsage((RsMethodCall)element, reference) : (functionCall != null ? (UsageInfo)new FunctionCallUsage((RsCallExpr)functionCall, reference) : (useSpeck != null ? (UsageInfo)new UseSpeckUsage(useSpeck, reference) : (UsageInfo)new ReferenceUsage(reference)));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        Intrinsics.checkNotNull((Object)usages);
        for (UsageInfo usage : usages) {
            if (!this.removeDefinition || !(usage instanceof ReferenceUsage)) continue;
            conflicts.putValue((Object)((ReferenceUsage)usage).getElement(), (Object)"Cannot inline function reference");
        }
        return this.showConflicts(conflicts, usages);
    }

    /*
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        RsFunction function = this.preprocessFunction(this.originalFunction);
        UsageInfo[] $this$filter$iv = usages;
        boolean $i$f$filter = false;
        UsageInfo[] usageInfoArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void usage = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!this.handleUsage((UsageInfo)usage, function)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List handledUsages = (List)destination$iv$iv;
        if (this.removeDefinition && handledUsages.size() == usages.length) {
            RsElementKt.deleteWithPreviousWhitespace(this.originalFunction);
        }
    }

    private final boolean handleUsage(UsageInfo usage, RsFunction function) {
        boolean bl;
        UsageInfo usageInfo = usage;
        if (usageInfo instanceof ReferenceUsage) {
            bl = false;
        } else if (usageInfo instanceof UseSpeckUsage) {
            RemoveImportFixKt.deleteUseSpeck$default(((UseSpeckUsage)usage).getUseSpeck(), false, 2, null);
            bl = true;
        } else {
            bl = usageInfo instanceof CallUsage ? this.inlineCallUsage((CallUsage)usage, function) : false;
        }
        return bl;
    }

    private final boolean inlineCallUsage(CallUsage usage, RsFunction function) {
        List<RsExpr> list;
        CallUsage callUsage = usage;
        if (callUsage instanceof FunctionCallUsage) {
            List<RsExpr> list2 = ((FunctionCallUsage)usage).getFunctionCall().getValueArgumentList().getExprList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        } else if (callUsage instanceof MethodCallUsage) {
            list = this.getArgumentsOfMethodCall(((MethodCallUsage)usage).getMethodCall(), function);
            if (list == null) {
                return false;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<RsExpr> arguments = list;
        return new InlineSingleUsage(arguments, usage, this.originalFunction, function).invoke();
    }

    private final List<RsExpr> getArgumentsOfMethodCall(RsMethodCall methodCall, RsFunction function) {
        RsDotExpr rsDotExpr = methodCall.getParent();
        RsDotExpr rsDotExpr2 = rsDotExpr instanceof RsDotExpr ? rsDotExpr : null;
        if (rsDotExpr2 == null) {
            return null;
        }
        RsDotExpr dotExpr = rsDotExpr2;
        RsExpr callee = this.isFirstParameterReference(function) ? RsPsiFactory.createRefExpr$default(this.factory, dotExpr.getReceiver(), null, 2, null) : dotExpr.getReceiver();
        Collection collection = CollectionsKt.listOf((Object)callee);
        List<RsExpr> list = methodCall.getValueArgumentList().getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    private final boolean isFirstParameterReference(RsFunction $this$isFirstParameterReference) {
        RsValueParameterList rsValueParameterList = $this$isFirstParameterReference.getValueParameterList();
        if (rsValueParameterList == null) {
            return false;
        }
        RsValueParameterList valueParameterList = rsValueParameterList;
        List<RsValueParameter> list = valueParameterList.getValueParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameterList(...)");
        RsValueParameter rsValueParameter = (RsValueParameter)CollectionsKt.firstOrNull(list);
        if (rsValueParameter == null) {
            return false;
        }
        RsValueParameter firstParameter = rsValueParameter;
        RsTypeReference rsTypeReference = firstParameter.getTypeReference();
        RsRefLikeType rsRefLikeType = rsTypeReference instanceof RsRefLikeType ? (RsRefLikeType)rsTypeReference : null;
        return rsRefLikeType != null ? RsRefLikeTypeKt.isRef(rsRefLikeType) : false;
    }

    private final RsFunction preprocessFunction(RsFunction originalFunction) {
        PsiElement psiElement2 = originalFunction.copy();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFunction");
        RsFunction function = (RsFunction)psiElement2;
        PsiElement psiElement3 = originalFunction.getContext();
        RsElement rsElement = psiElement3 instanceof RsElement ? (RsElement)psiElement3 : null;
        if (rsElement != null) {
            RsElement it2 = rsElement;
            boolean bl = false;
            RsExpandedElementKt.setContext(function, it2);
        }
        this.replaceSelfParameter(function);
        this.replaceReturnWithTailExpr(function);
        return function;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceSelfParameter(RsFunction method) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        Iterable $this$descendantsOfType$iv;
        RsValueParameterList rsValueParameterList = method.getValueParameterList();
        if (rsValueParameterList == null) {
            return;
        }
        RsValueParameterList valueParameterList = rsValueParameterList;
        RsSelfParameter rsSelfParameter = valueParameterList.getSelfParameter();
        if (rsSelfParameter == null) {
            return;
        }
        RsSelfParameter selfParameter = rsSelfParameter;
        PsiElement psiElement2 = method;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsNameIdentifierOwner.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        $this$descendantsOfType$iv = collection;
        boolean $i$f$mapNotNullToSet = false;
        void var7_7 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new HashSet(org.rust.stdext.CollectionsKt.mapCapacity(org.rust.stdext.CollectionsKt.collectionSizeOrDefault($this$mapNotNullToSet$iv, 10)));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            RsNameIdentifierOwner it2 = (RsNameIdentifierOwner)element$iv$iv;
            boolean bl2 = false;
            if (it2.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set existingNames = (Set)destination$iv$iv;
        String newName = RsNameSuggestionsKt.freshenName("self", existingNames);
        RsInlineFunctionProcessorKt.access$renameUsages(selfParameter, newName, method);
        String ref = selfParameter.getAnd() != null ? "&" : "";
        Object object = selfParameter.getTypeReference();
        if (object == null || (object = object.getText()) == null) {
            object = ref + "Self";
        }
        Object selfType = object;
        PsiElement newParameter = this.factory.createMethodParam(newName + ": " + (String)selfType);
        selfParameter.replace(newParameter);
    }

    private final void replaceReturnWithTailExpr(RsFunction function) {
        RsBlock rsBlock = RsFunctionKt.getBlock(function);
        if (rsBlock == null) {
            return;
        }
        RsBlock block = rsBlock;
        List<RsStmt> list = block.getStmtList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStmtList(...)");
        Object object = CollectionsKt.lastOrNull(list);
        RsExprStmt rsExprStmt = object instanceof RsExprStmt ? (RsExprStmt)object : null;
        if (rsExprStmt == null) {
            return;
        }
        RsExprStmt lastStatement = rsExprStmt;
        RsExpr rsExpr = lastStatement.getExpr();
        RsRetExpr rsRetExpr = rsExpr instanceof RsRetExpr ? (RsRetExpr)rsExpr : null;
        if (rsRetExpr == null) {
            return;
        }
        RsRetExpr returnExpr = rsRetExpr;
        RsExpr rsExpr2 = returnExpr.getExpr();
        if (rsExpr2 == null) {
            return;
        }
        RsExpr returnValue = rsExpr2;
        PsiElement psiElement2 = lastStatement.getSemicolon();
        if (psiElement2 != null) {
            psiElement2.delete();
        }
        returnExpr.replace(returnValue);
    }

    @NotNull
    protected String getCommandName() {
        Object[] objectArray = new Object[1];
        String string = this.originalFunction.getName();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return RsBundle.INSTANCE.message("command.name.inline.function", objectArray);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new RsInlineUsageViewDescriptor(this.originalFunction, RsBundle.INSTANCE.message("list.item.function.to.inline", new Object[0]));
    }

    @NotNull
    protected Collection<PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.inlineThisOnly) {
            RsReference rsReference = this.reference;
            collection = CollectionsKt.listOfNotNull((Object)(rsReference != null ? rsReference.getElement() : null));
        } else if (this.originalFunction.isWritable()) {
            Object[] objectArray = new RsElement[2];
            RsReference rsReference = this.reference;
            objectArray[0] = rsReference != null ? rsReference.getElement() : null;
            objectArray[1] = this.originalFunction;
            collection = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/RsInlineFunctionProcessor$Companion;", "", "<init>", "()V", "doesFunctionHaveMultipleReturns", "", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "isFunctionRecursive", "checkIfLoopCondition", "element", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsInlineFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/RsInlineFunctionProcessor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 4 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,809:1\n1761#2,3:810\n1761#2,3:814\n127#3:813\n127#3:817\n15#4:818\n*S KotlinDebug\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/RsInlineFunctionProcessor$Companion\n*L\n223#1:810,3\n227#1:814,3\n227#1:813\n235#1:817\n239#1:818\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean doesFunctionHaveMultipleReturns(@NotNull RsFunction fn) {
            ExitPoint it2;
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            List entryPoints = new ArrayList();
            Function1 sink = arg_0 -> Companion.doesFunctionHaveMultipleReturns$lambda$0(entryPoints, arg_0);
            ExitPoint.Companion.process(fn, (Function1<? super ExitPoint, Unit>)sink);
            if (entryPoints.size() <= 1) return false;
            Iterable $this$any$iv = CollectionsKt.dropLast((List)entryPoints, (int)1);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it2 = (ExitPoint)element$iv;
                boolean bl = false;
            } while (!(it2 instanceof ExitPoint.Return));
            return true;
        }

        public final boolean isFunctionRecursive(@NotNull RsFunction fn) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
                PsiElement $this$descendantsOfType$iv = fn;
                boolean $i$f$descendantsOfType = false;
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPath.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RsPath it2 = (RsPath)element$iv;
                        boolean bl2 = false;
                        RsPathReference rsPathReference = it2.getReference();
                        if (!Intrinsics.areEqual((Object)(rsPathReference != null ? rsPathReference.resolve() : null), (Object)fn)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean checkIfLoopCondition(@NotNull RsFunction fn, @NotNull PsiElement element) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsBlock rsBlock = RsFunctionKt.getBlock(fn);
            if (rsBlock == null) {
                return false;
            }
            RsBlock block = rsBlock;
            Pair<List<RsStmt>, RsExpr> pair = RsBlockKt.getExpandedStmtsAndTailExpr(block);
            List statements = (List)pair.component1();
            RsExpr tailExpr = (RsExpr)pair.component2();
            if (tailExpr == null) {
                if (statements.size() <= 1) {
                    if (statements.size() != 1) return false;
                    PsiElement $this$descendantsOfType$iv = (PsiElement)statements.get(0);
                    boolean $i$f$descendantsOfType = false;
                    Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsRetExpr.class);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                    if (!collection.isEmpty()) return false;
                }
                bl = true;
            } else {
                if (((Collection)statements).isEmpty()) return false;
                bl = true;
            }
            boolean hasStatements = bl;
            if (!hasStatements) return false;
            PsiElement $this$ancestorOrSelf$iv = element;
            boolean $i$f$ancestorOrSelf = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsWhileExpr.class, (boolean)false) == null) return false;
            return true;
        }

        private static final Unit doesFunctionHaveMultipleReturns$lambda$0(List $entryPoints, ExitPoint it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            if (!(it2 instanceof ExitPoint.TryExpr)) {
                $entryPoints.add(it2);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

