/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineFunction;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.refactoring.inlineFunction.RsInlineFunctionDialog;
import org.rust.ide.refactoring.inlineFunction.RsInlineFunctionProcessor;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.resolve.ref.RsReference;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/RsInlineFunctionHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "<init>", "()V", "isEnabledOnElement", "", "element", "Lcom/intellij/psi/PsiElement;", "inlineElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabledForLanguage", "l", "Lcom/intellij/lang/Language;", "canInlineElementInEditor", "canInlineElement", "errorHint", "message", "", "Companion", "intellij.rustrover.core"})
public final class RsInlineFunctionHandler
extends InlineActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HELP_ID = "refactoring.inlineMethod";

    public boolean isEnabledOnElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.canInlineElement(element);
    }

    public void inlineElement(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsFunction function = (RsFunction)element;
        PsiReference reference = TargetElementUtil.findReference((Editor)editor2, (int)editor2.getCaretModel().getOffset());
        if (RsInlineFunctionProcessor.Companion.doesFunctionHaveMultipleReturns(function)) {
            this.errorHint(project, editor2, RsBundle.INSTANCE.message("dialog.message.cannot.inline.function.with.more.than.one.exit.points", new Object[0]));
            return;
        }
        boolean allowInlineThisOnly = false;
        if (RsInlineFunctionProcessor.Companion.isFunctionRecursive(function)) {
            if (reference != null) {
                allowInlineThisOnly = true;
            } else {
                this.errorHint(project, editor2, RsBundle.INSTANCE.message("dialog.message.cannot.inline.function.with.recursive.calls", new Object[0]));
                return;
            }
        }
        if (reference != null) {
            PsiElement psiElement2 = reference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
            if (RsInlineFunctionProcessor.Companion.checkIfLoopCondition(function, psiElement2)) {
                this.errorHint(project, editor2, RsBundle.INSTANCE.message("dialog.message.cannot.inline.multiline.function.into.while.loop.condition", new Object[0]));
                return;
            }
        }
        if (RsFunctionKt.getBlock(function) == null) {
            this.errorHint(project, editor2, RsBundle.INSTANCE.message("dialog.message.cannot.inline.empty.function", new Object[0]));
            return;
        }
        if (!UtilsKt.isUnitTestMode()) {
            RsInlineFunctionDialog dialog = new RsInlineFunctionDialog(function, (RsReference)reference, allowInlineThisOnly, null, 8, null);
            dialog.show();
            if (!dialog.isOK()) {
                StatusBar statusBar;
                StatusBar statusBar2 = statusBar = WindowManager.getInstance().getStatusBar(function.getProject());
                if (statusBar2 != null) {
                    statusBar2.setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                }
            }
        } else {
            RsInlineFunctionProcessor processor2 = new RsInlineFunctionProcessor(project, function, (RsReference)reference, false, true);
            processor2.run();
        }
    }

    public boolean isEnabledForLanguage(@Nullable Language l) {
        Language language = l;
        return language != null ? language.isKindOf((Language)RsLanguage.INSTANCE) : false;
    }

    public boolean canInlineElementInEditor(@NotNull PsiElement element, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.canInlineElement(element);
    }

    public boolean canInlineElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof RsFunction && ((RsFunction)element).getNavigationElement() instanceof RsFunction;
    }

    private final void errorHint(Project project, Editor editor2, @NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)RefactoringBundle.message((String)"inline.method.title"), (String)HELP_ID);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/RsInlineFunctionHandler$Companion;", "", "<init>", "()V", "HELP_ID", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

