/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineFunction;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.refactoring.RsInlineDialog;
import org.rust.ide.refactoring.inlineFunction.RsInlineFunctionProcessor;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.resolve.ref.RsReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\u0007H\u0014J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u000fH\u0014J\b\u0010\u0019\u001a\u00020\u000fH\u0014J\b\u0010\u001a\u001a\u00020\u000fH\u0014J\b\u0010\u001b\u001a\u00020\u000fH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u001d\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/RsInlineFunctionDialog;", "Lorg/rust/ide/refactoring/RsInlineDialog;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "refElement", "Lorg/rust/lang/core/resolve/ref/RsReference;", "allowInlineThisOnly", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/rust/lang/core/psi/RsFunction;Lorg/rust/lang/core/resolve/ref/RsReference;ZLcom/intellij/openapi/project/Project;)V", "occurrencesNumber", "", "callableType", "", "Lorg/jetbrains/annotations/Nls;", "canInlineThisOnly", "allowInlineAll", "ignoreOccurrence", "reference", "Lcom/intellij/psi/PsiReference;", "doAction", "", "getBorderTitle", "getNameLabelText", "getInlineAllText", "getInlineThisText", "getKeepTheDeclarationText", "getHelpId", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsInlineFunctionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsInlineFunctionDialog.kt\norg/rust/ide/refactoring/inlineFunction/RsInlineFunctionDialog\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,79:1\n9#2:80\n*S KotlinDebug\n*F\n+ 1 RsInlineFunctionDialog.kt\norg/rust/ide/refactoring/inlineFunction/RsInlineFunctionDialog\n*L\n40#1:80\n*E\n"})
public final class RsInlineFunctionDialog
extends RsInlineDialog {
    @NotNull
    private final RsFunction function;
    @Nullable
    private final RsReference refElement;
    private final boolean allowInlineThisOnly;
    private final int occurrencesNumber;
    @NotNull
    private final String callableType;

    public RsInlineFunctionDialog(@NotNull RsFunction function, @Nullable RsReference refElement, boolean allowInlineThisOnly, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(function, refElement, project);
        this.function = function;
        this.refElement = refElement;
        this.allowInlineThisOnly = allowInlineThisOnly;
        this.occurrencesNumber = this.getNumberOfOccurrences(this.function);
        this.callableType = RsFunctionKt.isMethod(this.function) ? RsBundle.INSTANCE.message("inspection.message.method", new Object[0]) : RsBundle.INSTANCE.message("function", new Object[0]);
        this.init();
    }

    public /* synthetic */ RsInlineFunctionDialog(RsFunction rsFunction, RsReference rsReference, boolean bl, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Project project2 = rsFunction.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
        }
        this(rsFunction, rsReference, bl, project);
    }

    protected boolean canInlineThisOnly() {
        return this.allowInlineThisOnly;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected boolean ignoreOccurrence(@NotNull PsiReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement psiElement2 = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        PsiElement $this$ancestorStrict$iv = psiElement2;
        boolean $i$f$ancestorStrict = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsUseItem.class, (boolean)true) == null;
    }

    protected void doAction() {
        boolean inlineThisOnly = this.allowInlineThisOnly || this.isInlineThisOnly();
        boolean removeDefinition = this.myRbInlineAll.isSelected() && this.function.isWritable();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsInlineFunctionProcessor processor2 = new RsInlineFunctionProcessor(project, this.function, this.refElement, inlineThisOnly, removeDefinition);
        this.invokeRefactoring(processor2);
    }

    @NotNull
    protected String getBorderTitle() {
        Object[] objectArray = new Object[]{this.callableType};
        return RsBundle.INSTANCE.message("border.title.inline", objectArray);
    }

    @NotNull
    protected String getNameLabelText() {
        return this.callableType + " " + this.function.getName() + " " + this.getOccurrencesText(this.occurrencesNumber);
    }

    @NotNull
    protected String getInlineAllText() {
        String text = this.function.isWritable() ? "all.invocations.and.remove.the.method" : "all.invocations.in.project";
        String string = RefactoringBundle.message((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getInlineThisText() {
        String string = RefactoringBundle.message((String)"this.invocation.only.and.keep.the.method");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        boolean mightHaveMultipleOccurrences = this.occurrencesNumber < 0 || this.occurrencesNumber > 1;
        return this.function.isWritable() && (mightHaveMultipleOccurrences || !this.myInvokedOnReference) ? RsBundle.INSTANCE.message("radio.inline.all.keep.method", new Object[0]) : null;
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.inlineMethod";
    }
}

