/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineFunction;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.fixes.AddMutableFixKt;
import org.rust.ide.refactoring.inlineFunction.RsInlineFunctionProcessorKt;
import org.rust.ide.refactoring.inlineValue.RsInlineValueProcessorKt;
import org.rust.lang.core.psi.MacroBraces;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0016\u0010\u0019\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007H\u0002J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0017*\u00020!H\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0017*\u00020!H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\u0017*\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/InsertFunctionBody;", "", "functionCall", "Lorg/rust/lang/core/psi/RsExpr;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "letDeclarations", "", "Lorg/rust/lang/core/psi/RsLetDecl;", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/lang/core/psi/RsFunction;Ljava/util/List;)V", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "bodyStatements", "Lorg/rust/lang/core/psi/ext/RsElement;", "invoke", "", "invokeIfBodyIsSingleExpression", "", "addLetDeclarationsToFunctionBody", "invokeIfFunctionCallIsStatement", "addSemicolonToLastStatementIfNeeded", "callStatement", "Lorg/rust/lang/core/psi/RsStmt;", "invokeIfFunctionCallUsedInLetDeclaration", "applyRenames", "renames", "Lorg/rust/ide/refactoring/inlineFunction/InsertFunctionBody$Rename;", "findRenames", "letDeclaration", "returnValue", "invokeGenericCase", "findOrCreateContainingStatement", "Lcom/intellij/psi/PsiElement;", "wrapInBlockExprIfPossible", "wrapInBlockExpr", "Rename", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsInlineFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/InsertFunctionBody\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,809:1\n1#2:810\n1563#3:811\n1634#3,3:812\n*S KotlinDebug\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/InsertFunctionBody\n*L\n646#1:811\n646#1:812,3\n*E\n"})
final class InsertFunctionBody {
    @NotNull
    private final RsExpr functionCall;
    @NotNull
    private final RsFunction function;
    @NotNull
    private final List<RsLetDecl> letDeclarations;
    @NotNull
    private final RsPsiFactory factory;
    private List<? extends RsElement> bodyStatements;

    public InsertFunctionBody(@NotNull RsExpr functionCall, @NotNull RsFunction function, @NotNull List<? extends RsLetDecl> letDeclarations) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(letDeclarations, (String)"letDeclarations");
        this.functionCall = functionCall;
        this.function = function;
        this.letDeclarations = letDeclarations;
        Project project = this.function.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.factory = new RsPsiFactory(project, false, false, 6, null);
    }

    public final void invoke() {
        RsBlock rsBlock = RsFunctionKt.getBlock(this.function);
        if (rsBlock == null) {
            return;
        }
        RsBlock functionBody = rsBlock;
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getNextNonCommentSibling(functionBody.getLbrace()), (Object)functionBody.getRbrace())) {
            PsiElement psiElement2 = this.functionCall.getParent();
            RsExprStmt rsExprStmt = psiElement2 instanceof RsExprStmt ? (RsExprStmt)psiElement2 : null;
            if (rsExprStmt != null) {
                rsExprStmt.delete();
            }
            return;
        }
        this.addLetDeclarationsToFunctionBody();
        this.bodyStatements = SequencesKt.toList(RsBlockKt.getStmtsAndMacros(functionBody));
        if (!(this.invokeIfBodyIsSingleExpression() || this.invokeIfFunctionCallIsStatement() || this.invokeIfFunctionCallUsedInLetDeclaration())) {
            this.invokeGenericCase();
        }
    }

    private final boolean invokeIfBodyIsSingleExpression() {
        Object object;
        if (!((Collection)this.letDeclarations).isEmpty()) {
            return false;
        }
        List<? extends RsElement> list = this.bodyStatements;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            list = null;
        }
        RsExprStmt rsExprStmt = (object = CollectionsKt.singleOrNull(list)) instanceof RsExprStmt ? (RsExprStmt)object : null;
        if (rsExprStmt == null) {
            return false;
        }
        RsExprStmt statement = rsExprStmt;
        if (statement.getSemicolon() != null || statement.textContains('\n')) {
            return false;
        }
        RsElement rsElement = this.functionCall;
        RsExpr rsExpr = statement.getExpr();
        Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
        RsInlineFunctionProcessorKt.access$unwrapTryExprIfPossible(RsInlineValueProcessorKt.replaceWithAddingParentheses(rsElement, rsExpr, this.factory));
        return true;
    }

    private final void addLetDeclarationsToFunctionBody() {
        String string;
        RsBlock rsBlock = RsFunctionKt.getBlock(this.function);
        if (rsBlock == null) {
            return;
        }
        RsBlock block = rsBlock;
        PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(block.getLbrace());
        if (psiElement2 == null) {
            return;
        }
        PsiElement firstStatement = psiElement2;
        PsiElement psiElement3 = firstStatement.getPrevSibling();
        Object object = psiElement3 instanceof PsiWhiteSpace ? (PsiWhiteSpace)psiElement3 : null;
        if ((object != null && (object = object.getText()) != null ? StringsKt.substringAfterLast$default((String)object, (char)'\n', null, (int)2, null) : (string = null)) == null) {
            string = "";
        }
        String indent = string;
        for (RsLetDecl letDeclaration : this.letDeclarations) {
            block.addBefore(letDeclaration, firstStatement);
            block.addBefore(this.factory.createWhitespace("\n" + indent), firstStatement);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean invokeIfFunctionCallIsStatement() {
        var2_1 = this.functionCall.getParent();
        v0 = var2_1 instanceof RsExprStmt != false ? (RsExprStmt)var2_1 : null;
        if (v0 == null) ** GOTO lbl-1000
        it = var3_2 = v0;
        $i$a$-takeIf-InsertFunctionBody$invokeIfFunctionCallIsStatement$callStatement$1 = false;
        v0 = it.getParent() instanceof RsBlock != false ? var3_2 : null;
        if (v0 != null) {
            v1 = v0;
        } else if ((v1 = this.wrapInBlockExprIfPossible(this.functionCall)) == null) {
            return false;
        }
        callStatement = v1;
        this.addSemicolonToLastStatementIfNeeded(callStatement);
        v2 = callStatement;
        v3 = this.bodyStatements;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            v3 = null;
        }
        v4 = (PsiElement)CollectionsKt.first(v3);
        v5 = this.bodyStatements;
        if (v5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            v5 = null;
        }
        RsInlineFunctionProcessorKt.access$replaceWithRange(v2, v4, (PsiElement)CollectionsKt.last(v5));
        return true;
    }

    private final void addSemicolonToLastStatementIfNeeded(RsStmt callStatement) {
        boolean lastStatementNeedSemicolon;
        RsElement lastStatement;
        RsElement rsElement;
        List<? extends RsElement> list = this.bodyStatements;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            list = null;
        }
        boolean bl = (rsElement = (lastStatement = (RsElement)CollectionsKt.last(list))) instanceof RsStmt ? ((RsStmt)lastStatement).getSemicolon() == null : (rsElement instanceof RsMacroCall ? ((RsMacroCall)lastStatement).getSemicolon() == null && RsMacroCallKt.getBracesKind((RsMacroCall)lastStatement) != MacroBraces.BRACES : (lastStatementNeedSemicolon = false));
        if (this.function.getRetType() != null && callStatement.getSemicolon() != null && lastStatementNeedSemicolon) {
            lastStatement.add(this.factory.createSemicolon());
        }
    }

    private final boolean invokeIfFunctionCallUsedInLetDeclaration() {
        StubBasedPsiElement<StubBase> stubBasedPsiElement;
        block9: {
            block8: {
                Object object;
                RsExprStmt rsExprStmt;
                List<? extends RsElement> list = this.bodyStatements;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
                    list = null;
                }
                RsExprStmt rsExprStmt2 = rsExprStmt = (object = CollectionsKt.last(list)) instanceof RsExprStmt ? (RsExprStmt)object : null;
                if (rsExprStmt == null) break block8;
                RsExprStmt it2 = stubBasedPsiElement = rsExprStmt;
                boolean bl = false;
                Object object2 = object = it2.getSemicolon() == null ? stubBasedPsiElement : null;
                if (object != null && (stubBasedPsiElement = object.getExpr()) != null) break block9;
            }
            return false;
        }
        StubBasedPsiElement<StubBase> returnValue = stubBasedPsiElement;
        stubBasedPsiElement = this.functionCall.getParent();
        RsLetDecl rsLetDecl = stubBasedPsiElement instanceof RsLetDecl ? (RsLetDecl)stubBasedPsiElement : null;
        if (rsLetDecl == null) {
            return false;
        }
        RsLetDecl outerDeclaration = rsLetDecl;
        List<Rename> list = this.findRenames(outerDeclaration, (RsExpr)returnValue);
        if (list == null) {
            return false;
        }
        List<Rename> renames = list;
        this.applyRenames(renames);
        PsiElement psiElement2 = outerDeclaration;
        List<? extends RsElement> list2 = this.bodyStatements;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            list2 = null;
        }
        PsiElement psiElement3 = (PsiElement)CollectionsKt.first(list2);
        List<? extends RsElement> list3 = this.bodyStatements;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            list3 = null;
        }
        RsInlineFunctionProcessorKt.access$replaceWithRange(psiElement2, psiElement3, (PsiElement)CollectionsKt.last((List)CollectionsKt.dropLast(list3, (int)1)));
        return true;
    }

    private final void applyRenames(List<Rename> renames) {
        RsBlock rsBlock = RsFunctionKt.getBlock(this.function);
        Intrinsics.checkNotNull((Object)rsBlock);
        Map innerDeclarations = RsInlineFunctionProcessorKt.access$getTopLevelDeclarations(rsBlock);
        for (Rename rename : renames) {
            List declarations;
            RsPatBinding declaration = rename.component1();
            String newName = rename.component2();
            boolean needMutable = rename.component3();
            List list = (List)innerDeclarations.get(declaration.getReferenceName());
            if (list == null) {
                list = CollectionsKt.listOf((Object)declaration);
            }
            if (!(declarations = list).contains(declaration)) {
                throw new IllegalStateException("Check failed.");
            }
            RsInlineFunctionProcessorKt.access$renameWithUsagesTo(declarations, newName, (RsElement)this.function);
            if (!needMutable) continue;
            Project project = this.function.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            AddMutableFixKt.updateMutable$default(project, declaration, false, 4, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<Rename> findRenames(RsLetDecl letDeclaration, RsExpr returnValue) {
        v0 = letDeclaration.getPat();
        if (v0 == null) {
            return null;
        }
        matches = RsInlineFunctionProcessorKt.access$matchPatternAndExpression(v0, returnValue);
        $this$map$iv = matches;
        $i$f$map = false;
        var6_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block12: {
                block11: {
                    var11_11 = (Pair)item$iv$iv;
                    var24_25 = destination$iv$iv;
                    $i$a$-map-InsertFunctionBody$findRenames$1 = false;
                    outerPat = (RsPat)var11_11.component1();
                    returnExpr = (RsExpr)var11_11.component2();
                    if ((outerPat instanceof RsPatIdent != false ? (RsPatIdent)outerPat : null) == null) {
                        return null;
                    }
                    outerDeclaration = outerDeclaration;
                    newName = outerDeclaration.getPatBinding().getReferenceName();
                    v1 /* !! */  = returnExpr instanceof RsPathExpr != false ? (RsPathExpr)returnExpr : null;
                    if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getPath()) == null) break block11;
                    it = var17_17 = v1 /* !! */ ;
                    $i$a$-takeIf-InsertFunctionBody$findRenames$1$returnPath$1 = false;
                    v1 /* !! */  = it.getPath() == null != false ? var17_17 : null;
                    if (v1 /* !! */  != null) break block12;
                }
                return null;
            }
            returnPath = v1 /* !! */ ;
            v2 = returnPath.getReference();
            var21_22 = v2 != null ? v2.resolve() : null;
            v3 = var21_22 instanceof RsPatBinding != false ? (RsPatBinding)var21_22 : null;
            if (v3 == null) {
                return null;
            }
            innerDeclaration = v3;
            if (RsInlineFunctionProcessorKt.access$containingLetDeclaration(innerDeclaration) == null) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)innerFullDeclaration.getParent(), (Object)RsFunctionKt.getBlock(this.function))) {
                return null;
            }
            v4 = outerDeclaration.getPatBinding().getBindingMode();
            if ((v4 != null ? v4.getMut() : null) == null) ** GOTO lbl-1000
            v5 = innerDeclaration.getBindingMode();
            if ((v5 != null ? v5.getMut() : null) == null) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            needMutable = v6;
            var24_25.add(new Rename(innerDeclaration, newName, needMutable));
        }
        return (List)destination$iv$iv;
    }

    private final boolean invokeGenericCase() {
        Pair pair;
        PsiElement tailExpr;
        RsElement lastStmt;
        List<? extends RsElement> list = this.bodyStatements;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            list = null;
        }
        Object object = (lastStmt = (RsElement)CollectionsKt.last(list)) instanceof RsExprStmt ? (PsiElement)((RsExprStmt)lastStmt).getExpr() : (tailExpr = lastStmt instanceof RsMacroCall ? (PsiElement)lastStmt : null);
        if (tailExpr != null) {
            List<? extends RsElement> list2 = this.bodyStatements;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
                list2 = null;
            }
            pair = TuplesKt.to((Object)tailExpr, (Object)CollectionsKt.lastOrNull((List)CollectionsKt.dropLast(list2, (int)1)));
        } else {
            RsExpr rsExpr = this.factory.createExpression("()");
            List<? extends RsElement> list3 = this.bodyStatements;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
                list3 = null;
            }
            pair = TuplesKt.to((Object)rsExpr, (Object)CollectionsKt.last(list3));
        }
        Pair pair2 = pair;
        PsiElement returnValue = (PsiElement)pair2.component1();
        RsElement lastBodyStatement = (RsElement)pair2.component2();
        PsiElement functionCallReplaced = RsInlineFunctionProcessorKt.access$unwrapTryExprIfPossible(RsInlineValueProcessorKt.replaceWithAddingParentheses(this.functionCall, (RsElement)returnValue, this.factory));
        if (lastBodyStatement == null) {
            return true;
        }
        RsStmt rsStmt = this.findOrCreateContainingStatement(functionCallReplaced);
        if (rsStmt == null) {
            return false;
        }
        RsStmt containingStatement = rsStmt;
        PsiElement psiElement2 = containingStatement.getParent();
        List<? extends RsElement> list4 = this.bodyStatements;
        if (list4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bodyStatements");
            list4 = null;
        }
        psiElement2.addRangeBefore((PsiElement)CollectionsKt.first(list4), (PsiElement)lastBodyStatement, (PsiElement)containingStatement);
        return true;
    }

    private final RsStmt findOrCreateContainingStatement(PsiElement $this$findOrCreateContainingStatement) {
        for (PsiElement element : PsiElementKt.getAncestors($this$findOrCreateContainingStatement)) {
            if (element.getParent() instanceof RsBlock) {
                return element instanceof RsStmt ? (RsStmt)element : null;
            }
            RsStmt rsStmt = this.wrapInBlockExprIfPossible(element);
            if (rsStmt == null) continue;
            RsStmt it2 = rsStmt;
            boolean bl = false;
            return it2;
        }
        if (UtilsKt.isUnitTestMode()) {
            throw new IllegalStateException("Can't find containing statement".toString());
        }
        return null;
    }

    private final RsStmt wrapInBlockExprIfPossible(PsiElement $this$wrapInBlockExprIfPossible) {
        block7: {
            RsExpr rsExpr;
            PsiElement parent2 = $this$wrapInBlockExprIfPossible.getParent();
            if (parent2 instanceof RsMatchArm) {
                rsExpr = ((RsMatchArm)parent2).getExpr();
            } else if (parent2 instanceof RsLambdaExpr) {
                rsExpr = ((RsLambdaExpr)parent2).getExpr();
            } else if (parent2 instanceof RsConstant) {
                rsExpr = ((RsConstant)parent2).getExpr();
            } else {
                return null;
            }
            RsExpr expr = rsExpr;
            if (!Intrinsics.areEqual((Object)expr, (Object)$this$wrapInBlockExprIfPossible)) {
                return null;
            }
            PsiElement psiElement2 = $this$wrapInBlockExprIfPossible.getParent();
            RsMatchArm rsMatchArm = psiElement2 instanceof RsMatchArm ? (RsMatchArm)psiElement2 : null;
            if (rsMatchArm == null || (rsMatchArm = rsMatchArm.getComma()) == null) break block7;
            rsMatchArm.delete();
        }
        return this.wrapInBlockExpr($this$wrapInBlockExprIfPossible);
    }

    private final RsStmt wrapInBlockExpr(PsiElement $this$wrapInBlockExpr) {
        Project project = $this$wrapInBlockExpr.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsBlockExpr blockExpr0 = new RsPsiFactory(project, false, false, 6, null).createBlockExpr("\n" + $this$wrapInBlockExpr.getText() + "\n");
        PsiElement psiElement2 = $this$wrapInBlockExpr.replace((PsiElement)blockExpr0);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsBlockExpr");
        RsBlockExpr blockExpr = (RsBlockExpr)psiElement2;
        List<RsStmt> list = blockExpr.getBlock().getStmtList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStmtList(...)");
        return (RsStmt)CollectionsKt.singleOrNull(list);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/InsertFunctionBody$Rename;", "", "innerDeclaration", "Lorg/rust/lang/core/psi/RsPatBinding;", "newName", "", "needMutable", "", "<init>", "(Lorg/rust/lang/core/psi/RsPatBinding;Ljava/lang/String;Z)V", "getInnerDeclaration", "()Lorg/rust/lang/core/psi/RsPatBinding;", "getNewName", "()Ljava/lang/String;", "getNeedMutable", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class Rename {
        @NotNull
        private final RsPatBinding innerDeclaration;
        @NotNull
        private final String newName;
        private final boolean needMutable;

        public Rename(@NotNull RsPatBinding innerDeclaration, @NotNull String newName, boolean needMutable) {
            Intrinsics.checkNotNullParameter((Object)innerDeclaration, (String)"innerDeclaration");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.innerDeclaration = innerDeclaration;
            this.newName = newName;
            this.needMutable = needMutable;
        }

        @NotNull
        public final RsPatBinding getInnerDeclaration() {
            return this.innerDeclaration;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        public final boolean getNeedMutable() {
            return this.needMutable;
        }

        @NotNull
        public final RsPatBinding component1() {
            return this.innerDeclaration;
        }

        @NotNull
        public final String component2() {
            return this.newName;
        }

        public final boolean component3() {
            return this.needMutable;
        }

        @NotNull
        public final Rename copy(@NotNull RsPatBinding innerDeclaration, @NotNull String newName, boolean needMutable) {
            Intrinsics.checkNotNullParameter((Object)innerDeclaration, (String)"innerDeclaration");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            return new Rename(innerDeclaration, newName, needMutable);
        }

        public static /* synthetic */ Rename copy$default(Rename rename, RsPatBinding rsPatBinding, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                rsPatBinding = rename.innerDeclaration;
            }
            if ((n & 2) != 0) {
                string = rename.newName;
            }
            if ((n & 4) != 0) {
                bl = rename.needMutable;
            }
            return rename.copy(rsPatBinding, string, bl);
        }

        @NotNull
        public String toString() {
            return "Rename(innerDeclaration=" + this.innerDeclaration + ", newName=" + this.newName + ", needMutable=" + this.needMutable + ")";
        }

        public int hashCode() {
            int result2 = this.innerDeclaration.hashCode();
            result2 = result2 * 31 + this.newName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.needMutable);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rename)) {
                return false;
            }
            Rename rename = (Rename)other;
            if (!Intrinsics.areEqual((Object)this.innerDeclaration, (Object)rename.innerDeclaration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newName, (Object)rename.newName)) {
                return false;
            }
            return this.needMutable == rename.needMutable;
        }
    }
}

