/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.inlineFunction;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.fixes.AddMutableFixKt;
import org.rust.ide.fixes.ChangeToFieldShorthandFix;
import org.rust.ide.refactoring.RsNameSuggestionsKt;
import org.rust.ide.refactoring.inlineFunction.CallUsage;
import org.rust.ide.refactoring.inlineFunction.FunctionCallUsage;
import org.rust.ide.refactoring.inlineFunction.InsertFunctionBody;
import org.rust.ide.refactoring.inlineFunction.MethodCallUsage;
import org.rust.ide.refactoring.inlineFunction.RsInlineFunctionProcessorKt;
import org.rust.ide.refactoring.inlineTypeAlias.RsInlineTypeAliasProcessorKt;
import org.rust.ide.refactoring.inlineValue.RsInlineValueProcessorKt;
import org.rust.lang.core.dfa.liveness.Liveness;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsBindingMode;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsCodeFragmentFactory;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFieldLookup;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsMacroBodyIdent;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsFieldLookupKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;
import org.rust.lang.core.psi.ext.UnaryOperator;
import org.rust.lang.core.resolve.NamespaceKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.Substitution;
import org.rust.lang.core.types.infer.RsInferenceResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002:;B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012\u0018\u00010\u0003H\u0002J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u00120\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0003H\u0002J&\u0010\u001d\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004H\u0002J&\u0010!\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J&\u0010#\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0003H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u000201\u0012\u0006\u0012\u0004\u0018\u00010100H\u0002J&\u00102\u001a\u00020.2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u000201\u0012\u0006\u0012\u0004\u0018\u00010100H\u0002J\u0012\u00103\u001a\b\u0012\u0004\u0012\u00020104*\u00020\u001cH\u0002J\u0010\u00105\u001a\u00020.2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020.H\u0002J\b\u00107\u001a\u00020.H\u0002J\u000e\u00108\u001a\u0004\u0018\u000109*\u00020\u0006H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage;", "", "arguments", "", "Lorg/rust/lang/core/psi/RsExpr;", "usage", "Lorg/rust/ide/refactoring/inlineFunction/CallUsage;", "originalFunction", "Lorg/rust/lang/core/psi/RsFunction;", "function", "<init>", "(Ljava/util/List;Lorg/rust/ide/refactoring/inlineFunction/CallUsage;Lorg/rust/lang/core/psi/RsFunction;Lorg/rust/lang/core/psi/RsFunction;)V", "functionCall", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "invoke", "", "matchParametersAndArguments", "Lkotlin/Pair;", "Lorg/rust/lang/core/psi/RsPat;", "substituteParametersInFunctionBody", "Lorg/rust/lang/core/psi/RsLetDecl;", "parametersAndArguments", "trySubstituteParameterDirectly", "parameter", "argument", "trySubstituteSimpleLiteral", "usages", "Lorg/rust/lang/core/psi/ext/RsElement;", "trySubstituteVariable", "parameterUsages", "parameterIsMut", "argumentExpr", "substituteVariablePassedByValue", "Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage$VariableArgumentInfo;", "substituteVariablePassedByReference", "parseExprAsVariableArgument", "tryMakeDeclarationMutable", "Lorg/rust/lang/core/psi/RsPath;", "isLastUsageOfDeclaration", "declaration", "Lorg/rust/lang/core/psi/RsPatBinding;", "prepareFunctionCall", "unwrapAwait", "preprocessFunction", "renameParametersIfNecessary", "", "getFreshName", "Lkotlin/Function1;", "", "renameTopLevelDeclarationsIfNecessary", "getAllVisibleBindingsIncludingContainingLetDeclaration", "", "expandStructLiteralFieldsShorthand", "collapseStructLiteralFieldsShorthand", "replaceSelfWithActualType", "getSubstitution", "Lorg/rust/lang/core/types/Substitution;", "VariableArgumentType", "VariableArgumentInfo", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsInlineFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/InlineSingleUsage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 6 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,809:1\n1#2:810\n1#2:825\n1#2:849\n1563#3:811\n1634#3,3:812\n1617#3,9:815\n1869#3:824\n1870#3:826\n1626#3:827\n1563#3:828\n1634#3,3:829\n1761#3,3:832\n1563#3:835\n1634#3,3:836\n1761#3,3:843\n1625#3:847\n1869#3:848\n1870#3:850\n1626#3:851\n1563#3:855\n1634#3,3:856\n774#3:862\n865#3,2:863\n66#4,2:839\n66#4,2:841\n127#5:846\n127#5:852\n127#5:854\n127#5:859\n127#5:860\n127#5:861\n9#6:853\n*S KotlinDebug\n*F\n+ 1 RsInlineFunctionProcessor.kt\norg/rust/ide/refactoring/inlineFunction/InlineSingleUsage\n*L\n295#1:825\n430#1:849\n270#1:811\n270#1:812,3\n295#1:815,9\n295#1:824\n295#1:826\n295#1:827\n305#1:828\n305#1:829,3\n320#1:832,3\n358#1:835\n358#1:836,3\n408#1:843,3\n430#1:847\n430#1:848\n430#1:850\n430#1:851\n471#1:855\n471#1:856,3\n514#1:862\n514#1:863,2\n403#1:839,2\n404#1:841,2\n430#1:846\n451#1:852\n470#1:854\n478#1:859\n488#1:860\n513#1:861\n468#1:853\n*E\n"})
final class InlineSingleUsage {
    @NotNull
    private final List<RsExpr> arguments;
    @NotNull
    private final CallUsage usage;
    @NotNull
    private final RsFunction originalFunction;
    @NotNull
    private final RsExpr functionCall;
    @NotNull
    private final RsPsiFactory factory;
    @NotNull
    private final RsFunction function;

    public InlineSingleUsage(@NotNull List<? extends RsExpr> arguments, @NotNull CallUsage usage, @NotNull RsFunction originalFunction, @NotNull RsFunction function) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        Intrinsics.checkNotNullParameter((Object)originalFunction, (String)"originalFunction");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.arguments = arguments;
        this.usage = usage;
        this.originalFunction = originalFunction;
        this.functionCall = this.prepareFunctionCall(this.usage);
        Project project = this.functionCall.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.factory = new RsPsiFactory(project, false, false, 6, null);
        this.function = this.preprocessFunction(function);
    }

    public final boolean invoke() {
        List<Pair<RsPat, RsExpr>> list = this.matchParametersAndArguments();
        if (list == null) {
            return false;
        }
        List<Pair<RsPat, RsExpr>> parametersAndArguments = list;
        List<RsLetDecl> letDeclarations = this.substituteParametersInFunctionBody(parametersAndArguments);
        this.collapseStructLiteralFieldsShorthand();
        this.replaceSelfWithActualType();
        new InsertFunctionBody(this.functionCall, this.function, letDeclarations).invoke();
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Pair<RsPat, RsExpr>> matchParametersAndArguments() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RsValueParameterList rsValueParameterList = this.function.getValueParameterList();
        if (rsValueParameterList == null) return null;
        List<RsValueParameter> list = rsValueParameterList;
        RsValueParameterList it2 = list;
        boolean $i$a$-takeIf-InlineSingleUsage$matchParametersAndArguments$parameters$22 = false;
        if (it2.getVariadic() != null) return null;
        boolean bl = true;
        if (!bl) return null;
        RsValueParameterList rsValueParameterList2 = list;
        RsValueParameterList rsValueParameterList3 = rsValueParameterList2;
        if (rsValueParameterList3 == null) return null;
        list = rsValueParameterList3.getValueParameterList();
        if (list == null) return null;
        Iterable $i$a$-takeIf-InlineSingleUsage$matchParametersAndArguments$parameters$22 = list;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            RsValueParameter rsValueParameter = (RsValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            RsPat rsPat = it3.getPat();
            if (rsPat == null) {
                return null;
            }
            collection.add(rsPat);
        }
        List parameters = (List)destination$iv$iv;
        if (parameters.size() == this.arguments.size()) return RsInlineFunctionProcessorKt.access$matchPatternsAndExpressions(parameters, this.arguments);
        return null;
    }

    private final List<RsLetDecl> substituteParametersInFunctionBody(List<? extends Pair<? extends RsPat, ? extends RsExpr>> parametersAndArguments) {
        List letDeclarations = new ArrayList();
        for (Pair<? extends RsPat, ? extends RsExpr> pair : parametersAndArguments) {
            RsExpr argument;
            RsPat parameter = (RsPat)pair.component1();
            if (this.trySubstituteParameterDirectly(parameter, argument = (RsExpr)pair.component2())) continue;
            Collection collection = letDeclarations;
            RsStmt rsStmt = this.factory.createStatement("let " + parameter.getText() + " = " + argument.getText() + ";");
            Intrinsics.checkNotNull((Object)rsStmt, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsLetDecl");
            collection.add((RsLetDecl)rsStmt);
        }
        return letDeclarations;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean trySubstituteParameterDirectly(RsPat parameter, RsExpr argument) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        RsBindingMode bindingMode;
        RsElement rsElement = parameter instanceof RsPatIdent ? (RsPatIdent)parameter : null;
        if (rsElement == null || (rsElement = rsElement.getPatBinding()) == null) {
            return false;
        }
        RsElement patBinding = rsElement;
        RsBindingMode rsBindingMode = bindingMode = patBinding.getBindingMode();
        if ((rsBindingMode != null ? rsBindingMode.getRef() : null) != null) {
            return false;
        }
        RsBindingMode rsBindingMode2 = bindingMode;
        boolean parameterIsMut = (rsBindingMode2 != null ? rsBindingMode2.getMut() : null) != null;
        Iterable iterable = RsElementKt.searchReferences(patBinding, (SearchScope)new LocalSearchScope((PsiElement)this.function)).asIterable();
        boolean $i$f$mapNotNull = false;
        void var9_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RsElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiReference it2 = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement2 = it2.getElement();
            if ((psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List usages = (List)destination$iv$iv;
        if (usages.isEmpty() && !RsExprKt.getHasSideEffects(argument)) {
            return true;
        }
        if (this.trySubstituteVariable(usages, parameterIsMut, argument)) {
            return true;
        }
        return !parameterIsMut && this.trySubstituteSimpleLiteral(argument, usages);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean trySubstituteSimpleLiteral(RsExpr argument, List<? extends RsElement> usages) {
        void $this$mapTo$iv$iv;
        if (!RsInlineFunctionProcessorKt.access$isSimpleLiteral(argument, usages.size() == 1)) {
            return false;
        }
        Iterable $this$map$iv = usages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsElement rsElement = (RsElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement2 = it2.getParent();
            RsPathExpr rsPathExpr = psiElement2 instanceof RsPathExpr ? (RsPathExpr)psiElement2 : null;
            if (rsPathExpr == null) {
                return false;
            }
            collection.add(rsPathExpr);
        }
        List usagesExprs = (List)destination$iv$iv;
        for (RsPathExpr usage : usagesExprs) {
            RsInlineValueProcessorKt.replaceWithAddingParentheses(usage, argument, this.factory);
        }
        return true;
    }

    private final boolean trySubstituteVariable(List<? extends RsElement> parameterUsages, boolean parameterIsMut, RsExpr argumentExpr) {
        boolean bl;
        boolean hasNameConflict;
        VariableArgumentInfo argument;
        block10: {
            VariableArgumentInfo variableArgumentInfo = this.parseExprAsVariableArgument(argumentExpr);
            if (variableArgumentInfo == null) {
                return false;
            }
            argument = variableArgumentInfo;
            Iterable $this$any$iv = parameterUsages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RsElement it2 = (RsElement)element$iv;
                    boolean bl2 = false;
                    if (!RsElementKt.getLocalVariableVisibleBindings(it2).containsKey(argument.getName())) continue;
                    v1 = true;
                    break block10;
                }
                v1 = hasNameConflict = false;
            }
        }
        if (hasNameConflict) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[argument.getType().ordinal()]) {
            case 1: {
                bl = this.substituteVariablePassedByValue(argument, parameterUsages, parameterIsMut);
                break;
            }
            case 2: {
                if (parameterIsMut) {
                    return false;
                }
                bl = this.substituteVariablePassedByReference(argument, argumentExpr, parameterUsages);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean substituteVariablePassedByValue(VariableArgumentInfo argument, List<? extends RsElement> parameterUsages, boolean parameterIsMut) {
        if (parameterIsMut && !this.tryMakeDeclarationMutable(argument.getPath())) {
            return false;
        }
        for (RsElement rsElement : parameterUsages) {
            PsiElement psiElement2;
            RsElement rsElement2 = rsElement;
            if (rsElement2 instanceof RsPath) {
                psiElement2 = rsElement.replace(argument.getPath());
                continue;
            }
            if (!(rsElement2 instanceof RsMacroBodyIdent)) continue;
            PsiElement identifier = this.factory.createIdentifier(argument.getName());
            psiElement2 = ((RsMacroBodyIdent)rsElement).getIdentifier().replace(identifier);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean substituteVariablePassedByReference(VariableArgumentInfo argument, RsExpr argumentExpr, List<? extends RsElement> parameterUsages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = parameterUsages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsElement rsElement = (RsElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement2 = it2.getParent();
            RsPathExpr rsPathExpr = psiElement2 instanceof RsPathExpr ? (RsPathExpr)psiElement2 : null;
            if (rsPathExpr == null) {
                return false;
            }
            collection.add(rsPathExpr);
        }
        List parameterUsagesExprs = (List)destination$iv$iv;
        for (RsPathExpr usage : parameterUsagesExprs) {
            PsiElement parent2 = usage.getParent();
            boolean isMethodOrField = parent2 instanceof RsDotExpr && Intrinsics.areEqual((Object)((RsDotExpr)parent2).getReceiver(), (Object)usage);
            boolean isCallExpr = parent2 instanceof RsCallExpr && Intrinsics.areEqual((Object)((RsCallExpr)parent2).getExpr(), (Object)usage);
            PsiElement psiElement3 = isMethodOrField || isCallExpr ? usage.getPath().replace(argument.getPath()) : (parent2 instanceof RsUnaryExpr && RsExprKt.getOperatorType((RsUnaryExpr)parent2) == UnaryOperator.DEREF ? ((RsUnaryExpr)parent2).replace(this.factory.createExpression(argument.getName())) : usage.replace(argumentExpr));
        }
        return true;
    }

    private final VariableArgumentInfo parseExprAsVariableArgument(RsExpr argument) {
        VariableArgumentType argumentType;
        RsExpr rsExpr = RsExprKt.unwrapReference(argument);
        StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
        if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
            return null;
        }
        StubBasedPsiElement<RsPlaceholderStub<?>> path = stubBasedPsiElement;
        VariableArgumentType variableArgumentType = argumentType = argument instanceof RsPathExpr ? VariableArgumentType.PLAIN : VariableArgumentType.REF;
        if (path.getPath() != null) {
            return null;
        }
        String string = path.getReferenceName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        return new VariableArgumentInfo((RsPath)path, name2, argumentType);
    }

    private final boolean tryMakeDeclarationMutable(RsPath argument) {
        RsPathReference rsPathReference = argument.getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsPatBinding rsPatBinding = rsElement instanceof RsPatBinding ? (RsPatBinding)rsElement : null;
        if (rsPatBinding == null) {
            return false;
        }
        RsPatBinding declaration = rsPatBinding;
        if (!this.isLastUsageOfDeclaration(declaration, argument)) {
            return false;
        }
        RsBindingMode rsBindingMode = declaration.getBindingMode();
        if ((rsBindingMode != null ? rsBindingMode.getMut() : null) != null) {
            return true;
        }
        Project project = this.function.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AddMutableFixKt.updateMutable$default(project, declaration, false, 4, null);
        return true;
    }

    private final boolean isLastUsageOfDeclaration(RsPatBinding declaration, RsPath usage) {
        boolean bl;
        block7: {
            PsiElement $this$parentOfType_u24default$iv = usage;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            RsFunction rsFunction = (RsFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsFunction.class, (boolean)true);
            if (rsFunction == null) {
                return false;
            }
            RsFunction scope = rsFunction;
            PsiElement $this$parentOfType_u24default$iv2 = declaration;
            boolean withSelf$iv2 = false;
            boolean $i$f$parentOfType2 = false;
            if (!Intrinsics.areEqual((Object)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, RsFunction.class, (boolean)true), (Object)scope)) {
                return false;
            }
            Object object = ExtensionsKt.getLiveness(scope);
            if (object == null || (object = ((Liveness)object).getLastUsages()) == null) {
                return false;
            }
            Object lastUsages = object;
            List list = (List)lastUsages.get(declaration);
            if (list == null) {
                return false;
            }
            List declarationLastUsages = list;
            Iterable $this$any$iv = declarationLastUsages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RsElement it2 = (RsElement)element$iv;
                    boolean bl2 = false;
                    if (!(it2 instanceof RsPathExpr && Intrinsics.areEqual((Object)((RsPathExpr)it2).getPath(), (Object)usage))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final RsExpr prepareFunctionCall(CallUsage usage) {
        RsExpr rsExpr;
        CallUsage callUsage = usage;
        if (callUsage instanceof FunctionCallUsage) {
            rsExpr = ((FunctionCallUsage)usage).getFunctionCall();
        } else if (callUsage instanceof MethodCallUsage) {
            RsDotExpr rsDotExpr = ((MethodCallUsage)usage).getMethodCall().getParent();
            Intrinsics.checkNotNull((Object)rsDotExpr, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.ext.RsDotExpr");
            rsExpr = rsDotExpr;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RsExpr functionCall = rsExpr;
        RsExpr rsExpr2 = this.unwrapAwait(functionCall);
        if (rsExpr2 == null) {
            rsExpr2 = functionCall;
        }
        return rsExpr2;
    }

    private final RsExpr unwrapAwait(RsExpr $this$unwrapAwait) {
        if (!RsFunctionKt.isAsync(this.originalFunction)) {
            return null;
        }
        PsiElement psiElement2 = $this$unwrapAwait.getParent();
        RsFieldLookupExpr parent2 = psiElement2 instanceof RsFieldLookupExpr ? (RsFieldLookupExpr)psiElement2 : null;
        RsElement rsElement = parent2;
        if (!(rsElement != null && (rsElement = rsElement.getFieldLookup()) != null ? RsFieldLookupKt.isAsync((RsFieldLookup)rsElement) : false)) {
            return null;
        }
        PsiElement psiElement3 = parent2.replace($this$unwrapAwait);
        Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsExpr");
        return (RsExpr)psiElement3;
    }

    /*
     * WARNING - void declaration
     */
    private final RsFunction preprocessFunction(RsFunction originalFunction) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Set<String> outerScopeNames = this.getAllVisibleBindingsIncludingContainingLetDeclaration(this.functionCall);
        Object $this$descendantsOfType$iv = this.function;
        boolean $i$f$descendantsOfType22 = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsNameIdentifierOwner.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        $this$descendantsOfType$iv = collection;
        Collection $i$f$descendantsOfType22 = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            RsNameIdentifierOwner it2 = (RsNameIdentifierOwner)element$iv;
            boolean bl2 = false;
            if (it2.getName() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet functionNames = (HashSet)destination$iv;
        HashSet usedNames = CollectionsKt.toHashSet((Iterable)SetsKt.plus(outerScopeNames, (Iterable)functionNames));
        Function1 getFreshName = arg_0 -> InlineSingleUsage.preprocessFunction$lambda$1(outerScopeNames, usedNames, arg_0);
        PsiElement psiElement2 = originalFunction.copy();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsFunction");
        RsFunction function = (RsFunction)psiElement2;
        PsiElement psiElement3 = originalFunction.getContext();
        RsElement rsElement = psiElement3 instanceof RsElement ? (RsElement)psiElement3 : null;
        if (rsElement != null) {
            RsElement it3 = rsElement;
            boolean bl = false;
            RsExpandedElementKt.setContext(function, it3);
        }
        this.expandStructLiteralFieldsShorthand(function);
        this.renameParametersIfNecessary(function, (Function1<? super String, String>)getFreshName);
        this.renameTopLevelDeclarationsIfNecessary(function, (Function1<? super String, String>)getFreshName);
        return function;
    }

    private final void renameParametersIfNecessary(RsFunction function, Function1<? super String, String> getFreshName) {
        RsValueParameterList rsValueParameterList = function.getValueParameterList();
        if (rsValueParameterList == null) {
            return;
        }
        RsValueParameterList parameters = rsValueParameterList;
        PsiElement $this$descendantsOfType$iv = parameters;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPatIdent.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        for (RsPatIdent patIdent : collection) {
            String freshName;
            String patName = patIdent.getPatBinding().getReferenceName();
            if ((String)getFreshName.invoke((Object)patName) == null) continue;
            RsPatBinding rsPatBinding = patIdent.getPatBinding();
            Intrinsics.checkNotNullExpressionValue((Object)rsPatBinding, (String)"getPatBinding(...)");
            RsInlineFunctionProcessorKt.access$renameWithUsagesTo(rsPatBinding, freshName, (RsElement)function);
        }
    }

    private final void renameTopLevelDeclarationsIfNecessary(RsFunction function, Function1<? super String, String> getFreshName) {
        RsBlock rsBlock = RsFunctionKt.getBlock(function);
        if (rsBlock == null) {
            return;
        }
        RsBlock block = rsBlock;
        Map declarationsByName = RsInlineFunctionProcessorKt.access$getTopLevelDeclarations(block);
        for (Map.Entry entry2 : declarationsByName.entrySet()) {
            String freshName;
            String name2 = (String)entry2.getKey();
            List declarations = (List)entry2.getValue();
            if ((String)getFreshName.invoke((Object)name2) == null) continue;
            RsInlineFunctionProcessorKt.access$renameWithUsagesTo(declarations, freshName, (RsElement)function);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Set<String> getAllVisibleBindingsIncludingContainingLetDeclaration(RsElement $this$getAllVisibleBindingsIncludingContainingLetDeclaration) {
        $this$ancestorStrict$iv = $this$getAllVisibleBindingsIncludingContainingLetDeclaration;
        $i$f$ancestorStrict = false;
        var3_5 = (RsLetDecl)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsLetDecl.class, (boolean)true);
        if (var3_5 == null || (var4_2 = var3_5.getPat()) == null) ** GOTO lbl-1000
        var6_6 = var4_2;
        $i$f$descendantsOfType = false;
        v0 = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPatBinding.class);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"findChildrenOfType(...)");
        var5_4 = v0;
        if (var5_4 != null) {
            $this$descendantsOfType$iv = var5_4;
            $i$f$map = false;
            var8_8 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var13_13 = (RsPatBinding)item$iv$iv;
                var15_15 = destination$iv$iv;
                $i$a$-map-InlineSingleUsage$getAllVisibleBindingsIncludingContainingLetDeclaration$declarationNames$1 = false;
                var15_15.add(it.getReferenceName());
            }
            v1 = (List)destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v1 = v2 = null;
        }
        if (v1 == null) {
            v2 = CollectionsKt.emptyList();
        }
        declarationNames = v2;
        return SetsKt.plus(RsElementKt.getAllVisibleBindings($this$getAllVisibleBindingsIncludingContainingLetDeclaration), (Iterable)declarationNames);
    }

    private final void expandStructLiteralFieldsShorthand(RsFunction function) {
        PsiElement $this$descendantsOfType$iv = function;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsStructLiteralField.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        for (RsStructLiteralField field : collection) {
            Object object;
            if (field.getColon() != null || (object = field.getIdentifier()) == null || (object = object.getText()) == null) continue;
            Object name2 = object;
            field.add(this.factory.createColon());
            field.add(this.factory.createExpression((String)name2));
        }
    }

    private final void collapseStructLiteralFieldsShorthand() {
        PsiElement $this$descendantsOfType$iv = this.function;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsStructLiteralField.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        for (RsStructLiteralField field : collection) {
            Object object = field.getIdentifier();
            if (object == null || (object = object.getText()) == null) continue;
            Object name2 = object;
            if (field.getColon() == null) continue;
            RsExpr rsExpr = field.getExpr();
            if (!Intrinsics.areEqual((Object)name2, (Object)(rsExpr != null ? rsExpr.getText() : null))) continue;
            ChangeToFieldShorthandFix.Companion.applyShorthandInit(field);
        }
    }

    private final void replaceSelfWithActualType() {
        RsAbstractableOwner $this$filterTo$iv$iv;
        InlineSingleUsage $this$replaceSelfWithActualType_u24lambda_u240 = this;
        boolean bl = false;
        Project project = $this$replaceSelfWithActualType_u24lambda_u240.function.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPath path = RsCodeFragmentFactory.createPath$default(new RsCodeFragmentFactory(project), "Self::" + $this$replaceSelfWithActualType_u24lambda_u240.function.getName(), $this$replaceSelfWithActualType_u24lambda_u240.functionCall, null, NamespaceKt.getVALUES(), 4, null);
        Object object = path;
        if (Intrinsics.areEqual((Object)(object != null && (object = object.getReference()) != null ? object.resolve() : null), (Object)$this$replaceSelfWithActualType_u24lambda_u240.originalFunction)) {
            return;
        }
        RsBlock rsBlock = RsFunctionKt.getBlock(this.function);
        if (rsBlock == null) {
            return;
        }
        RsBlock block = rsBlock;
        PsiElement $this$descendantsOfType$iv = block;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPath.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            RsPath it2 = (RsPath)element$iv$iv;
            boolean bl2 = false;
            if (!(!it2.getHasColonColon() && it2.getCself() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        if ($this$filter$iv.isEmpty()) {
            boolean bl3 = false;
            return;
        }
        List paths = (List)$this$filter$iv;
        $this$filterTo$iv$iv = RsAbstractableKt.getOwner(this.function);
        RsAbstractableOwner.Impl impl = $this$filterTo$iv$iv instanceof RsAbstractableOwner.Impl ? (RsAbstractableOwner.Impl)$this$filterTo$iv$iv : null;
        if (impl == null) {
            return;
        }
        RsAbstractableOwner.Impl impl2 = impl;
        RsTypeReference rsTypeReference = impl2.getImpl().getTypeReference();
        if (rsTypeReference == null) {
            return;
        }
        RsTypeReference typeReference = rsTypeReference;
        Substitution substitution = this.getSubstitution(this.usage);
        if (substitution == null) {
            return;
        }
        Substitution substitution2 = substitution;
        for (RsPath path2 : paths) {
            RsInlineTypeAliasProcessorKt.fillPathWithActualType(path2, typeReference, substitution2);
        }
    }

    private final Substitution getSubstitution(CallUsage $this$getSubstitution) {
        Substitution substitution;
        CallUsage callUsage = $this$getSubstitution;
        if (callUsage instanceof FunctionCallUsage) {
            RsExpr rsExpr = ((FunctionCallUsage)$this$getSubstitution).getFunctionCall().getExpr();
            RsPathExpr rsPathExpr = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
            RsPath path = rsPathExpr != null ? rsPathExpr.getPath() : null;
            Object object = path;
            substitution = object != null && (object = object.getReference()) != null && (object = object.advancedResolve()) != null ? ((BoundElement)object).getSubst() : null;
        } else if (callUsage instanceof MethodCallUsage) {
            RsInferenceResult inference;
            RsMethodCall methodCall = ((MethodCallUsage)$this$getSubstitution).getMethodCall();
            RsInferenceResult rsInferenceResult = inference = ExtensionsKt.getInference(methodCall);
            substitution = rsInferenceResult != null ? rsInferenceResult.getResolvedMethodSubst(methodCall) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return substitution;
    }

    private static final String preprocessFunction$lambda$1(Set $outerScopeNames, HashSet $usedNames, String name2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if ($outerScopeNames.contains(name2)) {
            String string2;
            String it2 = string2 = RsNameSuggestionsKt.freshenName(name2, $usedNames);
            boolean bl = false;
            ((Collection)$usedNames).add(it2);
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage$VariableArgumentInfo;", "", "path", "Lorg/rust/lang/core/psi/RsPath;", "name", "", "type", "Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage$VariableArgumentType;", "<init>", "(Lorg/rust/lang/core/psi/RsPath;Ljava/lang/String;Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage$VariableArgumentType;)V", "getPath", "()Lorg/rust/lang/core/psi/RsPath;", "getName", "()Ljava/lang/String;", "getType", "()Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage$VariableArgumentType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class VariableArgumentInfo {
        @NotNull
        private final RsPath path;
        @NotNull
        private final String name;
        @NotNull
        private final VariableArgumentType type;

        public VariableArgumentInfo(@NotNull RsPath path, @NotNull String name2, @NotNull VariableArgumentType type) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.path = path;
            this.name = name2;
            this.type = type;
        }

        @NotNull
        public final RsPath getPath() {
            return this.path;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final VariableArgumentType getType() {
            return this.type;
        }

        @NotNull
        public final RsPath component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final VariableArgumentType component3() {
            return this.type;
        }

        @NotNull
        public final VariableArgumentInfo copy(@NotNull RsPath path, @NotNull String name2, @NotNull VariableArgumentType type) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new VariableArgumentInfo(path, name2, type);
        }

        public static /* synthetic */ VariableArgumentInfo copy$default(VariableArgumentInfo variableArgumentInfo, RsPath rsPath, String string, VariableArgumentType variableArgumentType, int n, Object object) {
            if ((n & 1) != 0) {
                rsPath = variableArgumentInfo.path;
            }
            if ((n & 2) != 0) {
                string = variableArgumentInfo.name;
            }
            if ((n & 4) != 0) {
                variableArgumentType = variableArgumentInfo.type;
            }
            return variableArgumentInfo.copy(rsPath, string, variableArgumentType);
        }

        @NotNull
        public String toString() {
            return "VariableArgumentInfo(path=" + this.path + ", name=" + this.name + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariableArgumentInfo)) {
                return false;
            }
            VariableArgumentInfo variableArgumentInfo = (VariableArgumentInfo)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)variableArgumentInfo.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)variableArgumentInfo.name)) {
                return false;
            }
            return this.type == variableArgumentInfo.type;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/refactoring/inlineFunction/InlineSingleUsage$VariableArgumentType;", "", "<init>", "(Ljava/lang/String;I)V", "PLAIN", "REF", "intellij.rustrover.core"})
    private static final class VariableArgumentType
    extends Enum<VariableArgumentType> {
        public static final /* enum */ VariableArgumentType PLAIN = new VariableArgumentType();
        public static final /* enum */ VariableArgumentType REF = new VariableArgumentType();
        private static final /* synthetic */ VariableArgumentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VariableArgumentType[] values() {
            return (VariableArgumentType[])$VALUES.clone();
        }

        public static VariableArgumentType valueOf(String value) {
            return Enum.valueOf(VariableArgumentType.class, value);
        }

        @NotNull
        public static EnumEntries<VariableArgumentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = variableArgumentTypeArray = new VariableArgumentType[]{VariableArgumentType.PLAIN, VariableArgumentType.REF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VariableArgumentType.values().length];
            try {
                nArray[VariableArgumentType.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VariableArgumentType.REF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

