/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.implementMembers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.presentation.ImportingPsiRenderer;
import org.rust.ide.presentation.PsiRenderingOptions;
import org.rust.ide.presentation.RsPsiRendererKt;
import org.rust.ide.utils.import.ImportCandidate;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsDefaultValueBuilder;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsMembers;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.Substitution;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0018*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u0018*\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/rust/ide/refactoring/implementMembers/MembersGenerator;", "", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "impl", "Lorg/rust/lang/core/psi/RsImplItem;", "trait", "Lorg/rust/lang/core/types/BoundElement;", "Lorg/rust/lang/core/psi/RsTraitItem;", "<init>", "(Lorg/rust/lang/core/psi/RsPsiFactory;Lorg/rust/lang/core/psi/RsImplItem;Lorg/rust/lang/core/types/BoundElement;)V", "renderer", "Lorg/rust/ide/presentation/ImportingPsiRenderer;", "itemsToImport", "", "Lorg/rust/ide/utils/import/ImportCandidate;", "getItemsToImport", "()Ljava/util/Set;", "createTraitMembers", "Lorg/rust/lang/core/psi/RsMembers;", "members", "", "Lorg/rust/lang/core/psi/ext/RsAbstractable;", "renderAbstractable", "", "element", "renderFunctionSignature", "Lorg/rust/lang/core/psi/RsFunction;", "renderTypeAliasSignature", "Lorg/rust/lang/core/psi/RsTypeAlias;", "renderTypeReference", "Lorg/rust/lang/core/psi/RsTypeReference;", "intellij.rustrover.core"})
public final class MembersGenerator {
    @NotNull
    private final RsPsiFactory factory;
    @NotNull
    private final BoundElement<RsTraitItem> trait;
    @NotNull
    private final ImportingPsiRenderer renderer;

    public MembersGenerator(@NotNull RsPsiFactory factory2, @NotNull RsImplItem impl, @NotNull BoundElement<? extends RsTraitItem> trait) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        Intrinsics.checkNotNullParameter(trait, (String)"trait");
        this.factory = factory2;
        this.trait = trait;
        PsiRenderingOptions psiRenderingOptions = new PsiRenderingOptions(false, false, false, 3, null);
        RsTraitRef rsTraitRef = impl.getTraitRef();
        Intrinsics.checkNotNull((Object)rsTraitRef);
        RsPath rsPath = rsTraitRef.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"getPath(...)");
        List list = CollectionsKt.listOf((Object)RsPathReferenceImplKt.getPsiSubstitution$default(rsPath, (RsGenericDeclaration)this.trait.getElement(), null, 4, null));
        RsMembers rsMembers = impl.getMembers();
        Intrinsics.checkNotNull((Object)rsMembers);
        this.renderer = new ImportingPsiRenderer(psiRenderingOptions, list, rsMembers);
    }

    @NotNull
    public final Set<ImportCandidate> getItemsToImport() {
        return this.renderer.getItemsToImport();
    }

    @NotNull
    public final RsMembers createTraitMembers(@NotNull Collection<? extends RsAbstractable> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        String body = CollectionsKt.joinToString$default((Iterable)members, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> MembersGenerator.createTraitMembers$lambda$0(this, arg_0), (int)30, null);
        return this.factory.createMembers(body);
    }

    @NotNull
    public final String renderAbstractable(@NotNull RsAbstractable element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Substitution subst = this.trait.getSubst();
        RsAbstractable rsAbstractable = element;
        if (rsAbstractable instanceof RsConstant) {
            RsDefaultValueBuilder rsDefaultValueBuilder = new RsDefaultValueBuilder(KnownItemsKt.getKnownItems(element), element.getContainingMod(), this.factory, true);
            Object object = ((RsConstant)element).getTypeReference();
            if (object == null || (object = ExtensionsKt.getNormType((RsTypeReference)object)) == null || (object = (Ty)FoldKt.substitute((TypeFoldable)object, subst)) == null) {
                object = TyUnknown.INSTANCE;
            }
            RsExpr initialValue = rsDefaultValueBuilder.buildFor((Ty)object, MapsKt.emptyMap());
            String string2 = RsConstantKt.getNameLikeElement((RsConstant)element).getText();
            Object object2 = ((RsConstant)element).getTypeReference();
            if (object2 == null || (object2 = this.renderTypeReference((RsTypeReference)object2)) == null) {
                object2 = "_";
            }
            string = "const " + string2 + ": " + (String)object2 + " = " + initialValue.getText() + ";";
        } else if (rsAbstractable instanceof RsTypeAlias) {
            string = this.renderTypeAliasSignature((RsTypeAlias)element) + " = ();";
        } else if (rsAbstractable instanceof RsFunction) {
            string = this.renderFunctionSignature((RsFunction)element) + " {\n        todo!()\n    }";
        } else {
            throw new IllegalStateException("Unknown trait member".toString());
        }
        return string;
    }

    private final String renderFunctionSignature(RsFunction $this$renderFunctionSignature) {
        return RsPsiRendererKt.renderFunctionSignature(this.renderer, $this$renderFunctionSignature);
    }

    private final String renderTypeAliasSignature(RsTypeAlias $this$renderTypeAliasSignature) {
        return RsPsiRendererKt.renderTypeAliasSignature(this.renderer, $this$renderTypeAliasSignature, false);
    }

    private final String renderTypeReference(RsTypeReference $this$renderTypeReference) {
        return RsPsiRendererKt.renderTypeReference(this.renderer, $this$renderTypeReference);
    }

    private static final CharSequence createTraitMembers$lambda$0(MembersGenerator this$0, RsAbstractable it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return "    " + this$0.renderAbstractable(it2);
    }
}

