/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.generate.constructor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.generate.BaseGenerateHandler;
import org.rust.ide.refactoring.generate.StructMember;
import org.rust.ide.refactoring.generate.constructor.GenerateConstructorHandlerKt;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.types.Substitution;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0014J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\"\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/rust/ide/refactoring/generate/constructor/GenerateConstructorHandler;", "Lorg/rust/ide/refactoring/generate/BaseGenerateHandler;", "<init>", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "allowEmptySelection", "", "getAllowEmptySelection", "()Z", "isImplBlockValid", "impl", "Lorg/rust/lang/core/psi/RsImplItem;", "allowEmptyFields", "performRefactoring", "", "struct", "Lorg/rust/lang/core/psi/RsStructItem;", "implBlock", "chosenFields", "", "Lorg/rust/ide/refactoring/generate/StructMember;", "substitution", "Lorg/rust/lang/core/types/Substitution;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createConstructor", "Lorg/rust/lang/core/psi/RsFunction;", "structItem", "selectedFields", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "generateBody", "intellij.rustrover.core"})
public final class GenerateConstructorHandler
extends BaseGenerateHandler {
    @NotNull
    private final String dialogTitle;
    private final boolean allowEmptySelection;

    public GenerateConstructorHandler() {
        this.dialogTitle = "Select constructor parameters";
        this.allowEmptySelection = true;
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return this.dialogTitle;
    }

    @Override
    public boolean getAllowEmptySelection() {
        return this.allowEmptySelection;
    }

    @Override
    protected boolean isImplBlockValid(@NotNull RsImplItem impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return super.isImplBlockValid(impl) && GenerateConstructorHandlerKt.access$isSuitableForConstructor(impl);
    }

    @Override
    protected boolean allowEmptyFields() {
        return true;
    }

    @Override
    protected void performRefactoring(@NotNull RsStructItem struct, @Nullable RsImplItem implBlock, @NotNull List<StructMember> chosenFields, @NotNull Substitution substitution, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        Intrinsics.checkNotNullParameter(chosenFields, (String)"chosenFields");
        Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        UtilsKt.checkWriteAccessAllowed();
        Project project = editor2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = struct.getName();
        if (string == null) {
            return;
        }
        String structName = string;
        RsPsiFactory psiFactory = new RsPsiFactory(project2, false, false, 6, null);
        RsImplItem rsImplItem = this.getOrCreateImplBlock(implBlock, psiFactory, structName, struct);
        if (rsImplItem == null) {
            return;
        }
        RsImplItem impl = rsImplItem;
        PsiElement anchor = impl.getLastChild().getLastChild();
        RsFunction constructor = this.createConstructor(struct, chosenFields, psiFactory, substitution);
        Intrinsics.checkNotNull((Object)anchor);
        Object object = PsiInsertionPlace.Companion.before(anchor);
        if (object == null || (object = (RsFunction)object.insert((PsiElement)constructor)) == null) {
            return;
        }
        Object inserted = object;
        editor2.getCaretModel().moveToOffset(PsiElementKt.getEndOffset((PsiElement)inserted));
    }

    private final RsFunction createConstructor(RsStructItem structItem, List<StructMember> selectedFields, RsPsiFactory psiFactory, Substitution substitution) {
        String arguments = CollectionsKt.joinToString$default((Iterable)selectedFields, (CharSequence)",", (CharSequence)"(", (CharSequence)")", (int)0, null, GenerateConstructorHandler::createConstructor$lambda$0, (int)24, null);
        String body = this.generateBody(structItem, selectedFields, substitution);
        return psiFactory.createTraitMethodMember("pub fn new" + arguments + "->Self{\n" + body + "}\n");
    }

    private final String generateBody(RsStructItem structItem, List<StructMember> selectedFields, Substitution substitution) {
        String prefix = RsStructItemKt.isTupleStruct(structItem) ? "(" : "{";
        String postfix = RsStructItemKt.isTupleStruct(structItem) ? ")" : "}";
        String arguments = CollectionsKt.joinToString$default((Iterable)StructMember.Companion.fromStruct(structItem, substitution), (CharSequence)",", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, arg_0 -> GenerateConstructorHandler.generateBody$lambda$0(selectedFields, arg_0), (int)24, null);
        return "Self" + arguments;
    }

    private static final CharSequence createConstructor$lambda$0(StructMember it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getArgumentIdentifier() + ": " + it2.getTypeReferenceText();
    }

    private static final CharSequence generateBody$lambda$0(List $selectedFields, StructMember it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !$selectedFields.contains(it2) ? (CharSequence)it2.getFieldIdentifier() : (CharSequence)it2.getArgumentIdentifier();
    }
}

