/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.generate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.generate.StructMemberKt;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsTupleFieldDecl;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.types.Substitution;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/rust/ide/refactoring/generate/StructMember;", "", "argumentIdentifier", "", "fieldIdentifier", "typeReferenceText", "field", "Lorg/rust/lang/core/psi/ext/RsFieldDecl;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/rust/lang/core/psi/ext/RsFieldDecl;)V", "getArgumentIdentifier", "()Ljava/lang/String;", "getFieldIdentifier", "getTypeReferenceText", "getField", "()Lorg/rust/lang/core/psi/ext/RsFieldDecl;", "dialogRepresentation", "getDialogRepresentation", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
public final class StructMember {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String argumentIdentifier;
    @NotNull
    private final String fieldIdentifier;
    @NotNull
    private final String typeReferenceText;
    @NotNull
    private final RsFieldDecl field;

    public StructMember(@NotNull String argumentIdentifier, @NotNull String fieldIdentifier, @NotNull String typeReferenceText, @NotNull RsFieldDecl field) {
        Intrinsics.checkNotNullParameter((Object)argumentIdentifier, (String)"argumentIdentifier");
        Intrinsics.checkNotNullParameter((Object)fieldIdentifier, (String)"fieldIdentifier");
        Intrinsics.checkNotNullParameter((Object)typeReferenceText, (String)"typeReferenceText");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.argumentIdentifier = argumentIdentifier;
        this.fieldIdentifier = fieldIdentifier;
        this.typeReferenceText = typeReferenceText;
        this.field = field;
    }

    @NotNull
    public final String getArgumentIdentifier() {
        return this.argumentIdentifier;
    }

    @NotNull
    public final String getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    @NotNull
    public final String getTypeReferenceText() {
        return this.typeReferenceText;
    }

    @NotNull
    public final RsFieldDecl getField() {
        return this.field;
    }

    @NotNull
    public final String getDialogRepresentation() {
        return this.argumentIdentifier + ": " + this.typeReferenceText;
    }

    @NotNull
    public final String component1() {
        return this.argumentIdentifier;
    }

    @NotNull
    public final String component2() {
        return this.fieldIdentifier;
    }

    @NotNull
    public final String component3() {
        return this.typeReferenceText;
    }

    @NotNull
    public final RsFieldDecl component4() {
        return this.field;
    }

    @NotNull
    public final StructMember copy(@NotNull String argumentIdentifier, @NotNull String fieldIdentifier, @NotNull String typeReferenceText, @NotNull RsFieldDecl field) {
        Intrinsics.checkNotNullParameter((Object)argumentIdentifier, (String)"argumentIdentifier");
        Intrinsics.checkNotNullParameter((Object)fieldIdentifier, (String)"fieldIdentifier");
        Intrinsics.checkNotNullParameter((Object)typeReferenceText, (String)"typeReferenceText");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return new StructMember(argumentIdentifier, fieldIdentifier, typeReferenceText, field);
    }

    public static /* synthetic */ StructMember copy$default(StructMember structMember, String string, String string2, String string3, RsFieldDecl rsFieldDecl, int n, Object object) {
        if ((n & 1) != 0) {
            string = structMember.argumentIdentifier;
        }
        if ((n & 2) != 0) {
            string2 = structMember.fieldIdentifier;
        }
        if ((n & 4) != 0) {
            string3 = structMember.typeReferenceText;
        }
        if ((n & 8) != 0) {
            rsFieldDecl = structMember.field;
        }
        return structMember.copy(string, string2, string3, rsFieldDecl);
    }

    @NotNull
    public String toString() {
        return "StructMember(argumentIdentifier=" + this.argumentIdentifier + ", fieldIdentifier=" + this.fieldIdentifier + ", typeReferenceText=" + this.typeReferenceText + ", field=" + this.field + ")";
    }

    public int hashCode() {
        int result2 = this.argumentIdentifier.hashCode();
        result2 = result2 * 31 + this.fieldIdentifier.hashCode();
        result2 = result2 * 31 + this.typeReferenceText.hashCode();
        result2 = result2 * 31 + this.field.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructMember)) {
            return false;
        }
        StructMember structMember = (StructMember)other;
        if (!Intrinsics.areEqual((Object)this.argumentIdentifier, (Object)structMember.argumentIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fieldIdentifier, (Object)structMember.fieldIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.typeReferenceText, (Object)structMember.typeReferenceText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.field, (Object)structMember.field);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/refactoring/generate/StructMember$Companion;", "", "<init>", "()V", "fromStruct", "", "Lorg/rust/ide/refactoring/generate/StructMember;", "structItem", "Lorg/rust/lang/core/psi/RsStructItem;", "substitution", "Lorg/rust/lang/core/types/Substitution;", "fromTupleList", "tupleFieldList", "Lorg/rust/lang/core/psi/RsTupleFieldDecl;", "fromFieldList", "fieldDeclList", "Lorg/rust/lang/core/psi/RsNamedFieldDecl;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nStructMember.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructMember.kt\norg/rust/ide/refactoring/generate/StructMember$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1573#2:67\n1604#2,4:68\n1563#2:72\n1634#2,3:73\n*S KotlinDebug\n*F\n+ 1 StructMember.kt\norg/rust/ide/refactoring/generate/StructMember$Companion\n*L\n42#1:67\n42#1:68,4\n52#1:72\n52#1:73,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<StructMember> fromStruct(@NotNull RsStructItem structItem, @NotNull Substitution substitution) {
            Intrinsics.checkNotNullParameter((Object)structItem, (String)"structItem");
            Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
            return RsStructItemKt.isTupleStruct(structItem) ? this.fromTupleList(RsFieldsOwnerKt.getExpandedPositionalFields(structItem), substitution) : this.fromFieldList(RsFieldsOwnerKt.getExpandedNamedFields(structItem), substitution);
        }

        /*
         * WARNING - void declaration
         */
        private final List<StructMember> fromTupleList(List<? extends RsTupleFieldDecl> tupleFieldList, Substitution substitution) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = tupleFieldList;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void tupleField;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RsTupleFieldDecl rsTupleFieldDecl = (RsTupleFieldDecl)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RsTypeReference rsTypeReference = tupleField.getTypeReference();
                Intrinsics.checkNotNullExpressionValue((Object)rsTypeReference, (String)"<get-typeReference>(...)");
                String typeName = StructMemberKt.access$render(rsTypeReference, substitution);
                collection.add(new StructMember("field" + (int)index, "()", typeName, (RsFieldDecl)tupleField));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<StructMember> fromFieldList(List<? extends RsNamedFieldDecl> fieldDeclList, Substitution substitution) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fieldDeclList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                RsNamedFieldDecl rsNamedFieldDecl = (RsNamedFieldDecl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it2.getIdentifier().getText();
                if (string == null) {
                    string = "()";
                }
                String string2 = it2.getIdentifier().getText() + ":()";
                Object object = it2.getTypeReference();
                if (object == null || (object = StructMemberKt.access$render((RsTypeReference)object, substitution)) == null) {
                    object = "()";
                }
                collection.add(new StructMember(string, string2, (String)object, (RsFieldDecl)it2));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

