/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.generate;

import com.intellij.openapi.editor.Editor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.generate.BaseGenerateHandler;
import org.rust.ide.refactoring.generate.StructMember;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.psi.ext.RsTraitOrImpl;
import org.rust.lang.core.psi.ext.RsTraitOrImplKt;
import org.rust.lang.core.psi.ext.RsVisibility;
import org.rust.lang.core.types.Substitution;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J@\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H$J8\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001a\u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/refactoring/generate/GenerateAccessorHandler;", "Lorg/rust/ide/refactoring/generate/BaseGenerateHandler;", "<init>", "()V", "isStructValid", "", "struct", "Lorg/rust/lang/core/psi/RsStructItem;", "methodName", "", "member", "Lorg/rust/ide/refactoring/generate/StructMember;", "generateAccessors", "", "Lorg/rust/lang/core/psi/RsFunction;", "implBlock", "Lorg/rust/lang/core/psi/RsImplItem;", "chosenFields", "substitution", "Lorg/rust/lang/core/types/Substitution;", "editor", "Lcom/intellij/openapi/editor/Editor;", "performRefactoring", "", "isFieldValid", "impl", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nGenerateAccessorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateAccessorHandler.kt\norg/rust/ide/refactoring/generate/GenerateAccessorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1740#2,3:54\n*S KotlinDebug\n*F\n+ 1 GenerateAccessorHandler.kt\norg/rust/ide/refactoring/generate/GenerateAccessorHandler\n*L\n50#1:54,3\n*E\n"})
public abstract class GenerateAccessorHandler
extends BaseGenerateHandler {
    @Override
    protected boolean isStructValid(@NotNull RsStructItem struct) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        if (RsStructItemKt.isTupleStruct(struct)) {
            return false;
        }
        Object object = struct.getBlockFields();
        return object != null && (object = object.getNamedFieldDeclList()) != null ? !object.isEmpty() : false;
    }

    @NotNull
    public abstract String methodName(@NotNull StructMember var1);

    @Nullable
    protected abstract List<RsFunction> generateAccessors(@NotNull RsStructItem var1, @Nullable RsImplItem var2, @NotNull List<StructMember> var3, @NotNull Substitution var4, @NotNull Editor var5);

    @Override
    protected void performRefactoring(@NotNull RsStructItem struct, @Nullable RsImplItem implBlock, @NotNull List<StructMember> chosenFields, @NotNull Substitution substitution, @NotNull Editor editor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
            Intrinsics.checkNotNullParameter(chosenFields, (String)"chosenFields");
            Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            List<RsFunction> methods = this.generateAccessors(struct, implBlock, chosenFields, substitution, editor2);
            List<RsFunction> list = methods;
            if (list == null || (list = (RsFunction)CollectionsKt.firstOrNull(list)) == null) break block0;
            list.navigate(true);
        }
    }

    @Override
    protected boolean isFieldValid(@NotNull StructMember member, @Nullable RsImplItem impl) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            if (Intrinsics.areEqual((Object)member.getField().getVisibility(), (Object)RsVisibility.Public.INSTANCE)) {
                return false;
            }
            Object object = impl;
            if (object != null && (object = RsTraitOrImplKt.getExpandedMembers((RsTraitOrImpl)object)) != null) {
                Iterable $this$all$iv = (Iterable)object;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        RsAbstractable it2 = (RsAbstractable)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)this.methodName(member))) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }
}

