/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.generate;

import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.generate.BaseGenerateHandlerKt;
import org.rust.ide.refactoring.generate.StructMember;
import org.rust.ide.refactoring.generate.UiKt;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPathType;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsTypeReferenceKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.Substitution;
import org.rust.lang.core.types.SubstitutionKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tH\u0096\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0018H\u0014J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u001a\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\b\u0010!\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010&\u001a\u00020\u0005H\u0014J8\u0010'\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u0007H$R\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010,\u001a\u00070\u001d\u00a2\u0006\u0002\b-X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lorg/rust/ide/refactoring/generate/BaseGenerateHandler;", "Lcom/intellij/lang/LanguageCodeInsightActionHandler;", "<init>", "()V", "isValidFor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "startInWriteAction", "allowEmptySelection", "getAllowEmptySelection", "()Z", "getContext", "Lorg/rust/ide/refactoring/generate/BaseGenerateHandler$Context;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "selectMembers", "context", "getOrCreateImplBlock", "Lorg/rust/lang/core/psi/RsImplItem;", "implBlock", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "structName", "", "struct", "Lorg/rust/lang/core/psi/RsStructItem;", "isImplBlockValid", "impl", "isStructValid", "isFieldValid", "member", "Lorg/rust/ide/refactoring/generate/StructMember;", "allowEmptyFields", "performRefactoring", "chosenFields", "", "substitution", "Lorg/rust/lang/core/types/Substitution;", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getDialogTitle", "()Ljava/lang/String;", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBaseGenerateHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseGenerateHandler.kt\norg/rust/ide/refactoring/generate/BaseGenerateHandler\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n15#2:143\n9#2:144\n774#3:145\n865#3,2:146\n*S KotlinDebug\n*F\n+ 1 BaseGenerateHandler.kt\norg/rust/ide/refactoring/generate/BaseGenerateHandler\n*L\n53#1:143\n57#1:144\n68#1:145\n68#1:146,2\n*E\n"})
public abstract class BaseGenerateHandler
implements LanguageCodeInsightActionHandler {
    private final boolean allowEmptySelection;

    public boolean isValidFor(@NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getContext(editor2, file) != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean getAllowEmptySelection() {
        return this.allowEmptySelection;
    }

    /*
     * WARNING - void declaration
     */
    private final Context getContext(Editor editor2, PsiFile file) {
        void $this$filterTo$iv$iv;
        Pair pair;
        PsiElement element;
        PsiElement psiElement2 = file.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement2 == null) {
            return null;
        }
        PsiElement $this$ancestorOrSelf$iv = element = psiElement2;
        boolean $i$f$ancestorOrSelf = false;
        RsStructItem struct = (RsStructItem)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsStructItem.class, (boolean)false);
        if (struct != null) {
            pair = TuplesKt.to((Object)struct, null);
        } else {
            PsiElement $this$ancestorStrict$iv = element;
            boolean $i$f$ancestorStrict = false;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsItemElement.class, (boolean)true);
            RsImplItem rsImplItem = psiElement3 instanceof RsImplItem ? (RsImplItem)psiElement3 : null;
            if (rsImplItem == null) {
                return null;
            }
            RsImplItem impl = rsImplItem;
            if (!this.isImplBlockValid(impl)) {
                return null;
            }
            RsTypeReference rsTypeReference = impl.getTypeReference();
            RsTypeReference rsTypeReference2 = rsTypeReference != null ? RsTypeReferenceKt.skipParens(rsTypeReference) : null;
            Object object = rsTypeReference2 instanceof RsPathType ? (RsPathType)rsTypeReference2 : null;
            $this$ancestorStrict$iv = object != null && (object = object.getPath()) != null && (object = object.getReference()) != null ? object.resolve() : null;
            RsStructItem rsStructItem = $this$ancestorStrict$iv instanceof RsStructItem ? (RsStructItem)$this$ancestorStrict$iv : null;
            if (rsStructItem == null) {
                return null;
            }
            RsStructItem structRef = rsStructItem;
            pair = TuplesKt.to((Object)structRef, (Object)impl);
        }
        Pair pair2 = pair;
        RsStructItem structItem = (RsStructItem)pair2.component1();
        RsImplItem impl = (RsImplItem)pair2.component2();
        if (!this.isStructValid(structItem)) {
            return null;
        }
        Object object = impl;
        if (object == null || (object = object.getTypeReference()) == null || (object = ExtensionsKt.getRawType((RsTypeReference)object)) == null || (object = ((Ty)object).getTypeParameterValues()) == null) {
            object = SubstitutionKt.getEmptySubstitution();
        }
        Object substitution = object;
        Iterable $this$filter$iv = StructMember.Companion.fromStruct(structItem, (Substitution)substitution);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StructMember it2 = (StructMember)element$iv$iv;
            boolean bl = false;
            if (!this.isFieldValid(it2, impl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fields = (List)destination$iv$iv;
        if (fields.isEmpty() && !this.allowEmptyFields()) {
            return null;
        }
        return new Context(structItem, fields, (Substitution)substitution, impl);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Context context = this.getContext(editor2, psiFile);
        if (context == null) {
            return;
        }
        Context context2 = context;
        this.selectMembers(context2, editor2);
    }

    private final void selectMembers(Context context, Editor editor2) {
        UtilsKt.checkWriteAccessNotAllowed();
        Project project = context.getStruct().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<StructMember> list = UiKt.showStructMemberChooserDialog(project, context.getStruct(), context.getFields(), this.getDialogTitle(), this.getAllowEmptySelection());
        if (list == null) {
            return;
        }
        List<StructMember> chosenFields = list;
        ActionsKt.runWriteAction(() -> BaseGenerateHandler.selectMembers$lambda$0(this, context, chosenFields, editor2));
    }

    @Nullable
    protected final RsImplItem getOrCreateImplBlock(@Nullable RsImplItem implBlock, @NotNull RsPsiFactory psiFactory, @NotNull String structName, @NotNull RsStructItem struct) {
        RsImplItem rsImplItem;
        Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
        Intrinsics.checkNotNullParameter((Object)structName, (String)"structName");
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        if (implBlock == null) {
            RsImplItem sibling = BaseGenerateHandlerKt.access$findSiblingImplItem(struct);
            if (sibling != null) {
                return sibling;
            }
            RsImplItem impl = psiFactory.createInherentImplItem(structName, struct.getTypeParameterList(), struct.getWhereClause());
            PsiInsertionPlace psiInsertionPlace = PsiInsertionPlace.Companion.after(struct);
            rsImplItem = psiInsertionPlace != null ? (RsImplItem)psiInsertionPlace.insert((PsiElement)impl) : null;
        } else {
            rsImplItem = implBlock;
        }
        return rsImplItem;
    }

    protected boolean isImplBlockValid(@NotNull RsImplItem impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl.getTraitRef() == null;
    }

    protected boolean isStructValid(@NotNull RsStructItem struct) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        return true;
    }

    protected boolean isFieldValid(@NotNull StructMember member, @Nullable RsImplItem impl) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        return true;
    }

    protected boolean allowEmptyFields() {
        return false;
    }

    protected abstract void performRefactoring(@NotNull RsStructItem var1, @Nullable RsImplItem var2, @NotNull List<StructMember> var3, @NotNull Substitution var4, @NotNull Editor var5);

    @NotNull
    protected abstract String getDialogTitle();

    private static final Unit selectMembers$lambda$0(BaseGenerateHandler this$0, Context $context, List $chosenFields, Editor $editor) {
        this$0.performRefactoring($context.getStruct(), $context.getImplBlock(), $chosenFields, $context.getSubstitution(), $editor);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/rust/ide/refactoring/generate/BaseGenerateHandler$Context;", "", "struct", "Lorg/rust/lang/core/psi/RsStructItem;", "fields", "", "Lorg/rust/ide/refactoring/generate/StructMember;", "substitution", "Lorg/rust/lang/core/types/Substitution;", "implBlock", "Lorg/rust/lang/core/psi/RsImplItem;", "<init>", "(Lorg/rust/lang/core/psi/RsStructItem;Ljava/util/List;Lorg/rust/lang/core/types/Substitution;Lorg/rust/lang/core/psi/RsImplItem;)V", "getStruct", "()Lorg/rust/lang/core/psi/RsStructItem;", "getFields", "()Ljava/util/List;", "getSubstitution", "()Lorg/rust/lang/core/types/Substitution;", "getImplBlock", "()Lorg/rust/lang/core/psi/RsImplItem;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsStructItem struct;
        @NotNull
        private final List<StructMember> fields;
        @NotNull
        private final Substitution substitution;
        @Nullable
        private final RsImplItem implBlock;

        public Context(@NotNull RsStructItem struct, @NotNull List<StructMember> fields, @NotNull Substitution substitution, @Nullable RsImplItem implBlock) {
            Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
            this.struct = struct;
            this.fields = fields;
            this.substitution = substitution;
            this.implBlock = implBlock;
        }

        public /* synthetic */ Context(RsStructItem rsStructItem, List list, Substitution substitution, RsImplItem rsImplItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                rsImplItem = null;
            }
            this(rsStructItem, list, substitution, rsImplItem);
        }

        @NotNull
        public final RsStructItem getStruct() {
            return this.struct;
        }

        @NotNull
        public final List<StructMember> getFields() {
            return this.fields;
        }

        @NotNull
        public final Substitution getSubstitution() {
            return this.substitution;
        }

        @Nullable
        public final RsImplItem getImplBlock() {
            return this.implBlock;
        }

        @NotNull
        public final RsStructItem component1() {
            return this.struct;
        }

        @NotNull
        public final List<StructMember> component2() {
            return this.fields;
        }

        @NotNull
        public final Substitution component3() {
            return this.substitution;
        }

        @Nullable
        public final RsImplItem component4() {
            return this.implBlock;
        }

        @NotNull
        public final Context copy(@NotNull RsStructItem struct, @NotNull List<StructMember> fields, @NotNull Substitution substitution, @Nullable RsImplItem implBlock) {
            Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
            return new Context(struct, fields, substitution, implBlock);
        }

        public static /* synthetic */ Context copy$default(Context context, RsStructItem rsStructItem, List list, Substitution substitution, RsImplItem rsImplItem, int n, Object object) {
            if ((n & 1) != 0) {
                rsStructItem = context.struct;
            }
            if ((n & 2) != 0) {
                list = context.fields;
            }
            if ((n & 4) != 0) {
                substitution = context.substitution;
            }
            if ((n & 8) != 0) {
                rsImplItem = context.implBlock;
            }
            return context.copy(rsStructItem, list, substitution, rsImplItem);
        }

        @NotNull
        public String toString() {
            return "Context(struct=" + this.struct + ", fields=" + this.fields + ", substitution=" + this.substitution + ", implBlock=" + this.implBlock + ")";
        }

        public int hashCode() {
            int result2 = this.struct.hashCode();
            result2 = result2 * 31 + ((Object)this.fields).hashCode();
            result2 = result2 * 31 + this.substitution.hashCode();
            result2 = result2 * 31 + (this.implBlock == null ? 0 : this.implBlock.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.struct, (Object)context.struct)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fields, context.fields)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.substitution, (Object)context.substitution)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.implBlock, (Object)context.implBlock);
        }
    }
}

