/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.extractTrait;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.refactoring.RsMemberInfo;
import org.rust.ide.refactoring.RsMemberSelectionPanel;
import org.rust.ide.refactoring.RsNamesValidatorKt;
import org.rust.ide.refactoring.extractTrait.RsExtractTraitHandler;
import org.rust.ide.refactoring.extractTrait.RsExtractTraitHandlerKt;
import org.rust.ide.refactoring.extractTrait.RsExtractTraitProcessor;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsTraitOrImpl;
import org.rust.openapiext.UiKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\b\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/refactoring/extractTrait/RsExtractTraitDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "traitOrImpl", "Lorg/rust/lang/core/psi/ext/RsTraitOrImpl;", "memberInfos", "", "Lorg/rust/ide/refactoring/RsMemberInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/lang/core/psi/ext/RsTraitOrImpl;Ljava/util/List;)V", "traitNameField", "Ljavax/swing/JTextField;", "createCenterPanel", "Ljavax/swing/JComponent;", "validateButtons", "", "areButtonsValid", "", "doAction", "doActionUndoCommand", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExtractTraitHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExtractTraitHandler.kt\norg/rust/ide/refactoring/extractTrait/RsExtractTraitDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,150:1\n1761#2,3:151\n774#2:155\n865#2,2:156\n1563#2:158\n1634#2,3:159\n13#3:154\n*S KotlinDebug\n*F\n+ 1 RsExtractTraitHandler.kt\norg/rust/ide/refactoring/extractTrait/RsExtractTraitDialog\n*L\n119#1:151,3\n136#1:155\n136#1:156,2\n136#1:158\n136#1:159,3\n130#1:154\n*E\n"})
public final class RsExtractTraitDialog
extends RefactoringDialog {
    @NotNull
    private final RsTraitOrImpl traitOrImpl;
    @NotNull
    private final List<RsMemberInfo> memberInfos;
    @NotNull
    private final JTextField traitNameField;

    /*
     * WARNING - void declaration
     */
    public RsExtractTraitDialog(@NotNull Project project, @NotNull RsTraitOrImpl traitOrImpl, @NotNull List<RsMemberInfo> memberInfos) {
        void $this$traitNameField_u24lambda_u240;
        JBTextField jBTextField;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)traitOrImpl, (String)"traitOrImpl");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        super(project, false);
        this.traitOrImpl = traitOrImpl;
        this.memberInfos = memberInfos;
        JBTextField jBTextField2 = jBTextField = new JBTextField();
        RsExtractTraitDialog rsExtractTraitDialog = this;
        boolean bl = false;
        UiKt.addTextChangeListener((JTextField)$this$traitNameField_u24lambda_u240, (Function1<? super DocumentEvent, Unit>)((Function1)arg_0 -> RsExtractTraitDialog.traitNameField$lambda$0$0(this, arg_0)));
        rsExtractTraitDialog.traitNameField = (JTextField)jBTextField;
        if (!(!UtilsKt.isUnitTestMode())) {
            throw new IllegalStateException("Check failed.");
        }
        super.init();
        this.setTitle(RsBundle.INSTANCE.message("action.Rust.RsExtractTrait.dialog.title", new Object[0]));
        this.validateButtons();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> RsExtractTraitDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    protected void validateButtons() {
        super.validateButtons();
        this.getPreviewAction().setEnabled(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean areButtonsValid() {
        RsMemberInfo it2;
        String string = this.traitNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!RsNamesValidatorKt.isValidRustVariableIdentifier(string)) return false;
        Iterable $this$any$iv = this.memberInfos;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it2 = (RsMemberInfo)((Object)element$iv);
            boolean bl = false;
        } while (!it2.isChecked());
        return true;
    }

    protected void doAction() {
        try {
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> RsExtractTraitDialog.doAction$lambda$0(this), this.getTitle(), null);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RsExtractTraitHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsExtractTraitHandlerKt.showRefactoringError$default(project, e.getMessage(), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doActionUndoCommand() {
        void $this$mapTo$iv$iv;
        RsMemberInfo it2;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.memberInfos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (RsMemberInfo)((Object)element$iv$iv);
            boolean bl = false;
            if (!it2.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (RsMemberInfo)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((RsItemElement)it2.getMember());
        }
        List members = (List)destination$iv$iv;
        String traitName = this.traitNameField.getText();
        Intrinsics.checkNotNull((Object)traitName);
        RsExtractTraitProcessor processor2 = new RsExtractTraitProcessor(this.traitOrImpl, traitName, members);
        this.invokeRefactoring(processor2);
    }

    private static final Unit traitNameField$lambda$0$0(RsExtractTraitDialog this$0, DocumentEvent it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        this$0.validateButtons();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(RsExtractTraitDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, RsExtractTraitDialog::createCenterPanel$lambda$0$0, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RsExtractTraitDialog.createCenterPanel$lambda$0$1(this$0, arg_0), (int)1, null).bottomGap(BottomGap.MEDIUM);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RsExtractTraitDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(RsBundle.INSTANCE.message("label.trait.name", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(RsExtractTraitDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        UiKt.fullWidthCell($this$row, (JComponent)this$0.traitNameField).focused();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(RsExtractTraitDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.resizableRow();
        RsMemberSelectionPanel members = new RsMemberSelectionPanel(RsBundle.INSTANCE.message("separator.members.to.form.trait", new Object[0]), this$0.memberInfos);
        members.setMinimumSize((Dimension)JBUI.size((int)0, (int)200));
        members.getTable().addMemberInfoChangeListener(arg_0 -> RsExtractTraitDialog.createCenterPanel$lambda$0$2$0(this$0, arg_0));
        UiKt.fullWidthCell($this$row, (JComponent)((Object)members)).align((Align)AlignY.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$0$2$0(RsExtractTraitDialog this$0, MemberInfoChange it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        this$0.validateButtons();
    }

    private static final void doAction$lambda$0(RsExtractTraitDialog this$0) {
        this$0.doActionUndoCommand();
    }
}

