/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.extractFunction;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.presentation.PsiRenderingOptions;
import org.rust.ide.presentation.RsPsiRenderer;
import org.rust.ide.presentation.RsPsiRendererKt;
import org.rust.ide.refactoring.RsRenameProcessor;
import org.rust.ide.refactoring.extractFunction.ControlFlow;
import org.rust.ide.refactoring.extractFunction.ControlFlowElements;
import org.rust.ide.refactoring.extractFunction.Parameter;
import org.rust.ide.refactoring.extractFunction.ReturnKind;
import org.rust.ide.refactoring.extractFunction.RsExtractFunctionConfig;
import org.rust.ide.refactoring.extractFunction.RsExtractFunctionConfigKt;
import org.rust.ide.refactoring.extractFunction.UiKt;
import org.rust.ide.utils.GenericConstraints;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.ide.utils.import.RsImportHelper;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBreakExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsMembers;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.RsTryExpr;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsItemsOwner;
import org.rust.lang.core.psi.ext.RsStmtKt;
import org.rust.lang.core.resolve.RsCachedImplItem;
import org.rust.lang.core.types.consts.CtConstParameter;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTuple;
import org.rust.lang.core.types.ty.TyTypeParameter;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0002\u0010\rJ/\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J0\u0010\u001b\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020 0\u001fH\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\n*\u00020\nH\u0002J\u0014\u0010\"\u001a\u00020\u0005*\u00020#2\u0006\u0010$\u001a\u00020 H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&H\u0002J\u001e\u0010)\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00162\f\u0010*\u001a\b\u0012\u0004\u0012\u00020 0\u001cH\u0002J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006."}, d2={"Lorg/rust/ide/refactoring/extractFunction/RsExtractFunctionHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "elements", "", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "extractFunction", "config", "Lorg/rust/ide/refactoring/extractFunction/RsExtractFunctionConfig;", "addExtractedFunction", "Lorg/rust/lang/core/psi/RsFunction;", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "adjustControlFlow", "function", "replaceEachWithReturn", "", "factory", "getValue", "Lkotlin/Function1;", "", "getControlFlowValue", "wrapWith", "Lorg/rust/lang/core/psi/RsExprStmt;", "constructor", "findExistingInherentImpl", "Lorg/rust/lang/core/psi/RsImplItem;", "traitImpl", "createNewInherentImpl", "renameFunctionParameters", "newNames", "replaceOldStatementsWithCallExpr", "generateFunctionCallFull", "generateFunctionCall", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExtractFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExtractFunctionHandler.kt\norg/rust/ide/refactoring/extractFunction/RsExtractFunctionHandler\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n31#2:247\n295#3,2:248\n1563#3:250\n1634#3,3:251\n1563#3:254\n1634#3,3:255\n1563#3:258\n1634#3,3:259\n774#3:265\n865#3,2:266\n1563#3:268\n1634#3,3:269\n37#4,2:262\n1#5:264\n*S KotlinDebug\n*F\n+ 1 RsExtractFunctionHandler.kt\norg/rust/ide/refactoring/extractFunction/RsExtractFunctionHandler\n*L\n158#1:247\n159#1:248,2\n195#1:250\n195#1:251,3\n197#1:254\n197#1:255,3\n202#1:258\n202#1:259,3\n57#1:265\n57#1:266,2\n58#1:268\n58#1:269,3\n202#1:262,2\n*E\n"})
public final class RsExtractFunctionHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        Integer end;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(file instanceof RsFile)) {
            return;
        }
        Editor editor3 = editor2;
        Integer start2 = editor3 != null && (editor3 = editor3.getSelectionModel()) != null ? Integer.valueOf(editor3.getSelectionStart()) : null;
        Editor editor4 = editor2;
        Integer n = editor4 != null && (editor4 = editor4.getSelectionModel()) != null ? Integer.valueOf(editor4.getSelectionEnd()) : (end = null);
        if (start2 == null || end == null) {
            return;
        }
        RsExtractFunctionConfig rsExtractFunctionConfig = RsExtractFunctionConfig.Companion.create(file, start2, end);
        if (rsExtractFunctionConfig == null) {
            return;
        }
        RsExtractFunctionConfig config = rsExtractFunctionConfig;
        UiKt.extractFunctionDialog(project, config, (Function0<Unit>)((Function0)() -> RsExtractFunctionHandler.invoke$lambda$0(this, project, file, config)));
    }

    private final void extractFunction(Project project, PsiFile file, RsExtractFunctionConfig config) {
        String string = RefactoringBundle.message((String)"extract.method.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        PsiFile[] psiFileArray = new PsiFile[]{file};
        UtilsKt.runWriteCommandAction(project, string, psiFileArray, () -> RsExtractFunctionHandler.extractFunction$lambda$0(project, this, config));
    }

    private final RsFunction addExtractedFunction(Project project, RsExtractFunctionConfig config, RsPsiFactory psiFactory) {
        RsFunction rsFunction;
        RsAbstractableOwner owner = RsAbstractableKt.getOwner(config.getFunction());
        RsFunction function = psiFactory.createFunction(config.getFunctionText());
        this.adjustControlFlow(config, function);
        if (owner instanceof RsAbstractableOwner.Impl && !((RsAbstractableOwner.Impl)owner).isInherent()) {
            RsImplItem rsImplItem = this.findExistingInherentImpl(((RsAbstractableOwner.Impl)owner).getImpl());
            if (rsImplItem == null && (rsImplItem = this.createNewInherentImpl(((RsAbstractableOwner.Impl)owner).getImpl())) == null) {
                return null;
            }
            RsImplItem impl = rsImplItem;
            RsMembers rsMembers = impl.getMembers();
            if (rsMembers == null) {
                return null;
            }
            RsMembers members = rsMembers;
            PsiInsertionPlace psiInsertionPlace = PsiInsertionPlace.Companion.beforeOrInside(members.getRbrace(), members);
            rsFunction = psiInsertionPlace != null ? (RsFunction)psiInsertionPlace.insert((PsiElement)function) : null;
        } else {
            PsiInsertionPlace psiInsertionPlace = PsiInsertionPlace.Companion.after(config.getFunction());
            rsFunction = psiInsertionPlace != null ? (RsFunction)psiInsertionPlace.insert((PsiElement)function) : null;
        }
        return rsFunction;
    }

    private final void adjustControlFlow(RsExtractFunctionConfig config, RsFunction function) {
        Project project = function.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        RsBlock rsBlock = RsFunctionKt.getBlock(function);
        Intrinsics.checkNotNull((Object)rsBlock);
        RsBlock block = rsBlock;
        RsExprStmt syntaxTailStmt = RsBlockKt.getSyntaxTailStmt(block);
        ControlFlowElements controlFlowElements = RsExtractFunctionConfigKt.findControlFlowElements(CollectionsKt.listOf((Object)block));
        if (controlFlowElements == null) {
            return;
        }
        List<PsiElement> controlFlowElements2 = controlFlowElements.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[config.getReturnKind().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.replaceEachWithReturn(controlFlowElements2, factory2, (Function1<? super String, String>)((Function1)RsExtractFunctionHandler::adjustControlFlow$lambda$0));
                RsExprStmt rsExprStmt = syntaxTailStmt;
                if (rsExprStmt != null) {
                    RsStmtKt.addSemicolonIfNeeded(rsExprStmt);
                }
                org.rust.ide.surroundWith.UtilsKt.addStatement(block, factory2.createStatement("false"));
                break;
            }
            case 3: {
                this.replaceEachWithReturn(controlFlowElements2, factory2, (Function1<? super String, String>)((Function1)RsExtractFunctionHandler::adjustControlFlow$lambda$1));
                RsExprStmt rsExprStmt = syntaxTailStmt;
                if (rsExprStmt != null) {
                    RsStmtKt.addSemicolonIfNeeded(rsExprStmt);
                }
                org.rust.ide.surroundWith.UtilsKt.addStatement(block, factory2.createStatement("None"));
                break;
            }
            case 4: {
                this.replaceEachWithReturn(controlFlowElements2, factory2, (Function1<? super String, String>)((Function1)RsExtractFunctionHandler::adjustControlFlow$lambda$2));
                RsExprStmt rsExprStmt = syntaxTailStmt;
                if (rsExprStmt != null) {
                    this.wrapWith(rsExprStmt, "Some");
                }
                break;
            }
            case 5: {
                this.replaceEachWithReturn(controlFlowElements2, factory2, (Function1<? super String, String>)((Function1)RsExtractFunctionHandler::adjustControlFlow$lambda$3));
                RsExprStmt rsExprStmt = syntaxTailStmt;
                if (rsExprStmt != null) {
                    this.wrapWith(rsExprStmt, "Ok");
                }
                break;
            }
            case 6: {
                ControlFlow controlFlow = config.getControlFlow();
                Intrinsics.checkNotNull((Object)controlFlow);
                ControlFlow.TryOperatorInfo tryOperatorInfo = controlFlow.getTryOperatorInfo();
                Intrinsics.checkNotNull((Object)tryOperatorInfo);
                String constructor = tryOperatorInfo.getSuccessVariant();
                RsExprStmt rsExprStmt = syntaxTailStmt;
                RsExpr syntaxTailExpr = rsExprStmt != null ? rsExprStmt.getExpr() : null;
                if (syntaxTailExpr instanceof RsTryExpr && syntaxTailStmt.getSemicolon() == null) {
                    ((RsTryExpr)syntaxTailExpr).replace(((RsTryExpr)syntaxTailExpr).getExpr());
                    break;
                }
                if (config.getOutputVariables().getType() instanceof TyTuple && ((TyTuple)config.getOutputVariables().getType()).getTypes().isEmpty()) {
                    RsExprStmt rsExprStmt2 = syntaxTailStmt;
                    if (rsExprStmt2 != null) {
                        RsStmtKt.addSemicolonIfNeeded(rsExprStmt2);
                    }
                    org.rust.ide.surroundWith.UtilsKt.addStatement(block, factory2.createStatement(constructor + "(())"));
                    break;
                }
                RsExprStmt rsExprStmt3 = syntaxTailStmt;
                if (rsExprStmt3 != null) {
                    this.wrapWith(rsExprStmt3, constructor);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void replaceEachWithReturn(List<? extends PsiElement> $this$replaceEachWithReturn, RsPsiFactory factory2, Function1<? super String, String> getValue) {
        for (PsiElement psiElement2 : $this$replaceEachWithReturn) {
            if (psiElement2 instanceof RsTryExpr) continue;
            PsiElement psiElement3 = this.getControlFlowValue(psiElement2);
            String oldValue = psiElement3 != null ? psiElement3.getText() : null;
            String newValue = (String)getValue.invoke((Object)oldValue);
            psiElement2.replace((PsiElement)factory2.createExpression("return " + newValue));
        }
    }

    private final PsiElement getControlFlowValue(PsiElement $this$getControlFlowValue) {
        PsiElement psiElement2 = $this$getControlFlowValue;
        return psiElement2 instanceof RsRetExpr ? (PsiElement)((RsRetExpr)$this$getControlFlowValue).getExpr() : (psiElement2 instanceof RsBreakExpr ? (PsiElement)((RsBreakExpr)$this$getControlFlowValue).getExpr() : null);
    }

    private final void wrapWith(RsExprStmt $this$wrapWith, String constructor) {
        Project project = $this$wrapWith.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsExpr exprNew = new RsPsiFactory(project, false, false, 6, null).createExpression(constructor + "(" + $this$wrapWith.getText() + ")");
        $this$wrapWith.getExpr().replace(exprNew);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RsImplItem findExistingInherentImpl(RsImplItem traitImpl) {
        Object v3;
        block4: {
            void $this$firstOrNull$iv;
            Iterable $this$childrenOfType$iv;
            if (!(traitImpl.getTraitRef() != null)) {
                throw new IllegalStateException("Check failed.");
            }
            RsCachedImplItem cachedTraitImpl = RsCachedImplItem.Companion.forImpl(traitImpl);
            PsiElement psiElement2 = traitImpl.getParent();
            if (!(psiElement2 instanceof RsItemsOwner)) return null;
            RsItemsOwner rsItemsOwner = (RsItemsOwner)psiElement2;
            RsItemsOwner rsItemsOwner2 = rsItemsOwner;
            if (rsItemsOwner2 == null) return null;
            PsiElement psiElement3 = rsItemsOwner2;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, RsImplItem.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            List list2 = list;
            if (list2 == null) return null;
            $this$childrenOfType$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                RsImplItem impl = (RsImplItem)element$iv;
                boolean bl2 = false;
                RsCachedImplItem cachedImpl = RsCachedImplItem.Companion.forImpl(impl);
                if (cachedImpl.getTypeAndGenerics() == null) {
                    bl = false;
                } else {
                    Triple<Ty, List<TyTypeParameter>, List<CtConstParameter>> triple;
                    List generics = (List)triple.component2();
                    List constGenerics = (List)triple.component3();
                    bl = cachedImpl.isInherent() && cachedImpl.isValid() && !cachedImpl.isNegativeImpl() && generics.isEmpty() && constGenerics.isEmpty() && Intrinsics.areEqual(cachedImpl.getTypeAndGenerics(), cachedTraitImpl.getTypeAndGenerics());
                }
                if (!bl) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        RsImplItem rsImplItem = v3;
        return rsImplItem;
    }

    private final RsImplItem createNewInherentImpl(RsImplItem traitImpl) {
        PsiElement parent2 = traitImpl.getParent();
        Project project = parent2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        RsTypeReference rsTypeReference = traitImpl.getTypeReference();
        Intrinsics.checkNotNull((Object)rsTypeReference);
        RsTypeReference typeReference = rsTypeReference;
        GenericConstraints constraints = GenericConstraints.Companion.create(traitImpl).filterByTypeReferences(CollectionsKt.listOf((Object)typeReference));
        RsPsiRenderer renderer2 = new RsPsiRenderer(new PsiRenderingOptions(false, false, false, 7, null));
        String typeParameters = constraints.buildTypeParameters();
        String typeText = RsPsiRendererKt.renderTypeReference(renderer2, typeReference);
        String whereClause = constraints.buildWhereClause(true);
        String text = "impl" + typeParameters + " " + typeText + " " + whereClause + "{}";
        RsImplItem rsImplItem = psiFactory.tryCreateImplItem(text);
        if (rsImplItem == null) {
            return null;
        }
        RsImplItem newImpl = rsImplItem;
        PsiElement psiElement2 = parent2.addAfter((PsiElement)newImpl, (PsiElement)traitImpl);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsImplItem");
        RsImplItem newImplCopy = (RsImplItem)psiElement2;
        parent2.addBefore(psiFactory.createWhitespace("\n\n"), (PsiElement)newImplCopy);
        return newImplCopy;
    }

    /*
     * WARNING - void declaration
     */
    private final void renameFunctionParameters(RsFunction function, List<String> newNames) {
        RsPatIdent it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = RsFunctionKt.getRawValueParameters(function);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RsValueParameter rsValueParameter = (RsValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getPat());
        }
        $this$map$iv = CollectionsKt.filterIsInstance((Iterable)((List)destination$iv$iv), RsPatIdent.class);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (RsPatIdent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getPatBinding());
        }
        List parameters = (List)destination$iv$iv;
        for (Pair pair : CollectionsKt.zip((Iterable)parameters, (Iterable)newNames)) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv2;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            RsPatBinding parameter = (RsPatBinding)object;
            String newName = (String)pair.component2();
            if (Intrinsics.areEqual((Object)newName, (Object)parameter.getName())) continue;
            Collection parameterUsages = ReferencesSearch.search((PsiElement)parameter, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)function))).findAll();
            Iterable $this$map$iv2 = parameterUsages;
            boolean $i$f$map2 = false;
            Iterable bl = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                PsiReference psiReference = (PsiReference)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new UsageInfo((PsiReference)it3));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            UsageInfo[] usageInfo = thisCollection$iv.toArray(new UsageInfo[0]);
            new RsRenameProcessor().renameElement(parameter, newName, usageInfo, null);
        }
    }

    private final void replaceOldStatementsWithCallExpr(RsExtractFunctionConfig config, RsPsiFactory factory2) {
        String call2 = this.generateFunctionCallFull(config);
        for (PsiElement element : CollectionsKt.dropLast(config.getElements(), (int)1)) {
            element.delete();
        }
        PsiElement last = (PsiElement)CollectionsKt.last(config.getElements());
        if (last instanceof RsExpr) {
            last.replace((PsiElement)factory2.createExpression(StringsKt.removeSuffix((String)call2, (CharSequence)";")));
        } else if (last instanceof RsStmt) {
            last.replace((PsiElement)factory2.createStatement(call2));
        }
    }

    private final String generateFunctionCallFull(RsExtractFunctionConfig config) {
        String letPrefix;
        Object object;
        String call2;
        block11: {
            block10: {
                call2 = this.generateFunctionCall(config);
                object = config.getOutputVariables().getExprText();
                if (object == null) break block10;
                String it2 = object;
                boolean bl = false;
                String string = "let " + it2 + " = ";
                object = string;
                if (string != null) break block11;
            }
            object = "";
        }
        boolean needSemicolon = !Intrinsics.areEqual((Object)(letPrefix = object), (Object)"") || config.getOutputVariables().getType() instanceof TyTuple && ((TyTuple)config.getOutputVariables().getType()).getTypes().isEmpty() && (config.getControlFlow() == null || config.getReturnKind() == ReturnKind.TRY_OPERATOR);
        ControlFlow controlFlow = config.getControlFlow();
        String controlFlow2 = controlFlow != null ? controlFlow.getText() : null;
        return (switch (WhenMappings.$EnumSwitchMapping$0[config.getReturnKind().ordinal()]) {
            case 1 -> letPrefix + call2;
            case 2 -> "if " + call2 + " { " + controlFlow2 + "; }";
            case 3 -> "if let Some(value) = " + call2 + " {\n" + controlFlow2 + " value;\n}";
            case 4 -> letPrefix + "match " + call2 + " {\nSome(value) => value,\nNone => " + controlFlow2 + ",\n}";
            case 5 -> letPrefix + "match " + call2 + " {\nOk(value) => value,\nErr(value) => " + controlFlow2 + " value,\n}";
            case 6 -> letPrefix + call2 + "?";
            default -> throw new NoWhenBranchMatchedException();
        }) + (needSemicolon ? ";" : "");
    }

    private final String generateFunctionCall(RsExtractFunctionConfig config) {
        Parameter parameter = (Parameter)CollectionsKt.firstOrNull(config.getParameters());
        String self = (parameter != null ? parameter.isSelf() : false) ? "self." : (RsAbstractableKt.getOwner(config.getFunction()).isImplOrTrait() ? "Self::" : "");
        String await = config.isAsync() ? ".await" : "";
        return self + config.getName() + "(" + config.getArgumentsText() + ")" + await;
    }

    private static final Unit invoke$lambda$0(RsExtractFunctionHandler this$0, Project $project, PsiFile $file, RsExtractFunctionConfig $config) {
        this$0.extractFunction($project, $file, $config);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit extractFunction$lambda$0(Project $project, RsExtractFunctionHandler this$0, RsExtractFunctionConfig $config) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Parameter it2;
        void $this$filterTo$iv$iv;
        RsPsiFactory psiFactory = new RsPsiFactory($project, false, false, 6, null);
        RsFunction rsFunction = this$0.addExtractedFunction($project, $config, psiFactory);
        if (rsFunction == null) {
            return Unit.INSTANCE;
        }
        RsFunction extractedFunction = rsFunction;
        this$0.replaceOldStatementsWithCallExpr($config, psiFactory);
        Iterable $this$filter$iv = $config.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (Parameter)element$iv$iv;
            boolean bl = false;
            if (!it2.isSelected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parameters = (List)destination$iv$iv;
        $this$filter$iv = parameters;
        RsFunction rsFunction2 = extractedFunction;
        RsExtractFunctionHandler rsExtractFunctionHandler = this$0;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (Parameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getName());
        }
        collection = (List)destination$iv$iv;
        rsExtractFunctionHandler.renameFunctionParameters(rsFunction2, (List<String>)collection);
        RsImportHelper.importTypeReferencesFromTys$default(RsImportHelper.INSTANCE, extractedFunction, $config.getParametersAndReturnTypes(), false, false, 12, null);
        return Unit.INSTANCE;
    }

    private static final String adjustControlFlow$lambda$0(String it2) {
        return "true";
    }

    private static final String adjustControlFlow$lambda$1(String it2) {
        return "Some(" + it2 + ")";
    }

    private static final String adjustControlFlow$lambda$2(String it2) {
        return "None";
    }

    private static final String adjustControlFlow$lambda$3(String it2) {
        return "Err(" + it2 + ")";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReturnKind.values().length];
            try {
                nArray[ReturnKind.VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnKind.BOOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnKind.OPTION_CONTROL_FLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnKind.OPTION_VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnKind.RESULT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnKind.TRY_OPERATOR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

