/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.util.ui.ColumnInfo;
import java.util.List;
import javax.swing.event.TableModelEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.refactoring.changeSignature.ModelItem;
import org.rust.ide.refactoring.changeSignature.Parameter;
import org.rust.ide.refactoring.changeSignature.ParameterProperty;
import org.rust.ide.refactoring.changeSignature.SignatureDescriptor;
import org.rust.ide.refactoring.changeSignature.SignatureParameter;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.RsFileType;
import org.rust.lang.core.psi.RsExpressionCodeFragment;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTypeReferenceCodeFragment;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001d\u001eB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/rust/ide/refactoring/changeSignature/TableModel;", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelBase;", "Lorg/rust/ide/refactoring/changeSignature/SignatureParameter;", "Lorg/rust/ide/refactoring/changeSignature/ModelItem;", "descriptor", "Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;", "onUpdate", "Lkotlin/Function0;", "", "<init>", "(Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;Lkotlin/jvm/functions/Function0;)V", "getDescriptor", "()Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;", "getOnUpdate", "()Lkotlin/jvm/functions/Function0;", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "importContext", "Lorg/rust/lang/core/psi/ext/RsMod;", "createRowItem", "parameterInfo", "removeRow", "index", "", "fireTableRowsUpdated", "firstRow", "lastRow", "createNewParameter", "Lorg/rust/ide/refactoring/changeSignature/Parameter;", "SignatureTypeColumn", "SignatureDefaultValueColumn", "intellij.rustrover.core"})
final class TableModel
extends ParameterTableModelBase<SignatureParameter, ModelItem> {
    @NotNull
    private final SignatureDescriptor descriptor;
    @NotNull
    private final Function0<Unit> onUpdate;
    @NotNull
    private final RsPsiFactory factory;
    @NotNull
    private final RsMod importContext;

    public TableModel(@NotNull SignatureDescriptor descriptor, @NotNull Function0<Unit> onUpdate) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(onUpdate, (String)"onUpdate");
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ParameterTableModelBase.NameColumn(descriptor.getFunction().getProject(), RsBundle.INSTANCE.message("column.name.pattern", new Object[0])), new SignatureTypeColumn(descriptor), new SignatureDefaultValueColumn(descriptor)};
        super((PsiElement)descriptor.getFunction(), (PsiElement)descriptor.getFunction(), columnInfoArray);
        this.descriptor = descriptor;
        this.onUpdate = onUpdate;
        Project project = this.descriptor.getFunction().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.factory = new RsPsiFactory(project, false, false, 6, null);
        this.importContext = ImportUtilsKt.createVirtualImportContext(this.descriptor.getFunction());
        this.addTableModelListener(arg_0 -> TableModel._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final SignatureDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final Function0<Unit> getOnUpdate() {
        return this.onUpdate;
    }

    @NotNull
    protected ModelItem createRowItem(@Nullable SignatureParameter parameterInfo) {
        SignatureParameter signatureParameter;
        if (parameterInfo == null) {
            Parameter newParameter = this.createNewParameter(this.descriptor);
            this.descriptor.getConfig().getParameters().add(newParameter);
            signatureParameter = new SignatureParameter(newParameter);
        } else {
            signatureParameter = parameterInfo;
        }
        SignatureParameter parameter = signatureParameter;
        return new ModelItem(this.importContext, parameter);
    }

    public void removeRow(int index) {
        this.descriptor.getConfig().getParameters().remove(index);
        super.removeRow(index);
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        List<Parameter> parameters = this.descriptor.getConfig().getParameters();
        Parameter tmp = parameters.get(firstRow);
        parameters.set(firstRow, parameters.get(lastRow));
        parameters.set(lastRow, tmp);
        super.fireTableRowsUpdated(firstRow, lastRow);
    }

    private final Parameter createNewParameter(SignatureDescriptor descriptor) {
        return new Parameter(this.factory, "p" + descriptor.getParametersCount(), new ParameterProperty.Empty(), 0, null, 24, null);
    }

    private static final void _init_$lambda$0(TableModel this$0, TableModelEvent it2) {
        this$0.onUpdate.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/ide/refactoring/changeSignature/TableModel$SignatureDefaultValueColumn;", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelBase$DefaultValueColumn;", "Lorg/rust/ide/refactoring/changeSignature/SignatureParameter;", "Lorg/rust/ide/refactoring/changeSignature/ModelItem;", "descriptor", "Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;", "<init>", "(Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;)V", "setValue", "", "item", "value", "Lcom/intellij/psi/PsiCodeFragment;", "intellij.rustrover.core"})
    private static final class SignatureDefaultValueColumn
    extends ParameterTableModelBase.DefaultValueColumn<SignatureParameter, ModelItem> {
        public SignatureDefaultValueColumn(@NotNull SignatureDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            super(descriptor.getFunction().getProject(), (FileType)RsFileType.INSTANCE);
        }

        public void setValue(@Nullable ModelItem item, @Nullable PsiCodeFragment value) {
            RsExpressionCodeFragment rsExpressionCodeFragment = value instanceof RsExpressionCodeFragment ? (RsExpressionCodeFragment)value : null;
            if (rsExpressionCodeFragment == null) {
                return;
            }
            RsExpressionCodeFragment fragment = rsExpressionCodeFragment;
            if (item != null) {
                Parameter parameter = ((SignatureParameter)item.parameter).getParameter();
                RsElement rsElement = fragment.getExpr();
                String string = fragment.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                parameter.setDefaultValue(ParameterProperty.Companion.fromText(rsElement, string));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/ide/refactoring/changeSignature/TableModel$SignatureTypeColumn;", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelBase$TypeColumn;", "Lorg/rust/ide/refactoring/changeSignature/SignatureParameter;", "Lorg/rust/ide/refactoring/changeSignature/ModelItem;", "descriptor", "Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;", "<init>", "(Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;)V", "setValue", "", "item", "value", "Lcom/intellij/psi/PsiCodeFragment;", "intellij.rustrover.core"})
    private static final class SignatureTypeColumn
    extends ParameterTableModelBase.TypeColumn<SignatureParameter, ModelItem> {
        public SignatureTypeColumn(@NotNull SignatureDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            super(descriptor.getFunction().getProject(), (FileType)RsFileType.INSTANCE);
        }

        public void setValue(@Nullable ModelItem item, @Nullable PsiCodeFragment value) {
            RsTypeReferenceCodeFragment rsTypeReferenceCodeFragment = value instanceof RsTypeReferenceCodeFragment ? (RsTypeReferenceCodeFragment)value : null;
            if (rsTypeReferenceCodeFragment == null) {
                return;
            }
            RsTypeReferenceCodeFragment fragment = rsTypeReferenceCodeFragment;
            if (item != null) {
                Parameter parameter = ((SignatureParameter)item.parameter).getParameter();
                RsElement rsElement = fragment.getTypeReference();
                String string = fragment.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                parameter.setType(ParameterProperty.Companion.fromText(rsElement, string));
            }
        }
    }
}

