/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.refactoring.changeSignature.RsChangeFunctionSignatureConfig;
import org.rust.ide.refactoring.changeSignature.RsChangeSignatureDialogKt;
import org.rust.ide.refactoring.changeSignature.RsChangeSignatureHandlerKt;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J/\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u001a\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u001b\u001a\u00020\u0005H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/rust/ide/refactoring/changeSignature/RsChangeSignatureHandler;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureHandler;", "<init>", "()V", "getTargetNotFoundMessage", "", "findTargetMember", "Lorg/rust/lang/core/psi/RsFunction;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "elements", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invokeOnFunction", "function", "showRefactoringDialog", "showCannotRefactorErrorHint", "message", "Companion", "intellij.rustrover.core"})
public final class RsChangeSignatureHandler
implements ChangeSignatureHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getTargetNotFoundMessage() {
        return RsBundle.INSTANCE.message("dialog.message.caret.should.be.positioned.at.function.or.method", new Object[0]);
    }

    @Nullable
    public RsFunction findTargetMember(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (PsiElement el : PsiElementKt.getAncestors(element)) {
            RsFunction rsFunction;
            PsiElement psiElement2 = el;
            if (psiElement2 instanceof RsFunction) {
                rsFunction = (RsFunction)el;
            } else if (psiElement2 instanceof RsCallExpr) {
                RsElement rsElement;
                RsExpr rsExpr = ((RsCallExpr)el).getExpr();
                Object object = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
                RsElement rsElement2 = object != null && (object = object.getPath()) != null && (object = object.getReference()) != null ? object.resolve() : (rsElement = null);
                rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
            } else if (psiElement2 instanceof RsMethodCall) {
                RsElement rsElement = ((RsMethodCall)el).getReference().resolve();
                rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
            } else {
                if (!(psiElement2 instanceof RsBlock)) continue;
                return null;
            }
            return rsFunction;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        Object object = ArraysKt.singleOrNull((Object[])elements2);
        RsFunction rsFunction = object instanceof RsFunction ? (RsFunction)object : null;
        if (rsFunction == null) {
            return;
        }
        RsFunction function = rsFunction;
        DataContext dataContext2 = dataContext;
        this.invokeOnFunction(function, (Editor)(dataContext2 != null ? UtilsKt.getEditor(dataContext2) : null));
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DataContext dataContext2 = dataContext;
        PsiElement psiElement2 = dataContext2 != null ? UtilsKt.getElementUnderCaretInEditor(dataContext2) : null;
        RsFunction rsFunction = psiElement2 instanceof RsFunction ? (RsFunction)psiElement2 : null;
        if (rsFunction == null) {
            return;
        }
        RsFunction function = rsFunction;
        this.invokeOnFunction(function, editor2);
    }

    private final void invokeOnFunction(RsFunction function, Editor editor2) {
        RsFunction rsFunction = RsChangeSignatureHandlerKt.access$getSuperMethod(function);
        if (rsFunction == null) {
            rsFunction = function;
        }
        RsFunction targetFunction = rsFunction;
        this.showRefactoringDialog(targetFunction, editor2);
    }

    private final void showRefactoringDialog(RsFunction function, Editor editor2) {
        RsChangeFunctionSignatureConfig config = RsChangeFunctionSignatureConfig.Companion.create(function);
        Project project = function.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String error = RsChangeSignatureHandler.Companion.checkFunction(function);
        if (error == null) {
            RsChangeSignatureDialogKt.showChangeFunctionSignatureDialog(project2, config);
        } else if (editor2 != null) {
            this.showCannotRefactorErrorHint(project2, editor2, error);
        }
    }

    private final void showCannotRefactorErrorHint(Project project, Editor editor2, @NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RefactoringBundle.getCannotRefactorMessage((String)message), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.changeSignature");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\n"}, d2={"Lorg/rust/ide/refactoring/changeSignature/RsChangeSignatureHandler$Companion;", "", "<init>", "()V", "isChangeSignatureAvailable", "", "function", "Lorg/rust/lang/core/psi/RsFunction;", "checkFunction", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isChangeSignatureAvailable(@NotNull RsFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            return this.checkFunction(function) == null;
        }

        @NlsContexts.DialogMessage
        private final String checkFunction(RsFunction function) {
            if (function.getContainingCrate().getOrigin() != PackageOrigin.WORKSPACE) {
                return RsBundle.INSTANCE.message("dialog.message.cannot.change.signature.function.in.foreign.crate", new Object[0]);
            }
            if (!Intrinsics.areEqual(RsFunctionKt.getValueParameters(function), RsFunctionKt.getRawValueParameters(function))) {
                return RsBundle.INSTANCE.message("refactoring.change.signature.error.cfg.disabled.parameters", new Object[0]);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

