/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.refactoring.changeSignature.ModelItem;
import org.rust.ide.refactoring.changeSignature.Parameter;
import org.rust.ide.refactoring.changeSignature.ParameterProperty;
import org.rust.ide.refactoring.changeSignature.RsChangeFunctionSignatureConfig;
import org.rust.ide.refactoring.changeSignature.RsChangeSignatureDialogKt;
import org.rust.ide.refactoring.changeSignature.RsChangeSignatureProcessor;
import org.rust.ide.refactoring.changeSignature.SignatureDescriptor;
import org.rust.ide.refactoring.changeSignature.SignatureParameter;
import org.rust.ide.refactoring.changeSignature.TableModel;
import org.rust.ide.refactoring.changeSignature.VisibilityComboBox;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.RsFileType;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsTypeReferenceCodeFragment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002&\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J<\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010%2\u0016\u0010&\u001a\u0012\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00030(\u0018\u00010'H\u0014J\n\u0010)\u001a\u0004\u0018\u00010\u0004H\u0014J\b\u0010*\u001a\u00020\u000eH\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020,H\u0014J\b\u0010.\u001a\u00020,H\u0014J\b\u0010/\u001a\u00020,H\u0002J\n\u00100\u001a\u0004\u0018\u00010\u0004H\u0003J\b\u00101\u001a\u00020\u0004H\u0014J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u000403H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/rust/ide/refactoring/changeSignature/ChangeSignatureDialog;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureDialogBase;", "Lorg/rust/ide/refactoring/changeSignature/SignatureParameter;", "Lorg/rust/lang/core/psi/RsFunction;", "", "Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;", "Lorg/rust/ide/refactoring/changeSignature/ModelItem;", "Lorg/rust/ide/refactoring/changeSignature/TableModel;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/ide/refactoring/changeSignature/SignatureDescriptor;)V", "isValid", "", "config", "Lorg/rust/ide/refactoring/changeSignature/RsChangeFunctionSignatureConfig;", "getConfig", "()Lorg/rust/ide/refactoring/changeSignature/RsChangeFunctionSignatureConfig;", "visibilityComboBox", "Lorg/rust/ide/refactoring/changeSignature/VisibilityComboBox;", "getFileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "placeReturnTypeBeforeName", "createNorthPanel", "Ljavax/swing/JComponent;", "createSouthAdditionalPanel", "Ljavax/swing/JPanel;", "createParametersInfoModel", "createRefactoringProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "createReturnTypeCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "createCallerChooser", "Lcom/intellij/refactoring/changeSignature/CallerChooserBase;", "title", "treeToReuse", "Lcom/intellij/ui/treeStructure/Tree;", "callback", "Lcom/intellij/util/Consumer;", "", "validateAndCommitData", "areButtonsValid", "updateSignature", "", "updateSignatureAlarmFired", "canRun", "updateState", "validateAndUpdateData", "calculateSignature", "createVisibilityControl", "Lcom/intellij/refactoring/ui/ComboBoxVisibilityPanel;", "intellij.rustrover.core"})
final class ChangeSignatureDialog
extends ChangeSignatureDialogBase<SignatureParameter, RsFunction, String, SignatureDescriptor, ModelItem, TableModel> {
    private boolean isValid;
    @Nullable
    private VisibilityComboBox visibilityComboBox;

    public ChangeSignatureDialog(@NotNull Project project, @NotNull SignatureDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(project, (MethodDescriptor)descriptor, false, (PsiElement)descriptor.getFunction());
        this.isValid = true;
    }

    private final RsChangeFunctionSignatureConfig getConfig() {
        return ((SignatureDescriptor)this.myMethod).getConfig();
    }

    @NotNull
    protected LanguageFileType getFileType() {
        return RsFileType.INSTANCE;
    }

    public boolean placeReturnTypeBeforeName() {
        return false;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JComponent jComponent = super.createNorthPanel();
        if (jComponent == null) {
            return null;
        }
        JComponent panel2 = jComponent;
        this.myNameField.setPreferredWidth(-1);
        this.myReturnTypeField.setPreferredWidth(-1);
        if (this.getConfig().getAllowsVisibilityChange()) {
            JPanel visibilityPanel = new JPanel(new BorderLayout(0, 2));
            JLabel visibilityLabel = new JLabel(RsBundle.INSTANCE.message("visibility", new Object[0]));
            visibilityPanel.add((Component)visibilityLabel, "North");
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VisibilityComboBox visibility = new VisibilityComboBox(project, this.getConfig().getVisibility(), (Function0<Unit>)((Function0)() -> ChangeSignatureDialog.createNorthPanel$lambda$0(this)));
            visibilityLabel.setLabelFor(visibility.getComponent());
            visibilityPanel.add((Component)visibility.getComponent(), "South");
            this.visibilityComboBox = visibility;
            LayoutManager layoutManager = panel2.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.GridBagLayout");
            GridBagLayout layout = (GridBagLayout)layoutManager;
            Object object = layout.getConstraints(this.myNamePanel).clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.GridBagConstraints");
            GridBagConstraints nameConstraints = (GridBagConstraints)object;
            nameConstraints.gridx = 1;
            layout.setConstraints(this.myNamePanel, nameConstraints);
            Container myReturnTypePanel = this.myReturnTypeField.getParent();
            Object object2 = layout.getConstraints(myReturnTypePanel).clone();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.awt.GridBagConstraints");
            GridBagConstraints returnTypeConstraints = (GridBagConstraints)object2;
            returnTypeConstraints.gridx = 2;
            layout.setConstraints(myReturnTypePanel, returnTypeConstraints);
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
            panel2.add((Component)visibilityPanel, gbc);
        }
        return panel2;
    }

    @NotNull
    protected JPanel createSouthAdditionalPanel() {
        JPanel jPanel;
        JCheckBox asyncBox = ComponentsKt.CheckBox$default((String)RsBundle.INSTANCE.message("checkbox.async", new Object[0]), (boolean)this.getConfig().isAsync(), null, (int)4, null);
        asyncBox.addChangeListener(arg_0 -> ChangeSignatureDialog.createSouthAdditionalPanel$lambda$0(this, asyncBox, arg_0));
        JCheckBox unsafeBox = ComponentsKt.CheckBox$default((String)RsBundle.INSTANCE.message("checkbox.unsafe", new Object[0]), (boolean)this.getConfig().isUnsafe(), null, (int)4, null);
        unsafeBox.addChangeListener(arg_0 -> ChangeSignatureDialog.createSouthAdditionalPanel$lambda$1(this, unsafeBox, arg_0));
        JPanel $this$createSouthAdditionalPanel_u24lambda_u242 = jPanel = new JPanel();
        boolean bl = false;
        $this$createSouthAdditionalPanel_u24lambda_u242.setLayout((LayoutManager)new MigLayout("align center center, insets 0 " + JBUI.scale((int)10) + " 0 0"));
        $this$createSouthAdditionalPanel_u24lambda_u242.add(asyncBox);
        $this$createSouthAdditionalPanel_u24lambda_u242.add(unsafeBox);
        return jPanel;
    }

    @NotNull
    protected TableModel createParametersInfoModel(@NotNull SignatureDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new TableModel(descriptor, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((ChangeSignatureDialog)((Object)this.receiver)).updateSignature();
            }
        }));
    }

    @NotNull
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (BaseRefactoringProcessor)new RsChangeSignatureProcessor(project, RsChangeFunctionSignatureConfig.createChangeInfo$default(this.getConfig(), false, 1, null));
    }

    @NotNull
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        RsRetType rsRetType = ((SignatureDescriptor)this.myMethod).getFunction().getRetType();
        return RsChangeSignatureDialogKt.access$createTypeCodeFragment(ImportUtilsKt.createVirtualImportContext(((SignatureDescriptor)this.myMethod).getFunction()), rsRetType != null ? rsRetType.getTypeReference() : null);
    }

    @Nullable
    protected CallerChooserBase<RsFunction> createCallerChooser(@Nullable String title, @Nullable Tree treeToReuse, @Nullable Consumer<? super Set<? extends RsFunction>> callback) {
        return null;
    }

    @Nullable
    protected String validateAndCommitData() {
        Project project = this.getConfig().getFunction().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiManagerKt.getRustPsiManager(project).incRustStructureModificationCount();
        return this.validateAndUpdateData();
    }

    protected boolean areButtonsValid() {
        return this.isValid;
    }

    protected void updateSignature() {
        this.updateState();
        super.updateSignature();
    }

    protected void updateSignatureAlarmFired() {
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    protected void canRun() {
        String error = this.validateAndUpdateData();
        if (error != null) {
            throw new ConfigurationException(error);
        }
        super.canRun();
    }

    private final void updateState() {
        this.isValid = this.validateAndUpdateData() == null;
    }

    @NlsContexts.DialogMessage
    private final String validateAndUpdateData() {
        VisibilityComboBox visField;
        Project project = this.getConfig().getFunction().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        if (this.myNameField != null) {
            String string = this.myNameField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String functionName = string;
            if (RsChangeSignatureDialogKt.access$validateName(functionName)) {
                this.getConfig().setName(functionName);
            } else {
                return RsBundle.INSTANCE.message("dialog.message.function.name.must.be.valid.rust.identifier", new Object[0]);
            }
        }
        if (this.myReturnTypeField != null) {
            RsTypeReference returnType;
            String string = this.myReturnTypeField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String returnTypeText = string;
            if (StringsKt.isBlank((CharSequence)returnTypeText)) {
                v3 = factory2.createType("()");
            } else {
                PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
                RsTypeReferenceCodeFragment rsTypeReferenceCodeFragment = psiCodeFragment instanceof RsTypeReferenceCodeFragment ? (RsTypeReferenceCodeFragment)psiCodeFragment : null;
                v3 = returnType = rsTypeReferenceCodeFragment != null ? rsTypeReferenceCodeFragment.getTypeReference() : null;
            }
            if (returnType != null) {
                this.getConfig().setReturnTypeDisplay(returnType);
            } else {
                return RsBundle.INSTANCE.message("dialog.message.function.return.type.must.be.valid.rust.type", new Object[0]);
            }
        }
        if ((visField = this.visibilityComboBox) != null) {
            if (visField.getHasValidVisibility()) {
                this.getConfig().setVisibility(visField.getVisibility());
            } else {
                return RsBundle.INSTANCE.message("dialog.message.function.visibility.must.be.valid.visibility.specifier", new Object[0]);
            }
        }
        Iterator iterator2 = ((Iterable)this.getConfig().getParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Parameter parameter = (Parameter)iterator2.next();
            if (!parameter.hasValidPattern()) {
                Object[] objectArray = new Object[]{index};
                return RsBundle.INSTANCE.message("dialog.message.parameter.has.invalid.pattern", objectArray);
            }
            if (parameter.getType() instanceof ParameterProperty.Empty) {
                Object[] objectArray = new Object[]{index};
                return RsBundle.INSTANCE.message("dialog.message.please.enter.type.for.parameter", objectArray);
            }
            if (parameter.getType() instanceof ParameterProperty.Invalid) {
                Object[] objectArray = new Object[]{index};
                return RsBundle.INSTANCE.message("dialog.message.type.entered.for.parameter.invalid", objectArray);
            }
            if (!(parameter.getDefaultValue() instanceof ParameterProperty.Invalid)) continue;
            Object[] objectArray = new Object[]{index};
            return RsBundle.INSTANCE.message("dialog.message.default.value.entered.for.parameter.invalid", objectArray);
        }
        return null;
    }

    @NotNull
    protected String calculateSignature() {
        return this.getConfig().signature();
    }

    @NotNull
    protected ComboBoxVisibilityPanel<String> createVisibilityControl() {
        String[] stringArray = new String[]{};
        return (ComboBoxVisibilityPanel)new ComboBoxVisibilityPanel<String>(stringArray){};
    }

    private static final Unit createNorthPanel$lambda$0(ChangeSignatureDialog this$0) {
        this$0.updateSignature();
        return Unit.INSTANCE;
    }

    private static final void createSouthAdditionalPanel$lambda$0(ChangeSignatureDialog this$0, JCheckBox $asyncBox, ChangeEvent it2) {
        this$0.getConfig().setAsync($asyncBox.isSelected());
        this$0.updateSignature();
    }

    private static final void createSouthAdditionalPanel$lambda$1(ChangeSignatureDialog this$0, JCheckBox $unsafeBox, ChangeEvent it2) {
        this$0.getConfig().setUnsafe($unsafeBox.isSelected());
        this$0.updateSignature();
    }
}

