/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring;

import com.intellij.execution.RunManager;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.runconfig.command.CargoParametersHolder;
import org.rust.ide.actions.ui.RenameProjectDirectoryDialog;
import org.rust.ide.actions.ui.RenameProjectDirectoryDialogData;
import org.rust.ide.refactoring.RsRenameProjectDirectoryHandlerKt;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateGraphServiceKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPath;
import org.rust.stdext.UtilsKt;
import org.rust.toml.UtilKt;
import org.rust.toml.psi.PropertiesManipulatorsKt;
import org.rust.toml.psi.TomlPropertyBuilder;
import org.rust.toml.psi.TomlPropertyValue;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J.\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0006H\u0014J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u000f\u0010\u001e\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u001fH\u0016\u00a8\u0006 "}, d2={"Lorg/rust/ide/refactoring/RsRenameProjectDirectoryHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "Lcom/intellij/ide/TitledHandler;", "<init>", "()V", "isAvailableOnDataContext", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "getProjectDirectoryRenameData", "Lorg/rust/ide/actions/ui/RenameProjectDirectoryDialogData;", "oldDirectoryName", "", "oldProjectName", "isRootProject", "adjustRunConfigurations", "oldPackageName", "newPackageName", "getActionTitle", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsRenameProjectDirectoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsRenameProjectDirectoryHandler.kt\norg/rust/ide/refactoring/RsRenameProjectDirectoryHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n2746#2,3:334\n774#2:339\n865#2,2:340\n1563#2:342\n1634#2,3:343\n808#2,11:346\n23#3:337\n1#4:338\n*S KotlinDebug\n*F\n+ 1 RsRenameProjectDirectoryHandler.kt\norg/rust/ide/refactoring/RsRenameProjectDirectoryHandler\n*L\n70#1:334,3\n155#1:339\n155#1:340,2\n169#1:342\n169#1:343,3\n192#1:346,11\n80#1:337\n*E\n"})
public class RsRenameProjectDirectoryHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Project project = (Project)LangDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            Project project2 = project;
            Object[] objectArray = CommonRefactoringUtil.getPsiElementArray((DataContext)dataContext);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPsiElementArray(...)");
            Object[] elements2 = objectArray;
            Object object = ArraysKt.singleOrNull((Object[])elements2);
            PsiDirectory psiDirectory = object instanceof PsiDirectory ? (PsiDirectory)object : null;
            if (psiDirectory == null) {
                return false;
            }
            PsiDirectory directory = psiDirectory;
            Pair pair = RsRenameProjectDirectoryHandlerKt.access$findLibRsAndProject(project2, directory);
            if (pair == null) {
                return false;
            }
            Pair pair2 = pair;
            VirtualFile libRs = (VirtualFile)pair2.component1();
            CargoProject cargoProject = (CargoProject)pair2.component2();
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(cargoProject.getManifest());
            PsiFile psiFile = virtualFile != null ? org.rust.openapiext.UtilsKt.toPsiFile(virtualFile, project2) : null;
            TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
            if (tomlFile == null) {
                return false;
            }
            TomlFile cargoToml = tomlFile;
            String[] stringArray = new String[]{"package", "name"};
            if (PropertiesManipulatorsKt.findPropertyValue(cargoToml, stringArray) == null) {
                return false;
            }
            if (libRs != null) {
                Crate crate = CrateGraphServiceKt.getCrateGraph(project2).findCrateByRootMod(libRs);
                if (crate == null) {
                    return false;
                }
                Crate crate2 = crate;
                Iterable $this$none$iv = crate2.getReverseDependencies();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Object object2;
                        Object object3;
                        Crate it2 = (Crate)element$iv;
                        boolean bl2 = false;
                        CargoWorkspace.Target target = it2.getCargoTarget();
                        if (!(!((target != null ? target.getKind() : null) instanceof CargoWorkspace.TargetKind.ExampleBin) && !Intrinsics.areEqual((Object)((object3 = it2.getCargoTarget()) != null && (object3 = object3.getPkg()) != null ? object3.getId() : null), (object2 = crate2.getCargoTarget()) != null && (object2 = object2.getPkg()) != null ? object2.getId() : null))) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        RsRenameProjectDirectoryHandler $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RsRenameProjectDirectoryHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Project renaming should be never invoked from file");
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @NotNull DataContext dataContext) {
        boolean bl;
        Object it2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = ArraysKt.singleOrNull((Object[])elements2);
        PsiDirectory psiDirectory = object instanceof PsiDirectory ? (PsiDirectory)object : null;
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        Pair pair = RsRenameProjectDirectoryHandlerKt.access$findLibRsAndProject(project, directory);
        if (pair == null) {
            return;
        }
        Pair projectData = pair;
        VirtualFile virtualFile = directory.getVirtualFile().findChild("Cargo.toml");
        if (virtualFile == null) {
            return;
        }
        VirtualFile cargoTomlFile = virtualFile;
        PsiFile psiFile = org.rust.openapiext.UtilsKt.toPsiFile(cargoTomlFile, project);
        TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
        if (tomlFile == null) {
            return;
        }
        TomlFile cargoToml = tomlFile;
        Object object2 = project.getBasePath();
        if (object2 != null && (object2 = UtilsKt.toPath((String)object2)) != null) {
            it2 = object2;
            boolean bl2 = false;
            VirtualFile virtualFile2 = directory.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            bl = Intrinsics.areEqual((Object)it2, (Object)org.rust.openapiext.UtilsKt.getPathAsPath(virtualFile2));
        } else {
            bl = true;
        }
        boolean isRootProject = bl;
        CargoProject cargoProject = (CargoProject)projectData.getSecond();
        VirtualFile virtualFile3 = (VirtualFile)projectData.getFirst();
        PsiFile psiFile2 = virtualFile3 != null ? org.rust.openapiext.UtilsKt.toPsiFile(virtualFile3, project) : null;
        RsFile libRs = psiFile2 instanceof RsFile ? (RsFile)psiFile2 : null;
        Object object3 = directory.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getName(...)");
        Object oldDirectoryName = object3;
        Object object4 = new String[]{"package", "name"};
        String[] bl2 = PropertiesManipulatorsKt.findPropertyValue(cargoToml, (String[])object4);
        it2 = bl2 instanceof TomlPropertyValue.SimpleValue ? (TomlPropertyValue.SimpleValue)bl2 : null;
        Object oldProjectName = it2 != null && (bl2 = ((TomlPropertyValue.SimpleValue)it2).getValue()) != null && (object4 = UtilKt.getStringValue((TomlValue)bl2)) != null ? object4 : oldDirectoryName;
        RenameProjectDirectoryDialogData renameProjectDirectoryDialogData = this.getProjectDirectoryRenameData(project, (String)oldDirectoryName, (String)oldProjectName, isRootProject);
        if (renameProjectDirectoryDialogData == null) {
            return;
        }
        RenameProjectDirectoryDialogData result2 = renameProjectDirectoryDialogData;
        RsCounterUsagesCollector.INSTANCE.logRenamePackageDirectoryActionCalled(result2.getRenameProject(), result2.getRenameDirectory(), Intrinsics.areEqual((Object)result2.getNewProjectName(), (Object)result2.getNewDirectoryName()));
        if (result2.getRenameProject()) {
            Object elements3;
            if (isRootProject) {
                RsRenameProjectDirectoryHandlerKt.access$runRenameCommandAction(project, () -> RsRenameProjectDirectoryHandler.invoke$lambda$1(project, cargoToml, result2, (String)oldProjectName));
            }
            if (libRs != null && PropertiesManipulatorsKt.findPropertyValue(cargoToml, bl2 = new String[]{"lib", "name"}) == null) {
                elements3 = (List)TasksKt.runWithModalProgressBlocking((Project)project, (String)RsBundle.INSTANCE.message("progress.rename.package.search.usages", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends SmartPsiElementPointer<RsPath>>>, Object>(project, (String)oldProjectName, libRs, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $oldProjectName;
                    final /* synthetic */ RsFile $libRs;
                    {
                        this.$project = $project;
                        this.$oldProjectName = $oldProjectName;
                        this.$libRs = $libRs;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return RsRenameProjectDirectoryHandlerKt.access$findPackageNameReferences(this.$project, this.$oldProjectName, this.$libRs);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends SmartPsiElementPointer<RsPath>>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                RsRenameProjectDirectoryHandlerKt.access$runRenameWriteAction(project, () -> RsRenameProjectDirectoryHandler.invoke$lambda$2(result2, (List)elements3, project));
            }
            if (PropertiesManipulatorsKt.findPropertyValue(cargoToml, elements3 = new String[]{"package", "name"}) != null) {
                RsRenameProjectDirectoryHandlerKt.access$runRenameWriteAction(project, () -> RsRenameProjectDirectoryHandler.invoke$lambda$3(cargoToml, result2));
                RsRenameProjectDirectoryHandlerKt.access$runRenameCommandAction(project, () -> RsRenameProjectDirectoryHandler.invoke$lambda$4(project, cargoToml, this, (String)oldProjectName, result2));
            }
        }
        if (result2.getRenameDirectory()) {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CargoProject it3 = (CargoProject)element$iv$iv;
                boolean bl3 = false;
                if (!it3.getManifest().startsWith(cargoProject.getManifest().getParent())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List projectsToReattach = (List)destination$iv$iv;
            RsRenameProjectDirectoryHandlerKt.access$runRenameWriteAction(project, () -> RsRenameProjectDirectoryHandler.invoke$lambda$6(directory, result2, project, cargoTomlFile, (String)oldDirectoryName));
            for (CargoProject cargoProjectToReattach : projectsToReattach) {
                CargoProjectServiceKt.getCargoProjects(project).detachCargoProject(cargoProjectToReattach);
            }
            Object object5 = cargoProject.getRootDir();
            if (object5 == null || (object5 = object5.findChild("Cargo.toml")) == null || (object5 = org.rust.openapiext.UtilsKt.getPathAsPath((VirtualFile)object5)) == null) {
                return;
            }
            Object newManifestPath = object5;
            Iterable $this$map$iv = projectsToReattach;
            boolean $i$f$map = false;
            Iterable $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                CargoProject cargoProject2 = (CargoProject)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(newManifestPath.getParent().resolve(cargoProject.getManifest().getParent().relativize(it4.getManifest())));
            }
            List cargoTomlsToAttach = (List)destination$iv$iv2;
            FileDocumentManager.getInstance().saveAllDocuments();
            CargoProjectServiceKt.getCargoProjects(project).attachCargoProjects(cargoTomlsToAttach);
        }
    }

    @Nullable
    protected RenameProjectDirectoryDialogData getProjectDirectoryRenameData(@NotNull Project project, @Nls @NotNull String oldDirectoryName, @Nls @NotNull String oldProjectName, boolean isRootProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)oldDirectoryName, (String)"oldDirectoryName");
        Intrinsics.checkNotNullParameter((Object)oldProjectName, (String)"oldProjectName");
        return new RenameProjectDirectoryDialog(project, oldDirectoryName, oldProjectName, isRootProject).getResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustRunConfigurations(Project project, String oldPackageName, String newPackageName) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = RunManager.Companion.getInstance(project).getAllConfigurationsList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CargoCommandConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List potentialConfigurations = (List)destination$iv$iv;
        for (CargoCommandConfiguration potentialConfiguration : potentialConfigurations) {
            CargoParametersHolder cargoParametersHolder = potentialConfiguration.getParametersHolder();
            if (cargoParametersHolder != null) {
                RsRenameProjectDirectoryHandlerKt.access$replaceParamValueIfExists(cargoParametersHolder, "--package", oldPackageName, newPackageName);
            }
            CargoParametersHolder cargoParametersHolder2 = potentialConfiguration.getParametersHolder();
            if (cargoParametersHolder2 == null) continue;
            RsRenameProjectDirectoryHandlerKt.access$replaceParamValueIfExists(cargoParametersHolder2, "--bin", oldPackageName, newPackageName);
        }
    }

    @Nullable
    public String getActionTitle() {
        return RsBundle.INSTANCE.message("rename.package.action.title", new Object[0]);
    }

    private static final void invoke$lambda$1(Project $project, TomlFile $cargoToml, RenameProjectDirectoryDialogData $result, String $oldProjectName) {
        if ($project instanceof ProjectEx) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{$cargoToml.getVirtualFile()};
            VirtualFile[] virtualFileArray2 = virtualFileArray;
            UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction($project, $oldProjectName, $result, virtualFileArray2){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $oldProjectName;
                final /* synthetic */ RenameProjectDirectoryDialogData $result;
                {
                    this.$project = $project;
                    this.$oldProjectName = $oldProjectName;
                    this.$result = $result;
                    super($super_call_param$1);
                }

                public void undo() {
                    ((ProjectEx)this.$project).setProjectName(this.$oldProjectName);
                }

                public void redo() {
                    ((ProjectEx)this.$project).setProjectName(this.$result.getNewProjectName());
                }
            });
            ((ProjectEx)$project).setProjectName($result.getNewProjectName());
        }
    }

    private static final Unit invoke$lambda$2(RenameProjectDirectoryDialogData $result, List $elements, Project $project) {
        RsRenameProjectDirectoryHandlerKt.access$renameCrateUses($result.getNewProjectName(), $elements, $project);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$3(TomlFile $cargoToml, RenameProjectDirectoryDialogData $result) {
        PropertiesManipulatorsKt.addProperties($cargoToml, (Function1<? super TomlPropertyBuilder, Unit>)((Function1)arg_0 -> RsRenameProjectDirectoryHandler.invoke$lambda$3$0($result, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$3$0(RenameProjectDirectoryDialogData $result, TomlPropertyBuilder $this$addProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$addProperties, (String)"$this$addProperties");
        TomlPropertyBuilder.table$default($this$addProperties, "package", false, arg_0 -> RsRenameProjectDirectoryHandler.invoke$lambda$3$0$0($result, arg_0), 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$3$0$0(RenameProjectDirectoryDialogData $result, TomlPropertyBuilder $this$table) {
        Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
        $this$table.literal("name", $result.getNewProjectName());
        return Unit.INSTANCE;
    }

    private static final void invoke$lambda$4(Project $project, TomlFile $cargoToml, RsRenameProjectDirectoryHandler this$0, String $oldProjectName, RenameProjectDirectoryDialogData $result) {
        VirtualFile[] virtualFileArray = new VirtualFile[]{$cargoToml.getVirtualFile()};
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this$0, $project, $result, $oldProjectName, virtualFileArray2){
            final /* synthetic */ RsRenameProjectDirectoryHandler this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ RenameProjectDirectoryDialogData $result;
            final /* synthetic */ String $oldProjectName;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$result = $result;
                this.$oldProjectName = $oldProjectName;
                super($super_call_param$1);
            }

            public void undo() {
                RsRenameProjectDirectoryHandler.access$adjustRunConfigurations(this.this$0, this.$project, this.$result.getNewProjectName(), this.$oldProjectName);
            }

            public void redo() {
                RsRenameProjectDirectoryHandler.access$adjustRunConfigurations(this.this$0, this.$project, this.$oldProjectName, this.$result.getNewProjectName());
            }
        });
        this$0.adjustRunConfigurations($project, $oldProjectName, $result.getNewProjectName());
    }

    private static final Unit invoke$lambda$6(PsiDirectory $directory, RenameProjectDirectoryDialogData $result, Project $project, VirtualFile $cargoTomlFile, String $oldDirectoryName) {
        $directory.setName($result.getNewDirectoryName());
        RsRenameProjectDirectoryHandlerKt.access$maybeAdjustWorkspace($project, $cargoTomlFile, $oldDirectoryName, $result.getNewDirectoryName());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$adjustRunConfigurations(RsRenameProjectDirectoryHandler $this, Project project, String oldPackageName, String newPackageName) {
        $this.adjustRunConfigurations(project, oldPackageName, newPackageName);
    }
}

