/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.RenameUtilsKt;
import org.rust.ide.refactoring.RsFakeMacroExpansionRenameablePsiElement;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsLabel;
import org.rust.lang.core.psi.RsLabelDecl;
import org.rust.lang.core.psi.RsLifetime;
import org.rust.lang.core.psi.RsLifetimeParameter;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatFieldFull;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPatStruct;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsStructLiteralFieldKt;
import org.rust.lang.core.psi.ext.RsTraitItemKt;
import org.rust.lang.core.resolve.NameResolutionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J7\u0010\u0015\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ4\u0010\u001c\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J(\u0010!\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0#H\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000eH\u0016J\"\u0010)\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u000eH\u0016J,\u0010\u001c\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u001eH\u0016J\f\u0010+\u001a\u00020\u0012*\u00020\u0012H\u0002\u00a8\u0006,"}, d2={"Lorg/rust/ide/refactoring/RsRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "canProcessElement", "", "findExistingNameConflicts", "", "newName", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "renameElement", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "prepareRenaming", "allRenames", "", "scope", "Lcom/intellij/psi/search/SearchScope;", "substituteElementToRename", "renameCallback", "Lcom/intellij/openapi/util/Pass;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "searchInCommentsAndStrings", "getQualifiedNameAfterRename", "nonJava", "ensureQuote", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsRenameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsRenameProcessor.kt\norg/rust/ide/refactoring/RsRenameProcessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 4 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n66#2,2:191\n66#2,2:193\n66#2,2:212\n18#3:195\n121#4:196\n1617#5,9:197\n1869#5:206\n1870#5:208\n1626#5:209\n1869#5,2:210\n1#6:207\n*S KotlinDebug\n*F\n+ 1 RsRenameProcessor.kt\norg/rust/ide/refactoring/RsRenameProcessor\n*L\n50#1:191,2\n54#1:193,2\n65#1:212,2\n92#1:195\n108#1:196\n174#1:197,9\n174#1:206\n174#1:208\n174#1:209\n175#1:210,2\n174#1:207\n*E\n"})
public final class RsRenameProcessor
extends RenamePsiElementProcessor {
    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new RenameDialog(project, element, nameSuggestionContext, editor2){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super($project, $element, $nameSuggestionContext, $editor);
            }

            protected String getFullName() {
                PsiElement psiElement2 = this.$element;
                Object object = psiElement2 instanceof RsFile ? (RsFile)psiElement2 : null;
                if (object == null || (object = ((RsFile)object).getModName()) == null) {
                    String string = super.getFullName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
                    return string;
                }
                Object mod = object;
                return "module " + (String)mod;
            }
        };
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof RsNamedElement || element instanceof RsFakeMacroExpansionRenameablePsiElement;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        RsElement scope;
        RsElement rsElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        RsPatBinding rsPatBinding = element instanceof RsPatBinding ? (RsPatBinding)element : null;
        if (rsPatBinding == null) {
            return;
        }
        RsPatBinding binding = rsPatBinding;
        PsiElement $this$parentOfType_u24default$iv = binding;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        RsFunction rsFunction = (RsFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsFunction.class, (boolean)true);
        if (rsFunction == null) {
            return;
        }
        RsFunction function = rsFunction;
        String string = function.getName();
        if (string == null) {
            return;
        }
        String functionName = string;
        List foundConflicts = new ArrayList();
        PsiElement $this$parentOfType_u24default$iv2 = binding;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, RsValueParameter.class, (boolean)true) != null) {
            PsiElement psiElement2;
            RsBlock rsBlock = RsFunctionKt.getBlock(function);
            PsiElement psiElement3 = rsBlock != null && (rsBlock = rsBlock.getRbrace()) != null ? PsiElementExtensionsKt.getPrevNonCommentSibling(rsBlock) : (psiElement2 = null);
            rsElement = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
        } else {
            rsElement = binding;
        }
        RsElement rsElement2 = scope = rsElement;
        if (rsElement2 != null) {
            RsElement s = rsElement2;
            boolean bl = false;
            NameResolutionKt.processLocalVariables(s, (Function1<? super RsPatBinding, Unit>)((Function1)arg_0 -> RsRenameProcessor.findExistingNameConflicts$lambda$0$0(newName, foundConflicts, functionName, arg_0)));
        }
        if (!((Collection)foundConflicts).isEmpty()) {
            conflicts.put((Object)element, (Collection)foundConflicts);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
        if (!(element instanceof RsNamedFieldDecl)) {
            int n = usages.length;
            for (int j = 0; j < n; ++j) {
                UsageInfo usage = usages[j];
                PsiElement psiElement3 = usage.getElement();
                if (psiElement3 != null) {
                    void $this$ancestorOrSelf$iv;
                    PsiElement psiElement4 = psiElement3;
                    Class<RsBlock> stopAt$iv = RsBlock.class;
                    boolean $i$f$ancestorOrSelf = false;
                    Class[] classArray = new Class[]{stopAt$iv};
                    psiElement3 = (RsStructLiteralField)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsStructLiteralField.class, (boolean)false, (Class[])classArray);
                    if (psiElement3 == null) {
                        continue;
                    }
                    PsiElement field = psiElement3;
                    if (RsStructLiteralFieldKt.isShorthand((RsStructLiteralField)field)) {
                        RsStructLiteralField newPatField = psiFactory.createStructLiteralField(field.getReferenceName(), newName);
                        field.replace((PsiElement)newPatField);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)field.getReferenceName(), (Object)newName)) continue;
                    RsExpr rsExpr = field.getExpr();
                    RsPathExpr rsPathExpr = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
                    if (!Intrinsics.areEqual((Object)(rsPathExpr != null ? rsPathExpr.getPath() : null), (Object)usage.getElement())) continue;
                    RsExpr rsExpr2 = field.getExpr();
                    if (rsExpr2 != null) {
                        rsExpr2.delete();
                    }
                    PsiElement psiElement5 = field.getColon();
                    if (psiElement5 == null) continue;
                    psiElement5.delete();
                }
            }
        }
        if (element instanceof RsPatBinding && ((RsPatBinding)element).getParent().getParent() instanceof RsPatStruct) {
            String string = ((RsPatBinding)element).getIdentifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = ((RsPatBinding)element).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            RsPatFieldFull newPatField = psiFactory.createPatFieldFull(string, string2);
            PsiElement psiElement6 = element.replace((PsiElement)newPatField);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"replace(...)");
            PsiElement $this$descendantOfTypeStrict$iv = psiElement6;
            boolean $i$f$descendantOfTypeStrict = false;
            PsiElement psiElement7 = PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeStrict$iv, RsPatBinding.class, (boolean)true);
            psiElement2 = psiElement7;
            Intrinsics.checkNotNull((Object)psiElement7);
        } else {
            psiElement2 = element;
        }
        PsiElement newRenameElement = psiElement2;
        super.renameElement(newRenameElement, newName, usages, listener2);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        String string;
        PsiElement semanticElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiElement psiElement2 = semanticElement = element instanceof RsFakeMacroExpansionRenameablePsiElement ? (PsiElement)((RsFakeMacroExpansionRenameablePsiElement)element).getExpandedElement() : element;
        if (semanticElement instanceof RsLifetime || semanticElement instanceof RsLifetimeParameter || semanticElement instanceof RsLabel || semanticElement instanceof RsLabelDecl) {
            string = this.ensureQuote(newName);
        } else {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trimStart((String)newName, (char[])cArray);
        }
        String rename = string;
        allRenames.put(element, rename);
    }

    @NotNull
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RenameUtilsKt.substituteElementToRename(element);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor2, @NotNull Pass<? super PsiElement> renameCallback) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(renameCallback, (String)"renameCallback");
        if (!RenameUtilsKt.isDisabledForRename(element)) {
            renameCallback.pass((Object)this.substituteElementToRename(element, editor2));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiElement refinedElement = element instanceof RsFakeMacroExpansionRenameablePsiElement ? (PsiElement)((RsFakeMacroExpansionRenameablePsiElement)element).getExpandedElement() : element;
        Collection collection = super.findReferences(refinedElement, searchScope, searchInCommentsAndStrings);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findReferences(...)");
        return collection;
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (element instanceof RsFile && Intrinsics.areEqual((Object)((RsFile)element).getName(), (Object)"mod.rs")) {
            return "mod.rs";
        }
        return super.getQualifiedNameAfterRename(element, newName, nonJava);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        PsiElement semanticElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        super.prepareRenaming(element, newName, allRenames);
        PsiElement psiElement2 = semanticElement = element instanceof RsFakeMacroExpansionRenameablePsiElement ? (PsiElement)((RsFakeMacroExpansionRenameablePsiElement)element).getExpandedElement() : element;
        if (psiElement2 instanceof RsAbstractable) {
            void $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            RsAbstractableOwner rsAbstractableOwner = RsAbstractableKt.getOwner((RsAbstractable)semanticElement);
            Object object = rsAbstractableOwner instanceof RsAbstractableOwner.Trait ? (RsAbstractableOwner.Trait)rsAbstractableOwner : null;
            if (object == null || (object = ((RsAbstractableOwner.Trait)object).getTrait()) == null) {
                return;
            }
            Object trait = object;
            Iterable iterable = RsTraitItemKt.searchForImplementations((RsTraitItem)trait).asIterable();
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                RsAbstractable it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                RsImplItem it2 = (RsImplItem)element$iv$iv;
                boolean bl2 = false;
                if (RsAbstractableKt.findCorrespondingElement(it2, (RsAbstractable)semanticElement) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                RsAbstractable it3 = (RsAbstractable)element$iv;
                boolean bl = false;
                Map<PsiElement, String> map2 = allRenames;
                PsiElement psiElement3 = RenameUtilsKt.findFakeElementForRenameInMacroBody(it3);
                if (psiElement3 == null) {
                    psiElement3 = it3;
                }
                map2.put(psiElement3, newName);
            }
        } else if (psiElement2 instanceof RsMod) {
            if (semanticElement instanceof RsFile && ((RsFile)semanticElement).getDeclaration() == null) {
                return;
            }
            if (((RsMod)semanticElement).getPathAttribute() != null) {
                return;
            }
            PsiDirectory psiDirectory = RsMod.getOwnedDirectory$default((RsMod)semanticElement, false, 1, null);
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory ownedDir = psiDirectory;
            allRenames.put((PsiElement)ownedDir, newName);
        }
    }

    private final String ensureQuote(String $this$ensureQuote) {
        return StringsKt.startsWith$default((CharSequence)$this$ensureQuote, (char)'\'', (boolean)false, (int)2, null) ? $this$ensureQuote : "'" + $this$ensureQuote;
    }

    private static final Unit findExistingNameConflicts$lambda$0$0(String $newName, List $foundConflicts, String $functionName, RsPatBinding it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        if (Intrinsics.areEqual((Object)it2.getName(), (Object)$newName)) {
            String string;
            if (it2.getParent() instanceof RsPatIdent) {
                PsiElement $this$parentOfType_u24default$iv = it2;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                string = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsValueParameter.class, (boolean)true) != null ? "Parameter" : "Variable";
            } else {
                string = "Binding";
            }
            String type = string;
            $foundConflicts.add(type + " `" + $newName + "` is already declared in function `" + $functionName + "`");
        }
        return Unit.INSTANCE;
    }
}

