/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.refactoring;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.openapiext.Testmark;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/refactoring/RsDirectoryRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiFileProcessor;", "<init>", "()V", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "canProcessElement", "", "prepareRenaming", "", "newName", "", "allRenames", "", "toDir", "Lcom/intellij/psi/PsiDirectory;", "Testmarks", "intellij.rustrover.core"})
public final class RsDirectoryRenameProcessor
extends RenamePsiFileProcessor {
    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RenameDialog renameDialog = super.createRenameDialog(project, (PsiElement)this.toDir(element), nameSuggestionContext, editor2);
        Intrinsics.checkNotNullExpressionValue((Object)renameDialog, (String)"createRenameDialog(...)");
        return renameDialog;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiDirectory) && !(element instanceof PsiDirectoryContainer)) {
            return false;
        }
        Project project = ((PsiNamedElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CargoProjectsService cargoProjectsService = CargoProjectServiceKt.getCargoProjects(project);
        VirtualFile virtualFile = this.toDir(element).getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return cargoProjectsService.findProjectForFile(virtualFile) != null;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Testmarks.RustDirRenameHandler.INSTANCE.hit();
        super.prepareRenaming(element, newName, allRenames);
        if (!RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY) {
            return;
        }
        PsiDirectory $this$prepareRenaming_u24lambda_u240 = this.toDir(element);
        boolean bl = false;
        Object object = $this$prepareRenaming_u24lambda_u240.findFile("mod.rs");
        if (object == null) {
            PsiDirectory psiDirectory = $this$prepareRenaming_u24lambda_u240.getParentDirectory();
            object = psiDirectory != null ? psiDirectory.findFile($this$prepareRenaming_u24lambda_u240.getName() + ".rs") : null;
        }
        if (object == null) {
            return;
        }
        PsiFile modrs = object;
        allRenames.put((PsiElement)modrs, newName);
    }

    private final PsiDirectory toDir(PsiElement $this$toDir) {
        PsiDirectory psiDirectory = $this$toDir instanceof PsiDirectoryContainer ? (PsiDirectory)$this$toDir : null;
        if (psiDirectory == null || (psiDirectory = psiDirectory.getDirectories()) == null || (psiDirectory = (PsiDirectory)ArraysKt.first((Object[])psiDirectory)) == null) {
            Intrinsics.checkNotNull((Object)$this$toDir, (String)"null cannot be cast to non-null type com.intellij.psi.PsiDirectory");
            psiDirectory = (PsiDirectory)$this$toDir;
        }
        return psiDirectory;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/rust/ide/refactoring/RsDirectoryRenameProcessor$Testmarks;", "", "<init>", "()V", "RustDirRenameHandler", "intellij.rustrover.core"})
    public static final class Testmarks {
        @NotNull
        public static final Testmarks INSTANCE = new Testmarks();

        private Testmarks() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/ide/refactoring/RsDirectoryRenameProcessor$Testmarks$RustDirRenameHandler;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class RustDirRenameHandler
        extends Testmark {
            @NotNull
            public static final RustDirRenameHandler INSTANCE = new RustDirRenameHandler();

            private RustDirRenameHandler() {
            }
        }
    }
}

