/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.notifications;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.cargo.project.configurable.RsExternalLinterConfigurable;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsServiceKt;
import org.rust.ide.notifications.UtilsKt;
import org.rust.ide.statistics.ExternalLinterUsageCollector;
import org.rust.ide.status.RsExternalLinterWidget;
import org.rust.openapiext.RsPluginDisposable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/notifications/RsExternalLinterSlowRunNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "maxDuration", "", "getMaxDuration", "()I", "prevDurations", "Ljava/util/Queue;", "", "reportDuration", "", "duration", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsExternalLinterSlowRunNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsExternalLinterSlowRunNotifier.kt\norg/rust/ide/notifications/RsExternalLinterSlowRunNotifier\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,76:1\n479#2,2:77\n*S KotlinDebug\n*F\n+ 1 RsExternalLinterSlowRunNotifier.kt\norg/rust/ide/notifications/RsExternalLinterSlowRunNotifier\n*L\n55#1:77,2\n*E\n"})
public final class RsExternalLinterSlowRunNotifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Queue<Long> prevDurations;
    private static final int MAX_QUEUE_SIZE = 10;
    @NotNull
    private static final String DO_NOT_SHOW_KEY = "org.rust.external.linter.slow.run.do.not.show";
    @NotNull
    private static final Key<Boolean> DO_NOT_SHOW_PROJECT_KEY;
    @NotNull
    private static final RegistryValue LINTER_MAX_DURATION;

    public RsExternalLinterSlowRunNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.prevDurations = new ArrayDeque();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final int getMaxDuration() {
        return LINTER_MAX_DURATION.asInteger();
    }

    @RequiresEdt
    public final void reportDuration(long duration) {
        long minPrevDuration;
        this.prevDurations.add(duration);
        while (this.prevDurations.size() > 10) {
            this.prevDurations.remove();
        }
        if (PropertiesComponent.getInstance().getBoolean(DO_NOT_SHOW_KEY, false) || Intrinsics.areEqual((Object)this.project.getUserData(DO_NOT_SHOW_PROJECT_KEY), (Object)true)) {
            return;
        }
        Long l = (Long)CollectionsKt.minOrNull((Iterable)this.prevDurations);
        long l2 = minPrevDuration = l != null ? l : 0L;
        if (this.prevDurations.size() == 10 && minPrevDuration > (long)this.getMaxDuration()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.project);
            if (statusBar == null) {
                return;
            }
            StatusBar statusBar2 = statusBar;
            Object[] objectArray = statusBar2.getWidget("rustExternalLinterWidget");
            RsExternalLinterWidget rsExternalLinterWidget = objectArray instanceof RsExternalLinterWidget ? (RsExternalLinterWidget)objectArray : null;
            if (rsExternalLinterWidget == null) {
                return;
            }
            RsExternalLinterWidget widget = rsExternalLinterWidget;
            objectArray = new Object[]{RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings(this.project).getTool().getTitle()};
            String content = RsBundle.INSTANCE.message("notification.content.external.linter.slow", objectArray);
            Component component = (Component)((Object)widget);
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
            UtilsKt.showBalloon(component, content, messageType, RsPluginDisposable.Companion.getInstance(this.project), arg_0 -> RsExternalLinterSlowRunNotifier.reportDuration$lambda$0(this, arg_0));
            ExternalLinterUsageCollector.INSTANCE.logNotification(this.project);
            this.project.putUserData(DO_NOT_SHOW_PROJECT_KEY, (Object)true);
        }
    }

    private static final void reportDuration$lambda$0(RsExternalLinterSlowRunNotifier this$0, HyperlinkEvent e) {
        HyperlinkEvent hyperlinkEvent = e;
        if (Intrinsics.areEqual((Object)(hyperlinkEvent != null ? hyperlinkEvent.getEventType() : null), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String string = e.getDescription();
            if (Intrinsics.areEqual((Object)string, (Object)"disable")) {
                ExternalLinterUsageCollector.INSTANCE.logNotificationDisabled(this$0.project);
                Project $this$showSettingsDialog$iv = this$0.project;
                boolean $i$f$showSettingsDialog = false;
                ShowSettingsUtil.getInstance().showSettingsDialog($this$showSettingsDialog$iv, RsExternalLinterConfigurable.class);
            } else if (Intrinsics.areEqual((Object)string, (Object)"dont-show-again")) {
                ExternalLinterUsageCollector.INSTANCE.logNotificationDoNotShow(this$0.project);
                PropertiesComponent.getInstance().setValue(DO_NOT_SHOW_KEY, true, false);
            }
        }
    }

    static {
        Key key = Key.create((String)DO_NOT_SHOW_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DO_NOT_SHOW_PROJECT_KEY = key;
        LINTER_MAX_DURATION = Registry.Companion.get("org.rust.external.linter.max.duration");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rust/ide/notifications/RsExternalLinterSlowRunNotifier$Companion;", "", "<init>", "()V", "MAX_QUEUE_SIZE", "", "DO_NOT_SHOW_KEY", "", "DO_NOT_SHOW_PROJECT_KEY", "Lcom/intellij/openapi/util/Key;", "", "LINTER_MAX_DURATION", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

