/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.notifications;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.autolink.UnlinkedProjectsUtils;
import org.rust.cargo.project.model.AttachCargoProjectAction;
import org.rust.cargo.project.model.AttachCargoProjectActionKt;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.ide.notifications.RsEditorNotificationPanel;
import org.rust.ide.notifications.RsNotificationProvider;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\f\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0016J\"\u0010\u0011\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\"\u0010\u0012\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u0010\u001a\u00020\tH\u0002J4\u0010\u0013\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0001\u0010\u0015\u001a\u00020\bH\u0002R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/notifications/NoCargoProjectNotificationProvider;", "Lorg/rust/ide/notifications/RsNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disablingKey", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDisablingKey", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lorg/rust/ide/notifications/RsEditorNotificationPanel;", "file", "createNoCargoProjectsPanel", "createNoCargoProjectForFilePanel", "createAttachCargoProjectPanel", "debugId", "message", "Companion", "intellij.rustrover.core"})
public final class NoCargoProjectNotificationProvider
extends RsNotificationProvider
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NOTIFICATION_STATUS_KEY = "org.rust.hideNoCargoProjectNotifications";
    @NotNull
    public static final String NO_CARGO_PROJECTS = "NoCargoProjects";
    @NotNull
    public static final String FILE_NOT_IN_CARGO_PROJECT = "FileNotInCargoProject";

    public NoCargoProjectNotificationProvider(@NotNull Project project) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        MessageBusConnection $this$_init__u24lambda_u240 = messageBusConnection = project.getMessageBus().connect();
        boolean bl = false;
        $this$_init__u24lambda_u240.subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> NoCargoProjectNotificationProvider.lambda$0$0(this, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected String getDisablingKey(@NotNull VirtualFile $this$disablingKey) {
        Intrinsics.checkNotNullParameter((Object)$this$disablingKey, (String)"<this>");
        return NOTIFICATION_STATUS_KEY + $this$disablingKey.getPath();
    }

    @Nullable
    public Function<? super FileEditor, ? extends RsEditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (UtilsKt.isUnitTestMode() && !UtilsKt.isDispatchThread()) {
            return null;
        }
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        if (!RsFileKt.isRustFile(file) && !AttachCargoProjectActionKt.isCargoToml(file) || this.isNotificationDisabled(file)) {
            return null;
        }
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            return null;
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            return null;
        }
        CargoProjectsService cargoProjects = CargoProjectServiceKt.getCargoProjects(project);
        if (!cargoProjects.getInitialized()) {
            return null;
        }
        if (!cargoProjects.getHasAtLeastOneValidProject()) {
            return this.createNoCargoProjectsPanel(file);
        }
        VirtualFile targetCargoToml = UnlinkedProjectsUtils.INSTANCE.findTargetCargoToml(project, file);
        if (targetCargoToml != null && AttachCargoProjectAction.Companion.canBeAttached(project, targetCargoToml)) {
            return this.createNoCargoProjectForFilePanel(file);
        }
        return null;
    }

    private final Function<? super FileEditor, ? extends RsEditorNotificationPanel> createNoCargoProjectsPanel(VirtualFile file) {
        return this.createAttachCargoProjectPanel(NO_CARGO_PROJECTS, file, RsBundle.INSTANCE.message("notification.no.cargo.projects.found", new Object[0]));
    }

    private final Function<? super FileEditor, ? extends RsEditorNotificationPanel> createNoCargoProjectForFilePanel(VirtualFile file) {
        return this.createAttachCargoProjectPanel(FILE_NOT_IN_CARGO_PROJECT, file, RsBundle.INSTANCE.message("notification.file.not.belong.to.cargo.project", new Object[0]));
    }

    private final Function<? super FileEditor, ? extends RsEditorNotificationPanel> createAttachCargoProjectPanel(String debugId, VirtualFile file, @NlsContexts.LinkLabel String message) {
        return arg_0 -> NoCargoProjectNotificationProvider.createAttachCargoProjectPanel$lambda$0(debugId, message, this, file, arg_0);
    }

    private static final void lambda$0$0(NoCargoProjectNotificationProvider this$0, CargoProjectsService cargoProjectsService, Collection collection) {
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        this$0.updateAllNotifications();
    }

    private static final RsEditorNotificationPanel createAttachCargoProjectPanel$lambda$0(String $debugId, String $message, NoCargoProjectNotificationProvider this$0, VirtualFile $file, FileEditor it2) {
        RsEditorNotificationPanel rsEditorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        RsEditorNotificationPanel $this$createAttachCargoProjectPanel_u24lambda_u240_u240 = rsEditorNotificationPanel = new RsEditorNotificationPanel($debugId);
        boolean bl = false;
        $this$createAttachCargoProjectPanel_u24lambda_u240_u240.setText($message);
        $this$createAttachCargoProjectPanel_u24lambda_u240_u240.createActionLabel(RsBundle.INSTANCE.message("notification.action.attach.text", new Object[0]), "Cargo.AttachCargoProject");
        $this$createAttachCargoProjectPanel_u24lambda_u240_u240.createActionLabel(RsBundle.INSTANCE.message("notification.action.do.not.show.again.text", new Object[0]), () -> NoCargoProjectNotificationProvider.createAttachCargoProjectPanel$lambda$0$0$0(this$0, $file));
        return rsEditorNotificationPanel;
    }

    private static final void createAttachCargoProjectPanel$lambda$0$0$0(NoCargoProjectNotificationProvider this$0, VirtualFile $file) {
        this$0.disableNotification($file);
        this$0.updateAllNotifications();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/ide/notifications/NoCargoProjectNotificationProvider$Companion;", "", "<init>", "()V", "NOTIFICATION_STATUS_KEY", "", "NO_CARGO_PROJECTS", "FILE_NOT_IN_CARGO_PROJECT", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

