/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.notifications;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.AttachCargoProjectActionKt;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.settings.RsProjectSettingsServiceBase;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.StandardLibrary;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.ide.notifications.RsEditorNotificationPanel;
import org.rust.ide.notifications.RsNotificationProvider;
import org.rust.ide.notifications.UtilsKt;
import org.rust.lang.core.psi.RsFileKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\f\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/notifications/MissingToolchainNotificationProvider;", "Lorg/rust/ide/notifications/RsNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disablingKey", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDisablingKey", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lorg/rust/ide/notifications/RsEditorNotificationPanel;", "file", "createBadToolchainPanel", "createLibraryAttachingPanel", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "Companion", "intellij.rustrover.core"})
public final class MissingToolchainNotificationProvider
extends RsNotificationProvider
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NOTIFICATION_STATUS_KEY = "org.rust.hideToolchainNotifications";
    @NotNull
    public static final String NO_RUST_TOOLCHAIN = "NoRustToolchain";
    @NotNull
    public static final String NO_ATTACHED_STDLIB = "NoAttachedStdlib";

    public MissingToolchainNotificationProvider(@NotNull Project project) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        MessageBusConnection $this$_init__u24lambda_u240 = messageBusConnection = project.getMessageBus().connect();
        boolean bl = false;
        $this$_init__u24lambda_u240.subscribe(RsProjectSettingsServiceBase.Companion.getRUST_SETTINGS_TOPIC(), (Object)new RsProjectSettingsServiceBase.RsSettingsListener(this){
            final /* synthetic */ MissingToolchainNotificationProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public <T extends RsProjectSettingsServiceBase.RsProjectSettingsBase<T>> void settingsChanged(RsProjectSettingsServiceBase.SettingsChangedEventBase<T> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                this.this$0.updateAllNotifications();
            }
        });
        $this$_init__u24lambda_u240.subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> MissingToolchainNotificationProvider.lambda$0$0(this, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected String getDisablingKey(@NotNull VirtualFile $this$disablingKey) {
        Intrinsics.checkNotNullParameter((Object)$this$disablingKey, (String)"<this>");
        return NOTIFICATION_STATUS_KEY;
    }

    @Nullable
    public Function<? super FileEditor, ? extends RsEditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (org.rust.openapiext.UtilsKt.isUnitTestMode()) {
            return null;
        }
        if (!RsFileKt.isRustFile(file) && !AttachCargoProjectActionKt.isCargoToml(file) || this.isNotificationDisabled(file)) {
            return null;
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            return null;
        }
        if (CargoProjectServiceKt.guessAndSetupRustProject$default(project, false, false, 6, null)) {
            return null;
        }
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
        if (toolchain2 == null || !toolchain2.looksLikeValidToolchain()) {
            return arg_0 -> MissingToolchainNotificationProvider.collectNotificationData$lambda$0(this, file, arg_0);
        }
        CargoProjectsService cargoProjects = CargoProjectServiceKt.getCargoProjects(project);
        if (!cargoProjects.getInitialized()) {
            return null;
        }
        CargoProject cargoProject = cargoProjects.findProjectForFile(file);
        if (cargoProject == null) {
            return null;
        }
        CargoProject cargoProject2 = cargoProject;
        CargoWorkspace cargoWorkspace = cargoProject2.getWorkspace();
        if (cargoWorkspace == null) {
            return null;
        }
        CargoWorkspace workspace = cargoWorkspace;
        if (!workspace.getHasStandardLibrary() && !RustupKt.isRustupAvailable(toolchain2)) {
            return arg_0 -> MissingToolchainNotificationProvider.collectNotificationData$lambda$1(this, project, file, cargoProject2, arg_0);
        }
        return null;
    }

    private final RsEditorNotificationPanel createBadToolchainPanel(VirtualFile file) {
        RsEditorNotificationPanel rsEditorNotificationPanel;
        RsEditorNotificationPanel $this$createBadToolchainPanel_u24lambda_u240 = rsEditorNotificationPanel = new RsEditorNotificationPanel(NO_RUST_TOOLCHAIN);
        boolean bl = false;
        $this$createBadToolchainPanel_u24lambda_u240.setText(RsBundle.INSTANCE.message("notification.no.toolchain.configured", new Object[0]));
        $this$createBadToolchainPanel_u24lambda_u240.createActionLabel(RsBundle.INSTANCE.message("notification.action.set.up.toolchain.text", new Object[0]), () -> MissingToolchainNotificationProvider.createBadToolchainPanel$lambda$0$0(this));
        $this$createBadToolchainPanel_u24lambda_u240.createActionLabel(RsBundle.INSTANCE.message("notification.action.do.not.show.again.text", new Object[0]), () -> MissingToolchainNotificationProvider.createBadToolchainPanel$lambda$0$1(this, file));
        return rsEditorNotificationPanel;
    }

    private final RsEditorNotificationPanel createLibraryAttachingPanel(Project project, VirtualFile file, CargoProject cargoProject) {
        RsEditorNotificationPanel rsEditorNotificationPanel;
        RsEditorNotificationPanel $this$createLibraryAttachingPanel_u24lambda_u240 = rsEditorNotificationPanel = new RsEditorNotificationPanel(NO_ATTACHED_STDLIB);
        boolean bl = false;
        $this$createLibraryAttachingPanel_u24lambda_u240.setText(RsBundle.INSTANCE.message("notification.can.not.attach.stdlib.sources", new Object[0]));
        $this$createLibraryAttachingPanel_u24lambda_u240.createActionLabel(RsBundle.INSTANCE.message("notification.action.attach.manually.text", new Object[0]), () -> MissingToolchainNotificationProvider.createLibraryAttachingPanel$lambda$0$0($this$createLibraryAttachingPanel_u24lambda_u240, this, project, cargoProject));
        $this$createLibraryAttachingPanel_u24lambda_u240.createActionLabel(RsBundle.INSTANCE.message("notification.action.do.not.show.again.text", new Object[0]), () -> MissingToolchainNotificationProvider.createLibraryAttachingPanel$lambda$0$1(this, file));
        return rsEditorNotificationPanel;
    }

    private static final void lambda$0$0(MissingToolchainNotificationProvider this$0, CargoProjectsService cargoProjectsService, Collection collection) {
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        this$0.updateAllNotifications();
    }

    private static final RsEditorNotificationPanel collectNotificationData$lambda$0(MissingToolchainNotificationProvider this$0, VirtualFile $file, FileEditor it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.createBadToolchainPanel($file);
    }

    private static final RsEditorNotificationPanel collectNotificationData$lambda$1(MissingToolchainNotificationProvider this$0, Project $project, VirtualFile $file, CargoProject $cargoProject, FileEditor it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.createLibraryAttachingPanel($project, $file, $cargoProject);
    }

    private static final void createBadToolchainPanel$lambda$0$0(MissingToolchainNotificationProvider this$0) {
        RustProjectSettingsServiceKt.getRustSettings(this$0.getProject()).configureToolchain();
    }

    private static final void createBadToolchainPanel$lambda$0$1(MissingToolchainNotificationProvider this$0, VirtualFile $file) {
        this$0.disableNotification($file);
        this$0.updateAllNotifications();
    }

    private static final void createLibraryAttachingPanel$lambda$0$0(RsEditorNotificationPanel $this_apply, MissingToolchainNotificationProvider this$0, Project $project, CargoProject $cargoProject) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)((Component)((Object)$this_apply)), (Project)this$0.getProject(), null);
        if (virtualFile == null) {
            return;
        }
        VirtualFile stdlib = virtualFile;
        if (StandardLibrary.Companion.fromFile$default(StandardLibrary.Companion, $project, stdlib, $cargoProject.getRustcInfo(), $cargoProject.getRootDirPath(), null, false, null, 112, null) != null) {
            RustProjectSettingsServiceKt.getRustSettings(this$0.getProject()).modify(arg_0 -> MissingToolchainNotificationProvider.createLibraryAttachingPanel$lambda$0$0$0(stdlib, arg_0));
        } else {
            Project project = this$0.getProject();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)stdlib.getPresentableUrl(), (String)"getPresentableUrl(...)");
            UtilsKt.showBalloon$default(project, "invalid.rust.std.lib.source", RsBundle.INSTANCE.message("notification.invalid.stdlib.source.path", objectArray), NotificationType.ERROR, null, 8, null);
        }
        this$0.updateAllNotifications();
    }

    private static final Unit createLibraryAttachingPanel$lambda$0$0$0(VirtualFile $stdlib, RustProjectSettingsService.RustProjectSettings it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
        it2.setExplicitPathToStdlib($stdlib.getPath());
        return Unit.INSTANCE;
    }

    private static final void createLibraryAttachingPanel$lambda$0$1(MissingToolchainNotificationProvider this$0, VirtualFile $file) {
        this$0.disableNotification($file);
        this$0.updateAllNotifications();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/ide/notifications/MissingToolchainNotificationProvider$Companion;", "", "<init>", "()V", "NOTIFICATION_STATUS_KEY", "", "NO_RUST_TOOLCHAIN", "NO_ATTACHED_STDLIB", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

