/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.newProject;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rust/ide/newProject/RsPackageNameValidator;", "", "<init>", "()V", "KEYWORDS_BLACKLIST", "", "", "BINARY_BLACKLIST", "WINDOWS_BLACKLIST", "validate", "name", "isBinary", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsPackageNameValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPackageNameValidator.kt\norg/rust/ide/newProject/RsPackageNameValidator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,53:1\n1069#2,2:54\n*S KotlinDebug\n*F\n+ 1 RsPackageNameValidator.kt\norg/rust/ide/newProject/RsPackageNameValidator\n*L\n47#1:54,2\n*E\n"})
public final class RsPackageNameValidator {
    @NotNull
    public static final RsPackageNameValidator INSTANCE = new RsPackageNameValidator();
    @NotNull
    private static final Set<String> KEYWORDS_BLACKLIST;
    @NotNull
    private static final Set<String> BINARY_BLACKLIST;
    @NotNull
    private static final Set<String> WINDOWS_BLACKLIST;

    private RsPackageNameValidator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NlsContexts.DialogMessage
    @Nullable
    public final String validate(@NotNull String name2, boolean isBinary) {
        boolean bl;
        String string;
        block7: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (((CharSequence)name2).length() == 0) {
                string = RsBundle.INSTANCE.message("dialog.message.package.name.can.t.be.empty", new Object[0]);
                return string;
            }
            if (KEYWORDS_BLACKLIST.contains(name2) || Intrinsics.areEqual((Object)name2, (Object)"test")) {
                Object[] objectArray = new Object[]{name2};
                string = RsBundle.INSTANCE.message("dialog.message.name.cannot.be.used.as.crate.name2", objectArray);
                return string;
            }
            if (isBinary && BINARY_BLACKLIST.contains(name2)) {
                Object[] objectArray = new Object[]{name2};
                string = RsBundle.INSTANCE.message("dialog.message.name.cannot.be.used.as.crate.name", objectArray);
                return string;
            }
            if (Character.isDigit(name2.charAt(0))) {
                string = RsBundle.INSTANCE.message("dialog.message.package.names.starting.with.digit.cannot.be.used.as.crate.name", new Object[0]);
                return string;
            }
            CharSequence $this$all$iv = name2;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it2 = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (Character.isLetterOrDigit(it2) || it2 == '-' || it2 == '_') continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (!bl) {
            string = RsBundle.INSTANCE.message("dialog.message.package.names.should.contain.only.letters.digits", new Object[0]);
            return string;
        } else {
            if (!SystemInfo.isWindows) return null;
            String string2 = name2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!WINDOWS_BLACKLIST.contains(string2)) return null;
            Object[] objectArray = new Object[]{name2};
            string = RsBundle.INSTANCE.message("dialog.message.name.reserved.windows.filename", objectArray);
        }
        return string;
    }

    static {
        Object[] objectArray = new String[]{"Self", "abstract", "as", "async", "await", "become", "box", "break", "const", "continue", "crate", "do", "dyn", "else", "enum", "extern", "false", "final", "fn", "for", "if", "impl", "in", "let", "loop", "macro", "match", "mod", "move", "mut", "override", "priv", "pub", "ref", "return", "self", "static", "struct", "super", "trait", "true", "try", "type", "typeof", "unsafe", "unsized", "use", "virtual", "where", "while", "yield"};
        KEYWORDS_BLACKLIST = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"deps", "examples", "build", "incremental"};
        BINARY_BLACKLIST = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"con", "prn", "aux", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9"};
        WINDOWS_BLACKLIST = SetsKt.setOf((Object[])objectArray);
    }
}

