/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.navigation.goto;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"gotoSuperTargets", "", "Lcom/intellij/psi/NavigatablePsiElement;", "source", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
public final class RsGotoSuperHandlerKt {
    @VisibleForTesting
    @NotNull
    public static final List<NavigatablePsiElement> gotoSuperTargets(@NotNull PsiElement source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Class[] classArray = new Class[]{RsAbstractable.class, RsMod.class};
        RsElement item = (RsElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)source, (Class[])classArray);
        if (item instanceof RsAbstractable) {
            List<NavigatablePsiElement> list;
            if (RsAbstractableKt.getOwner((RsAbstractable)item).isTraitImpl()) {
                list = CollectionsKt.listOfNotNull((Object)RsAbstractableKt.getSuperItem((RsAbstractable)item));
            } else {
                PsiElement psiElement2 = ((RsAbstractable)item).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                list = RsGotoSuperHandlerKt.gotoSuperTargets(psiElement2);
            }
            return list;
        }
        if (item instanceof RsMod) {
            List list;
            if (item instanceof RsFile) {
                if (((RsFile)item).isCrateRoot()) {
                    PsiFile psiFile;
                    Object object = RsElementKt.getContainingCargoPackage(item);
                    if (object == null || (object = object.getContentRootPath()) == null || (object = object.resolve("Cargo.toml")) == null) {
                        return CollectionsKt.emptyList();
                    }
                    Object manifestPath = object;
                    VirtualFile virtualFile = ((RsFile)item).getVirtualFile();
                    if (virtualFile != null && (virtualFile = virtualFile.getFileSystem()) != null && (virtualFile = virtualFile.findFileByPath(manifestPath.toString())) != null) {
                        Project project = ((RsFile)item).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        psiFile = UtilsKt.toPsiFile(virtualFile, project);
                    } else {
                        psiFile = null;
                    }
                    list = CollectionsKt.listOfNotNull(psiFile);
                } else {
                    list = ((RsFile)item).getDeclarations();
                }
            } else {
                list = CollectionsKt.listOfNotNull((Object)((RsMod)item).getSuper());
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }
}

