/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.module;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.settings.ui.RustProjectSettingsPanel;
import org.rust.ide.module.RsModuleBuilder;
import org.rust.ide.newProject.ConfigurationData;
import org.rust.ide.newProject.ui.RsNewProjectPanel;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0018B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u000f*\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/module/CargoConfigurationWizardStep;", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "configurationUpdaterConsumer", "Lkotlin/Function1;", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder$ModuleConfigurationUpdater;", "", "<init>", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;)V", "newProjectPanel", "Lorg/rust/ide/newProject/ui/RsNewProjectPanel;", "getComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "updateDataModel", "validate", "", "withBorderIfNeeded", "T", "(Ljavax/swing/JComponent;)Ljavax/swing/JComponent;", "isNewWizard", "ConfigurationUpdater", "intellij.rustrover.core"})
public final class CargoConfigurationWizardStep
extends ModuleWizardStep {
    @NotNull
    private final WizardContext context;
    @Nullable
    private final Function1<ModuleBuilder.ModuleConfigurationUpdater, Unit> configurationUpdaterConsumer;
    @NotNull
    private final RsNewProjectPanel newProjectPanel;

    public CargoConfigurationWizardStep(@NotNull WizardContext context, @NotNull CoroutineScope cs, @Nullable Function1<? super ModuleBuilder.ModuleConfigurationUpdater, Unit> configurationUpdaterConsumer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.context = context;
        this.configurationUpdaterConsumer = configurationUpdaterConsumer;
        this.newProjectPanel = new RsNewProjectPanel(this.configurationUpdaterConsumer == null, null, cs, null, 10, null);
    }

    public /* synthetic */ CargoConfigurationWizardStep(WizardContext wizardContext, CoroutineScope coroutineScope, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(wizardContext, coroutineScope, (Function1<? super ModuleBuilder.ModuleConfigurationUpdater, Unit>)function1);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.withBorderIfNeeded((JComponent)BuilderKt.panel(arg_0 -> CargoConfigurationWizardStep.getComponent$lambda$0(this, arg_0)));
        DialogPanel it2 = (DialogPanel)jComponent;
        boolean bl = false;
        it2.addPropertyChangeListener(arg_0 -> CargoConfigurationWizardStep.getComponent$lambda$1$0(this, it2, arg_0));
        return jComponent;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.newProjectPanel);
    }

    public void updateDataModel() {
        block1: {
            block0: {
                ConfigurationData data2 = this.newProjectPanel.getData();
                ConfigurationUpdater.INSTANCE.setData(data2.getSettings());
                ProjectBuilder projectBuilder = this.context.getProjectBuilder();
                if (!(projectBuilder instanceof RsModuleBuilder)) break block0;
                ((RsModuleBuilder)projectBuilder).setConfigurationData(data2);
                ((RsModuleBuilder)projectBuilder).addModuleConfigurationUpdater(ConfigurationUpdater.INSTANCE);
                break block1;
            }
            Function1<ModuleBuilder.ModuleConfigurationUpdater, Unit> function1 = this.configurationUpdaterConsumer;
            if (function1 == null) break block1;
            function1.invoke((Object)ConfigurationUpdater.INSTANCE);
        }
    }

    public boolean validate() throws ConfigurationException {
        this.newProjectPanel.validateSettings();
        return true;
    }

    private final <T extends JComponent> T withBorderIfNeeded(T $this$withBorderIfNeeded) {
        if (this.isNewWizard()) {
            $this$withBorderIfNeeded.setBorder((Border)JBUI.Borders.empty((int)14, (int)20));
        }
        return $this$withBorderIfNeeded;
    }

    private final boolean isNewWizard() {
        return UtilsKt.isFeatureEnabled("new.project.wizard");
    }

    private static final Unit getComponent$lambda$0(CargoConfigurationWizardStep this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.newProjectPanel.attachTo($this$panel);
        return Unit.INSTANCE;
    }

    private static final void getComponent$lambda$1$0(CargoConfigurationWizardStep this$0, DialogPanel $it, PropertyChangeEvent event) {
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"ancestor")) {
            RsNewProjectPanel rsNewProjectPanel = this$0.newProjectPanel;
            ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)$it));
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            rsNewProjectPanel.start(modalityState);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/module/CargoConfigurationWizardStep$ConfigurationUpdater;", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder$ModuleConfigurationUpdater;", "<init>", "()V", "data", "Lorg/rust/cargo/project/settings/ui/RustProjectSettingsPanel$Data;", "getData", "()Lorg/rust/cargo/project/settings/ui/RustProjectSettingsPanel$Data;", "setData", "(Lorg/rust/cargo/project/settings/ui/RustProjectSettingsPanel$Data;)V", "update", "", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "intellij.rustrover.core"})
    private static final class ConfigurationUpdater
    extends ModuleBuilder.ModuleConfigurationUpdater {
        @NotNull
        public static final ConfigurationUpdater INSTANCE = new ConfigurationUpdater();
        @Nullable
        private static RustProjectSettingsPanel.Data data;

        private ConfigurationUpdater() {
        }

        @Nullable
        public final RustProjectSettingsPanel.Data getData() {
            return data;
        }

        public final void setData(@Nullable RustProjectSettingsPanel.Data data2) {
            data = data2;
        }

        public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
            RustProjectSettingsPanel.Data data2 = data;
            if (data2 != null) {
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RustProjectSettingsServiceKt.getRustSettings(project).modify(arg_0 -> ConfigurationUpdater.update$lambda$0(data2, arg_0));
            }
            rootModel.inheritSdk();
            ContentEntry[] contentEntryArray = rootModel.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
            ContentEntry contentEntry = (ContentEntry)ArraysKt.singleOrNull((Object[])contentEntryArray);
            if (contentEntry != null) {
                VirtualFile manifest;
                VirtualFile virtualFile = contentEntry.getFile();
                Object object = manifest = virtualFile != null ? virtualFile.findChild("Cargo.toml") : null;
                if (manifest != null) {
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    CargoProjectServiceKt.getCargoProjects(project).attachCargoProject(UtilsKt.getPathAsPath(manifest));
                }
                VirtualFile virtualFile2 = contentEntry.getFile();
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile projectRoot = virtualFile2;
                CargoProjectServiceKt.setup(contentEntry, projectRoot);
            }
        }

        private static final Unit update$lambda$0(RustProjectSettingsPanel.Data $data, RustProjectSettingsService.RustProjectSettings it2) {
            Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
            it2.setToolchain($data.getToolchain());
            it2.setExplicitPathToStdlib($data.getExplicitPathToStdlib());
            it2.setEnvs(MapsKt.toMutableMap($data.getEnvs()));
            return Unit.INSTANCE;
        }
    }
}

