/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.lineMarkers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.icons.RsIcons;
import org.rust.ide.lineMarkers.RsLineMarkerInfoUtils;
import org.rust.ide.lineMarkers.RustcTargetLineMarkerProviderKt;
import org.rust.ide.statistics.RsCfgSwitcherUsageCollector;
import org.rust.ide.utils.RsResolveContextPopup;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00050\rH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/lineMarkers/RustcTargetLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "<init>", "()V", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "OpenSettingsAction", "Helper", "intellij.rustrover.core"})
public final class RustcTargetLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiElement psiElement2 = (PsiElement)CollectionsKt.firstOrNull(elements2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement firstElement = psiElement2;
        if (!(firstElement.getContainingFile() instanceof RsFile)) {
            return;
        }
        boolean shouldReportEvent = false;
        for (PsiElement psiElement3 : elements2) {
            RsOuterAttr attr;
            if (!Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(psiElement3), (Object)RsElementTypes.SHA)) continue;
            PsiElement psiElement32 = psiElement3.getParent();
            RsOuterAttr rsOuterAttr = psiElement32 instanceof RsOuterAttr ? (RsOuterAttr)psiElement32 : null;
            if (rsOuterAttr == null || !Helper.INSTANCE.hasTargetSpecificOption(attr = rsOuterAttr)) continue;
            if (!Intrinsics.areEqual((Object)psiElement3.getUserData(RustcTargetLineMarkerProviderKt.access$getLINE_MARKER_CREATED_EVENT_LOGGED_KEY$p()), (Object)true)) {
                psiElement3.putUserData(RustcTargetLineMarkerProviderKt.access$getLINE_MARKER_CREATED_EVENT_LOGGED_KEY$p(), (Object)true);
                shouldReportEvent = true;
            }
            Collection<LineMarkerInfo<?>> collection = result2;
            TextRange textRange = psiElement3.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            collection.add(RsLineMarkerInfoUtils.INSTANCE.create(psiElement3, textRange, RsIcons.INSTANCE.getRUSTC_TARGET_SETTINGS(), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)OpenSettingsAction.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)RustcTargetLineMarkerProvider::collectSlowLineMarkers$lambda$0)));
        }
        if (shouldReportEvent) {
            Project project = firstElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsCfgSwitcherUsageCollector.INSTANCE.logResolveContextLineMarkerCreated(project);
        }
    }

    private static final String collectSlowLineMarkers$lambda$0() {
        return RsBundle.INSTANCE.message("resolve.contexts.linemarker.tooltip", new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/lineMarkers/RustcTargetLineMarkerProvider$Helper;", "", "<init>", "()V", "hasTargetSpecificOption", "", "attr", "Lorg/rust/lang/core/psi/RsOuterAttr;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRustcTargetLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RustcTargetLineMarkerProvider.kt\norg/rust/ide/lineMarkers/RustcTargetLineMarkerProvider$Helper\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n127#2:106\n1761#3,3:107\n*S KotlinDebug\n*F\n+ 1 RustcTargetLineMarkerProvider.kt\norg/rust/ide/lineMarkers/RustcTargetLineMarkerProvider$Helper\n*L\n84#1:106\n84#1:107,3\n*E\n"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean hasTargetSpecificOption(@NotNull RsOuterAttr attr) {
            boolean bl;
            block5: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
                RsMetaItem rsMetaItem = attr.getMetaItem();
                Intrinsics.checkNotNullExpressionValue((Object)rsMetaItem, (String)"<get-metaItem>(...)");
                RsMetaItem rootMetaItem = rsMetaItem;
                RsPath rsPath = rootMetaItem.getPath();
                if (rsPath == null) {
                    return false;
                }
                RsPath rootMetaItemPath = rsPath;
                if (!Intrinsics.areEqual((Object)rootMetaItemPath.getReferenceName(), (Object)"cfg") || rootMetaItemPath.getHasColonColon()) {
                    return false;
                }
                Object $this$descendantsOfType$iv = rootMetaItem;
                boolean $i$f$descendantsOfType = false;
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsMetaItem.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                $this$descendantsOfType$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RsMetaItem it2 = (RsMetaItem)element$iv;
                        boolean bl2 = false;
                        RsPath rsPath2 = it2.getPath();
                        if (!CollectionsKt.contains((Iterable)RustcTargetLineMarkerProviderKt.access$getTARGET_SPECIFIC_OPTIONS$p(), (Object)(rsPath2 != null ? rsPath2.getReferenceName() : null))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/lineMarkers/RustcTargetLineMarkerProvider$OpenSettingsAction;", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "navigate", "", "e", "Ljava/awt/event/MouseEvent;", "element", "createActionGroupPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rustrover.core"})
    private static final class OpenSettingsAction
    implements GutterIconNavigationHandler<PsiElement> {
        @NotNull
        public static final OpenSettingsAction INSTANCE = new OpenSettingsAction();

        private OpenSettingsAction() {
        }

        public void navigate(@NotNull MouseEvent e, @NotNull PsiElement element) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                RsCfgSwitcherUsageCollector.INSTANCE.logResolveContextLineMarkerClicked(project2);
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                VirtualFile file = virtualFile;
                DataContext dataContext = DataManager.getInstance().getDataContext(e.getComponent());
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext dataContext2 = dataContext;
                JBPopup jBPopup = this.createActionGroupPopup(project2, file, dataContext2);
                if (jBPopup == null) break block1;
                jBPopup.show(new RelativePoint(e));
            }
        }

        private final JBPopup createActionGroupPopup(Project project, VirtualFile file, DataContext dataContext) {
            return (JBPopup)RsResolveContextPopup.INSTANCE.createPopup(project, file, dataContext);
        }
    }
}

