/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions.util.macros;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EmptySoftWrapModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.intentions.util.macros.IntentionInsideMacroExpansionEditorUnsupportedOperationException;
import org.rust.ide.intentions.util.macros.RsIntentionInsideMacroExpansionContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\bH\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lorg/rust/ide/intentions/util/macros/RsIntentionInsideMacroExpansionEditor;", "Lcom/intellij/openapi/editor/impl/ImaginaryEditor;", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "originalFile", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "initialMappedOffset", "", "context", "Lorg/rust/ide/intentions/util/macros/RsIntentionInsideMacroExpansionContext;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;Lorg/rust/ide/intentions/util/macros/RsIntentionInsideMacroExpansionContext;)V", "getPsiFileCopy", "()Lcom/intellij/psi/PsiFile;", "getOriginalFile", "getOriginalEditor", "()Lcom/intellij/openapi/editor/Editor;", "getInitialMappedOffset", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getContext", "()Lorg/rust/ide/intentions/util/macros/RsIntentionInsideMacroExpansionContext;", "notImplemented", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "isViewer", "", "isOneLineMode", "getSettings", "Lcom/intellij/openapi/editor/EditorSettings;", "logicalPositionToOffset", "pos", "Lcom/intellij/openapi/editor/LogicalPosition;", "logicalToVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "logicalPos", "visualToLogicalPosition", "visiblePos", "offsetToLogicalPosition", "offset", "getSoftWrapModel", "Lcom/intellij/openapi/editor/SoftWrapModel;", "intellij.rustrover.core"})
public final class RsIntentionInsideMacroExpansionEditor
extends ImaginaryEditor {
    @NotNull
    private final PsiFile psiFileCopy;
    @NotNull
    private final PsiFile originalFile;
    @NotNull
    private final Editor originalEditor;
    @Nullable
    private final Integer initialMappedOffset;
    @Nullable
    private final RsIntentionInsideMacroExpansionContext context;

    public RsIntentionInsideMacroExpansionEditor(@NotNull PsiFile psiFileCopy, @NotNull PsiFile originalFile, @NotNull Editor originalEditor, @Nullable Integer initialMappedOffset, @Nullable RsIntentionInsideMacroExpansionContext context) {
        Intrinsics.checkNotNullParameter((Object)psiFileCopy, (String)"psiFileCopy");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
        Project project = psiFileCopy.getProject();
        Document document = psiFileCopy.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        super(project, document);
        this.psiFileCopy = psiFileCopy;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
        this.initialMappedOffset = initialMappedOffset;
        this.context = context;
        if (this.initialMappedOffset != null) {
            this.getCaretModel().moveToOffset(this.initialMappedOffset.intValue());
        }
    }

    @NotNull
    public final PsiFile getPsiFileCopy() {
        return this.psiFileCopy;
    }

    @NotNull
    public final PsiFile getOriginalFile() {
        return this.originalFile;
    }

    @NotNull
    public final Editor getOriginalEditor() {
        return this.originalEditor;
    }

    @Nullable
    public final Integer getInitialMappedOffset() {
        return this.initialMappedOffset;
    }

    @Nullable
    public final RsIntentionInsideMacroExpansionContext getContext() {
        return this.context;
    }

    @NotNull
    protected RuntimeException notImplemented() {
        return new IntentionInsideMacroExpansionEditorUnsupportedOperationException();
    }

    public boolean isViewer() {
        return true;
    }

    public boolean isOneLineMode() {
        return false;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorSettings editorSettings = this.originalEditor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        return editorSettings;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineStart = document2.getLineStartOffset(pos.line);
        int lineEnd = document2.getLineEndOffset(pos.line);
        return Math.min(lineEnd, lineStart + pos.column);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        Intrinsics.checkNotNullParameter((Object)logicalPos, (String)"logicalPos");
        return new VisualPosition(logicalPos.line, logicalPos.column);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        Intrinsics.checkNotNullParameter((Object)visiblePos, (String)"visiblePos");
        return new LogicalPosition(visiblePos.line, visiblePos.column);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int clamped = RangesKt.coerceIn((int)offset, (int)0, (int)this.getDocument().getTextLength());
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int line = document2.getLineNumber(clamped);
        int col = clamped - document2.getLineStartOffset(line);
        return new LogicalPosition(line, col);
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        return (SoftWrapModel)new EmptySoftWrapModel();
    }
}

