/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions.addFmtStringArgument;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.intentions.addFmtStringArgument.RsAddFmtStringArgumentEditorTextField;
import org.rust.ide.intentions.addFmtStringArgument.RsAddFmtStringArgumentPopup;
import org.rust.ide.intentions.util.macros.IntentionInMacroUtil;
import org.rust.lang.core.psi.RsCodeFragment;
import org.rust.openapiext.RsPluginDisposable;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/intentions/addFmtStringArgument/RsAddFmtStringArgumentPopup;", "", "<init>", "()V", "show", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "codeFragment", "Lorg/rust/lang/core/psi/RsCodeFragment;", "onComplete", "Lkotlin/Function0;", "createEditorTextField", "Lcom/intellij/ui/EditorTextField;", "showBalloon", "parent", "Lcom/intellij/openapi/Disposable;", "editorTextField", "intellij.rustrover.core"})
public final class RsAddFmtStringArgumentPopup {
    @NotNull
    public static final RsAddFmtStringArgumentPopup INSTANCE = new RsAddFmtStringArgumentPopup();

    private RsAddFmtStringArgumentPopup() {
    }

    public final void show(@NotNull Editor editor2, @NotNull Project project, @NotNull RsCodeFragment codeFragment, @NotNull Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        EditorTextField editorTextField = this.createEditorTextField(project, codeFragment);
        if (editorTextField == null) {
            return;
        }
        EditorTextField editorTextField2 = editorTextField;
        this.showBalloon(editor2, RsPluginDisposable.Companion.getInstance(project), editorTextField2, onComplete);
    }

    private final EditorTextField createEditorTextField(Project project, RsCodeFragment codeFragment) {
        PsiFile psiFile = codeFragment.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Document document = UtilsKt.getDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        RsAddFmtStringArgumentEditorTextField editorTextField = new RsAddFmtStringArgumentEditorTextField(project, document2);
        editorTextField.setFontInheritedFromLAF(false);
        editorTextField.setFont(EditorUtil.getEditorFont());
        return editorTextField;
    }

    private final void showBalloon(Editor editor2, Disposable parent2, EditorTextField editorTextField, Function0<Unit> onComplete) {
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)editorTextField).setShadow(true).setAnimationCycle(0).setHideOnAction(false).setHideOnKeyOutside(false).setFillColor(UIUtil.getPanelBackground()).setBorderInsets((Insets)JBUI.insets((int)3)).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        Disposer.register((Disposable)parent2, (Disposable)((Disposable)balloon2));
        KeyAdapter keyListener2 = new KeyAdapter(balloon2, onComplete){
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ Function0<Unit> $onComplete;
            {
                this.$balloon = $balloon;
                this.$onComplete = $onComplete;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 10: {
                        this.$balloon.hide();
                        this.$onComplete.invoke();
                        break;
                    }
                    case 27: {
                        this.$balloon.hide();
                    }
                }
            }
        };
        editorTextField.addKeyListener((KeyListener)keyListener2);
        FontMetrics fontMetrics = editorTextField.getFontMetrics(editorTextField.getFont());
        int minimalWidth = fontMetrics.stringWidth("1234");
        editorTextField.setPreferredWidth(minimalWidth);
        DocumentListener documentListener2 = new DocumentListener(fontMetrics, editorTextField, minimalWidth, balloon2){
            final /* synthetic */ FontMetrics $fontMetrics;
            final /* synthetic */ EditorTextField $editorTextField;
            final /* synthetic */ int $minimalWidth;
            final /* synthetic */ Balloon $balloon;
            {
                this.$fontMetrics = $fontMetrics;
                this.$editorTextField = $editorTextField;
                this.$minimalWidth = $minimalWidth;
                this.$balloon = $balloon;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int textWidth = this.$fontMetrics.stringWidth(this.$editorTextField.getText());
                this.$editorTextField.setPreferredWidth(this.$minimalWidth + textWidth);
                this.$balloon.revalidate();
            }
        };
        editorTextField.addDocumentListener(documentListener2);
        balloon2.addListener(new JBPopupListener(editorTextField, keyListener2, documentListener2){
            final /* synthetic */ EditorTextField $editorTextField;
            final /* synthetic */ showBalloon.keyListener.1 $keyListener;
            final /* synthetic */ showBalloon.documentListener.1 $documentListener;
            {
                this.$editorTextField = $editorTextField;
                this.$keyListener = $keyListener;
                this.$documentListener = $documentListener;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$editorTextField.removeKeyListener((KeyListener)this.$keyListener);
                this.$editorTextField.removeDocumentListener((DocumentListener)this.$documentListener);
            }
        });
        Editor realEditor = IntentionInMacroUtil.INSTANCE.unwrapEditor(editor2);
        Balloon.Position position = QuickEditAction.getBalloonPosition((Editor)realEditor);
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(realEditor);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        RelativePoint point = relativePoint;
        if (position == Balloon.Position.above) {
            Point p = point.getPoint();
            point = new RelativePoint(point.getComponent(), new Point(p.x, p.y - realEditor.getLineHeight()));
        }
        balloon2.show(point, position);
        editorTextField.requestFocus();
    }
}

