/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/intentions/WrapLambdaExprIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/lang/core/psi/RsExpr;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nWrapLambdaExprIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrapLambdaExprIntention.kt\norg/rust/ide/intentions/WrapLambdaExprIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,48:1\n9#2:49\n*S KotlinDebug\n*F\n+ 1 WrapLambdaExprIntention.kt\norg/rust/ide/intentions/WrapLambdaExprIntention\n*L\n29#1:49\n*E\n"})
public final class WrapLambdaExprIntention
extends RsElementBaseIntentionAction<RsExpr> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.add.braces.to.lambda.expression", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public RsExpr findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsLambdaExpr rsLambdaExpr = (RsLambdaExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsLambdaExpr.class, (boolean)true);
        if (rsLambdaExpr == null) {
            return null;
        }
        RsLambdaExpr lambdaExpr = rsLambdaExpr;
        RsExpr rsExpr = lambdaExpr.getExpr();
        if (rsExpr == null) {
            return null;
        }
        RsExpr body = rsExpr;
        if (body instanceof RsBlockExpr) {
            return null;
        }
        if (!PsiModificationUtil.INSTANCE.canReplace(body)) {
            return null;
        }
        return body;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull RsExpr ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int relativeCaretPosition = editor2.getCaretModel().getOffset() - ctx.getTextOffset();
        String bodyStr = "\n" + ctx.getText() + "\n";
        RsBlockExpr blockExpr = new RsPsiFactory(project, false, false, 6, null).createBlockExpr(bodyStr);
        PsiElement psiElement2 = ctx.replace(blockExpr);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsBlockExpr");
        RsBlockExpr insertedBlock = (RsBlockExpr)psiElement2;
        RsBlock rsBlock = insertedBlock.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)rsBlock, (String)"<get-block>(...)");
        RsExprStmt rsExprStmt = RsBlockKt.getSyntaxTailStmt(rsBlock);
        if (rsExprStmt == null) {
            return;
        }
        int offset = rsExprStmt.getTextOffset();
        EditorKt.moveCaretToOffset(editor2, insertedBlock, offset + relativeCaretPosition);
    }
}

