/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.ext.RsBlockExprKt;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsStmtKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTuple;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/intentions/UnwrapSingleExprIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/UnwrapSingleExprIntention$Context;", "<init>", "()V", "getFamilyName", "", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUnwrapSingleExprIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnwrapSingleExprIntention.kt\norg/rust/ide/intentions/UnwrapSingleExprIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,71:1\n9#2:72\n*S KotlinDebug\n*F\n+ 1 UnwrapSingleExprIntention.kt\norg/rust/ide/intentions/UnwrapSingleExprIntention\n*L\n34#1:72\n*E\n"})
public final class UnwrapSingleExprIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.name.remove.braces.from.single.expression", new Object[0]);
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Context context;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsBlockExpr rsBlockExpr = (RsBlockExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsBlockExpr.class, (boolean)true);
        if (rsBlockExpr == null) {
            return null;
        }
        RsBlockExpr blockExpr = rsBlockExpr;
        if (RsBlockExprKt.getHasAnyModifier(blockExpr)) {
            return null;
        }
        PsiElement parent2 = blockExpr.getParent();
        if (parent2 instanceof RsElseBranch || parent2 instanceof RsIfExpr) {
            return null;
        }
        RsBlock rsBlock = blockExpr.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)rsBlock, (String)"<get-block>(...)");
        RsBlock block = rsBlock;
        RsStmt rsStmt = RsBlockKt.singleStmt(block);
        RsExprStmt rsExprStmt = rsStmt instanceof RsExprStmt ? (RsExprStmt)rsStmt : null;
        if (rsExprStmt == null) {
            return null;
        }
        RsExprStmt singleStatement = rsExprStmt;
        if (!PsiModificationUtil.INSTANCE.canReplace(blockExpr)) {
            return null;
        }
        RsExpr rsExpr = singleStatement.getExpr();
        Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
        Ty type = ExtensionsKt.getType(rsExpr);
        if (RsStmtKt.isTailStmt(singleStatement)) {
            this.setText(RsBundle.INSTANCE.message("intention.name.remove.braces.from.single.expression", new Object[0]));
            RsExpr rsExpr2 = singleStatement.getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"getExpr(...)");
            context = new Context(blockExpr, rsExpr2);
        } else if (type instanceof TyTuple && ((TyTuple)type).getTypes().isEmpty()) {
            this.setText(RsBundle.INSTANCE.message("intention.name.remove.braces.from.single.expression.statement", new Object[0]));
            RsExpr rsExpr3 = singleStatement.getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr3, (String)"getExpr(...)");
            context = new Context(blockExpr, rsExpr3);
        } else {
            context = null;
        }
        return context;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PsiElement parent2 = ctx.getBlockExpr().getParent();
        if (parent2 instanceof RsMatchArm && ((RsMatchArm)parent2).getComma() == null) {
            ((RsMatchArm)parent2).add(new RsPsiFactory(project, false, false, 6, null).createComma());
        }
        RsExpr element = ctx.getExpr();
        int relativeCaretPosition = Math.min(Math.max(editor2.getCaretModel().getOffset() - element.getTextOffset(), 0), element.getTextLength());
        PsiElement psiElement2 = ctx.getBlockExpr().replace(element);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsExpr");
        RsExpr insertedElement = (RsExpr)psiElement2;
        EditorKt.moveCaretToOffset(editor2, insertedElement, insertedElement.getTextOffset() + relativeCaretPosition);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/intentions/UnwrapSingleExprIntention$Context;", "", "blockExpr", "Lorg/rust/lang/core/psi/RsBlockExpr;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "<init>", "(Lorg/rust/lang/core/psi/RsBlockExpr;Lorg/rust/lang/core/psi/RsExpr;)V", "getBlockExpr", "()Lorg/rust/lang/core/psi/RsBlockExpr;", "getExpr", "()Lorg/rust/lang/core/psi/RsExpr;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsBlockExpr blockExpr;
        @NotNull
        private final RsExpr expr;

        public Context(@NotNull RsBlockExpr blockExpr, @NotNull RsExpr expr) {
            Intrinsics.checkNotNullParameter((Object)blockExpr, (String)"blockExpr");
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            this.blockExpr = blockExpr;
            this.expr = expr;
        }

        @NotNull
        public final RsBlockExpr getBlockExpr() {
            return this.blockExpr;
        }

        @NotNull
        public final RsExpr getExpr() {
            return this.expr;
        }

        @NotNull
        public final RsBlockExpr component1() {
            return this.blockExpr;
        }

        @NotNull
        public final RsExpr component2() {
            return this.expr;
        }

        @NotNull
        public final Context copy(@NotNull RsBlockExpr blockExpr, @NotNull RsExpr expr) {
            Intrinsics.checkNotNullParameter((Object)blockExpr, (String)"blockExpr");
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return new Context(blockExpr, expr);
        }

        public static /* synthetic */ Context copy$default(Context context, RsBlockExpr rsBlockExpr, RsExpr rsExpr, int n, Object object) {
            if ((n & 1) != 0) {
                rsBlockExpr = context.blockExpr;
            }
            if ((n & 2) != 0) {
                rsExpr = context.expr;
            }
            return context.copy(rsBlockExpr, rsExpr);
        }

        @NotNull
        public String toString() {
            return "Context(blockExpr=" + this.blockExpr + ", expr=" + this.expr + ")";
        }

        public int hashCode() {
            int result2 = this.blockExpr.hashCode();
            result2 = result2 * 31 + this.expr.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.blockExpr, (Object)context.blockExpr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expr, (Object)context.expr);
        }
    }
}

