/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.SplitIfIntentionKt;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.ExprUtilsKt;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsBinaryOp;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsLetExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.BinaryOperator;
import org.rust.lang.core.psi.ext.LogicOp;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsIfExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/intentions/SplitIfIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/SplitIfIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nSplitIfIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitIfIntention.kt\norg/rust/ide/intentions/SplitIfIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,78:1\n9#2:79\n15#2:81\n124#3:80\n*S KotlinDebug\n*F\n+ 1 SplitIfIntention.kt\norg/rust/ide/intentions/SplitIfIntention\n*L\n33#1:79\n41#1:81\n39#1:80\n*E\n"})
public final class SplitIfIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.split.into.if.s", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.split.if", new Object[0]);
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        RsLetExpr rsLetExpr;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsBinaryExpr rsBinaryExpr = (RsBinaryExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsBinaryExpr.class, (boolean)true);
        if (rsBinaryExpr == null) {
            return null;
        }
        RsBinaryExpr binExpr = rsBinaryExpr;
        if (!(RsExprKt.getOperatorType(binExpr) instanceof LogicOp)) {
            return null;
        }
        RsBinaryOp rsBinaryOp = binExpr.getBinaryOp();
        Intrinsics.checkNotNullExpressionValue((Object)rsBinaryOp, (String)"getBinaryOp(...)");
        RsBinaryOp binaryOp = rsBinaryOp;
        BinaryOperator binaryOperator = RsExprKt.getOperatorType(binaryOp);
        LogicOp logicOp = binaryOperator instanceof LogicOp ? (LogicOp)binaryOperator : null;
        if (logicOp == null) {
            return null;
        }
        LogicOp operatorType = logicOp;
        if (!Intrinsics.areEqual((Object)element.getParent(), (Object)binaryOp)) {
            return null;
        }
        RsCondition rsCondition = SplitIfIntentionKt.access$findCondition(binExpr);
        if (rsCondition == null) {
            return null;
        }
        RsCondition condition = rsCondition;
        RsExpr rsExpr = condition.getExpr();
        if (rsExpr != null) {
            PsiElement $this$descendantOfTypeOrSelf$iv = rsExpr;
            boolean $i$f$descendantOfTypeOrSelf = false;
            rsLetExpr = (RsLetExpr)PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeOrSelf$iv, RsLetExpr.class, (boolean)false);
        } else {
            rsLetExpr = null;
        }
        if (rsLetExpr != null) {
            return null;
        }
        RsExpr rsExpr2 = ExprUtilsKt.skipParenExprDown(condition);
        if (rsExpr2 == null) {
            return null;
        }
        RsExpr conditionExpr = rsExpr2;
        PsiElement $this$ancestorOrSelf$iv = condition;
        boolean $i$f$ancestorOrSelf = false;
        RsIfExpr rsIfExpr = (RsIfExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsIfExpr.class, (boolean)false);
        if (rsIfExpr == null) {
            return null;
        }
        RsIfExpr ifStatement = rsIfExpr;
        if (!PsiModificationUtil.INSTANCE.canReplace(ifStatement)) {
            return null;
        }
        return new Context(binaryOp, operatorType, conditionExpr, ifStatement);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        String string;
        Object object;
        Object thenBranch;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsBinaryOp binaryOp = ctx.component1();
        LogicOp operatorType = ctx.component2();
        RsExpr conditionExpr = ctx.component3();
        RsIfExpr ifStatement = ctx.component4();
        Object object2 = RsIfExprKt.getBlock(ifStatement);
        if (object2 == null || (object2 = object2.getText()) == null) {
            object2 = thenBranch = "{ }";
        }
        if ((object = ifStatement.getElseBranch()) == null || (object = object.getText()) == null) {
            object = "";
        }
        Object elseBranch = object;
        String leftCondition = SplitIfIntentionKt.access$leftPart(conditionExpr, binaryOp);
        String rightCondition = SplitIfIntentionKt.access$rightPart(conditionExpr, binaryOp);
        LogicOp logicOp = operatorType;
        if (Intrinsics.areEqual((Object)logicOp, (Object)LogicOp.AND.INSTANCE)) {
            string = SplitIfIntentionKt.access$createAndAnd(leftCondition, rightCondition, (String)thenBranch, (String)elseBranch);
        } else if (Intrinsics.areEqual((Object)logicOp, (Object)LogicOp.OR.INSTANCE)) {
            string = SplitIfIntentionKt.access$createOrOr(leftCondition, rightCondition, (String)thenBranch, (String)elseBranch);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String generatedCode = string;
        RsExpr rsExpr = new RsPsiFactory(project, false, false, 6, null).createExpression(generatedCode);
        Intrinsics.checkNotNull((Object)rsExpr, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsIfExpr");
        RsIfExpr newIfStatement = (RsIfExpr)rsExpr;
        ifStatement.replace(newIfStatement);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/rust/ide/intentions/SplitIfIntention$Context;", "", "binaryOp", "Lorg/rust/lang/core/psi/RsBinaryOp;", "operatorType", "Lorg/rust/lang/core/psi/ext/LogicOp;", "conditionExpr", "Lorg/rust/lang/core/psi/RsExpr;", "ifExpr", "Lorg/rust/lang/core/psi/RsIfExpr;", "<init>", "(Lorg/rust/lang/core/psi/RsBinaryOp;Lorg/rust/lang/core/psi/ext/LogicOp;Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/lang/core/psi/RsIfExpr;)V", "getBinaryOp", "()Lorg/rust/lang/core/psi/RsBinaryOp;", "getOperatorType", "()Lorg/rust/lang/core/psi/ext/LogicOp;", "getConditionExpr", "()Lorg/rust/lang/core/psi/RsExpr;", "getIfExpr", "()Lorg/rust/lang/core/psi/RsIfExpr;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsBinaryOp binaryOp;
        @NotNull
        private final LogicOp operatorType;
        @NotNull
        private final RsExpr conditionExpr;
        @NotNull
        private final RsIfExpr ifExpr;

        public Context(@NotNull RsBinaryOp binaryOp, @NotNull LogicOp operatorType, @NotNull RsExpr conditionExpr, @NotNull RsIfExpr ifExpr) {
            Intrinsics.checkNotNullParameter((Object)binaryOp, (String)"binaryOp");
            Intrinsics.checkNotNullParameter((Object)operatorType, (String)"operatorType");
            Intrinsics.checkNotNullParameter((Object)conditionExpr, (String)"conditionExpr");
            Intrinsics.checkNotNullParameter((Object)ifExpr, (String)"ifExpr");
            this.binaryOp = binaryOp;
            this.operatorType = operatorType;
            this.conditionExpr = conditionExpr;
            this.ifExpr = ifExpr;
        }

        @NotNull
        public final RsBinaryOp getBinaryOp() {
            return this.binaryOp;
        }

        @NotNull
        public final LogicOp getOperatorType() {
            return this.operatorType;
        }

        @NotNull
        public final RsExpr getConditionExpr() {
            return this.conditionExpr;
        }

        @NotNull
        public final RsIfExpr getIfExpr() {
            return this.ifExpr;
        }

        @NotNull
        public final RsBinaryOp component1() {
            return this.binaryOp;
        }

        @NotNull
        public final LogicOp component2() {
            return this.operatorType;
        }

        @NotNull
        public final RsExpr component3() {
            return this.conditionExpr;
        }

        @NotNull
        public final RsIfExpr component4() {
            return this.ifExpr;
        }

        @NotNull
        public final Context copy(@NotNull RsBinaryOp binaryOp, @NotNull LogicOp operatorType, @NotNull RsExpr conditionExpr, @NotNull RsIfExpr ifExpr) {
            Intrinsics.checkNotNullParameter((Object)binaryOp, (String)"binaryOp");
            Intrinsics.checkNotNullParameter((Object)operatorType, (String)"operatorType");
            Intrinsics.checkNotNullParameter((Object)conditionExpr, (String)"conditionExpr");
            Intrinsics.checkNotNullParameter((Object)ifExpr, (String)"ifExpr");
            return new Context(binaryOp, operatorType, conditionExpr, ifExpr);
        }

        public static /* synthetic */ Context copy$default(Context context, RsBinaryOp rsBinaryOp, LogicOp logicOp, RsExpr rsExpr, RsIfExpr rsIfExpr, int n, Object object) {
            if ((n & 1) != 0) {
                rsBinaryOp = context.binaryOp;
            }
            if ((n & 2) != 0) {
                logicOp = context.operatorType;
            }
            if ((n & 4) != 0) {
                rsExpr = context.conditionExpr;
            }
            if ((n & 8) != 0) {
                rsIfExpr = context.ifExpr;
            }
            return context.copy(rsBinaryOp, logicOp, rsExpr, rsIfExpr);
        }

        @NotNull
        public String toString() {
            return "Context(binaryOp=" + this.binaryOp + ", operatorType=" + this.operatorType + ", conditionExpr=" + this.conditionExpr + ", ifExpr=" + this.ifExpr + ")";
        }

        public int hashCode() {
            int result2 = this.binaryOp.hashCode();
            result2 = result2 * 31 + this.operatorType.hashCode();
            result2 = result2 * 31 + this.conditionExpr.hashCode();
            result2 = result2 * 31 + this.ifExpr.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.binaryOp, (Object)context.binaryOp)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operatorType, (Object)context.operatorType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.conditionExpr, (Object)context.conditionExpr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ifExpr, (Object)context.ifExpr);
        }
    }
}

