/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.utils.BooleanExprSimplifier;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/intentions/SimplifyBooleanExpressionIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/lang/core/psi/RsExpr;", "<init>", "()V", "getText", "", "getFamilyName", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nSimplifyBooleanExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyBooleanExpressionIntention.kt\norg/rust/ide/intentions/SimplifyBooleanExpressionIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n9#2:36\n1#3:37\n*S KotlinDebug\n*F\n+ 1 SimplifyBooleanExpressionIntention.kt\norg/rust/ide/intentions/SimplifyBooleanExpressionIntention\n*L\n23#1:36\n*E\n"})
public final class SimplifyBooleanExpressionIntention
extends RsElementBaseIntentionAction<RsExpr> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.simplify.boolean.expression", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.simplify.boolean.expression", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public RsExpr findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        RsExpr rsExpr;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsExpr rsExpr2 = (RsExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsExpr.class, (boolean)true);
        if (rsExpr2 == null) return null;
        Sequence<PsiElement> sequence2 = PsiElementKt.getAncestors(rsExpr2);
        if (sequence2 == null) return null;
        Sequence sequence3 = SequencesKt.takeWhile(sequence2, SimplifyBooleanExpressionIntention::findApplicableContext$lambda$0);
        if (sequence3 == null) return null;
        Sequence sequence4 = SequencesKt.map((Sequence)sequence3, SimplifyBooleanExpressionIntention::findApplicableContext$lambda$1);
        if (sequence4 == null) return null;
        Sequence sequence5 = sequence4;
        Object var11_10 = null;
        for (Object e : sequence5) {
            RsExpr it2 = (RsExpr)e;
            boolean bl = false;
            if (!BooleanExprSimplifier.Companion.canBeSimplified(it2)) continue;
            var11_10 = e;
        }
        RsExpr rsExpr3 = var11_10;
        if (rsExpr3 == null) return null;
        RsExpr it3 = rsExpr = rsExpr3;
        boolean bl = false;
        if (!PsiModificationUtil.INSTANCE.canReplace(it3)) return null;
        RsExpr rsExpr4 = rsExpr;
        return rsExpr4;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull RsExpr ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsExpr rsExpr = new BooleanExprSimplifier(project).simplify(ctx);
        if (rsExpr == null) {
            return;
        }
        RsExpr simplified = rsExpr;
        ctx.replace(simplified);
    }

    private static final boolean findApplicableContext$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof RsExpr;
    }

    private static final RsExpr findApplicableContext$lambda$1(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return (RsExpr)it2;
    }
}

