/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.actions.macroExpansion.MacroExpansionViewDetails;
import org.rust.ide.actions.macroExpansion.MacroExpansionViewUtilsKt;
import org.rust.ide.actions.macroExpansion.RsShowMacroExpansionActionBase;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.macros.errors.GetMacroExpansionError;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKind;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J \u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0015J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/rust/ide/intentions/RsShowMacroExpansionIntentionBase;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;", "<init>", "()V", "expandRecursively", "", "getExpandRecursively", "()Z", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionName;", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "functionLikeMacroHandlingStrategy", "getFunctionLikeMacroHandlingStrategy", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "startInWriteAction", "invoke", "", "ctx", "showExpansion", "expansionDetails", "Lorg/rust/ide/actions/macroExpansion/MacroExpansionViewDetails;", "showError", "error", "Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "intellij.rustrover.core"})
public abstract class RsShowMacroExpansionIntentionBase
extends RsElementBaseIntentionAction<RsPossibleMacroCall> {
    protected abstract boolean getExpandRecursively();

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @NotNull
    public InvokeInside getFunctionLikeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public RsPossibleMacroCall findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement possiblyExpandedElement = RsExpandedElementKt.findExpansionElementOrSelf(element);
        RsPossibleMacroCall rsPossibleMacroCall = RsPossibleMacroCallKt.getContextMacroCall(possiblyExpandedElement);
        if (rsPossibleMacroCall == null) {
            return null;
        }
        RsPossibleMacroCall macroCall = rsPossibleMacroCall;
        RsPossibleMacroCallKind kind2 = RsPossibleMacroCallKt.getKind(macroCall);
        if (kind2 instanceof RsPossibleMacroCallKind.MacroCall) {
            RsPath rsPath = ((RsPossibleMacroCallKind.MacroCall)kind2).getCall().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"<get-path>(...)");
            bl = PsiElementKt.isContextOf(rsPath, possiblyExpandedElement) || Intrinsics.areEqual((Object)possiblyExpandedElement, (Object)((RsPossibleMacroCallKind.MacroCall)kind2).getCall().getExcl());
        } else if (kind2 instanceof RsPossibleMacroCallKind.MetaItem) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isValidContext = bl;
        if (!isValidContext) {
            return null;
        }
        return macroCall;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull RsPossibleMacroCall ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsResult<MacroExpansionViewDetails, GetMacroExpansionError> expansionDetails = MacroExpansionViewUtilsKt.expandMacroForViewWithProgress(project, ctx, this.getExpandRecursively());
        if (expansionDetails instanceof RsResult.Ok) {
            this.showExpansion(project, editor2, (MacroExpansionViewDetails)((RsResult.Ok)expansionDetails).getOk());
        } else if (expansionDetails instanceof RsResult.Err) {
            this.showError(editor2, (GetMacroExpansionError)((RsResult.Err)expansionDetails).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @VisibleForTesting
    protected void showExpansion(@NotNull Project project, @NotNull Editor editor2, @NotNull MacroExpansionViewDetails expansionDetails) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expansionDetails, (String)"expansionDetails");
        MacroExpansionViewUtilsKt.showMacroExpansionPopup(project, editor2, expansionDetails);
    }

    private final void showError(Editor editor2, GetMacroExpansionError error) {
        RsShowMacroExpansionActionBase.Companion.showMacroExpansionError(editor2, error);
    }
}

