/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.experiments.RsExperiments;
import org.rust.ide.intentions.util.macros.IntentionInMacroUtil;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsFormatMacroArgument;
import org.rust.lang.core.psi.RsMacroArgument;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u0005\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u0006!"}, d2={"Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Ctx", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "<init>", "()V", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "invoke", "", "ctx", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Object;)V", "findTargetElement", "isInsideFunctionLikeMacroCall", "", "invokeInner", "invokeInsideMacroExpansion", "originalEditor", "originalFile", "Lcom/intellij/psi/PsiFile;", "expandedElement", "isAvailable", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "functionLikeMacroHandlingStrategy", "getFunctionLikeMacroHandlingStrategy", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsElementBaseIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsElementBaseIntentionAction.kt\norg/rust/ide/intentions/RsElementBaseIntentionAction\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,164:1\n15#2:165\n*S KotlinDebug\n*F\n+ 1 RsElementBaseIntentionAction.kt\norg/rust/ide/intentions/RsElementBaseIntentionAction\n*L\n86#1:165\n*E\n"})
public abstract class RsElementBaseIntentionAction<Ctx>
extends BaseElementAtCaretIntentionAction {
    @Nullable
    public abstract Ctx findApplicableContext(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiElement var3);

    public abstract void invoke(@NotNull Project var1, @NotNull Editor var2, Ctx var3);

    public final void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.startInWriteAction() && !PsiElementKt.isIntentionPreviewElement(element)) {
            UtilsKt.checkWriteAccessAllowed();
        }
        PsiElement psiElement2 = this.findTargetElement(element);
        if (psiElement2 == null) {
            return;
        }
        PsiElement possiblyExpandedElement = psiElement2;
        if (!Intrinsics.areEqual((Object)possiblyExpandedElement, (Object)element)) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            this.invokeInsideMacroExpansion(project, editor2, psiFile, possiblyExpandedElement);
            RsCounterUsagesCollector.INSTANCE.logIntentionCalled(project, (IntentionAction)this, this.isInsideFunctionLikeMacroCall(element));
        } else {
            this.invokeInner(project, editor2, element);
            RsCounterUsagesCollector.INSTANCE.logIntentionCalled(project, (IntentionAction)this, null);
        }
    }

    private final PsiElement findTargetElement(PsiElement element) {
        PsiElement psiElement2;
        List expandedElements = RsExpandedElementKt.findExpansionElements$default(element, null, 1, null);
        if (expandedElements == null) {
            psiElement2 = element;
        } else {
            InvokeInside strategy;
            boolean isFunctionLike = this.isInsideFunctionLikeMacroCall(element);
            InvokeInside invokeInside = strategy = isFunctionLike ? this.getFunctionLikeMacroHandlingStrategy() : this.getAttributeMacroHandlingStrategy();
            if (strategy == InvokeInside.MACRO_CALL) {
                return element;
            }
            if (isFunctionLike && !RsExperiments.INSTANCE.getINTENTIONS_IN_FN_LIKE_MACROS().asBoolean()) {
                return element;
            }
            psiElement2 = (PsiElement)CollectionsKt.singleOrNull((List)expandedElements);
        }
        return psiElement2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideFunctionLikeMacroCall(PsiElement $this$isInsideFunctionLikeMacroCall) {
        PsiElement $this$ancestorOrSelf$iv = $this$isInsideFunctionLikeMacroCall;
        boolean $i$f$ancestorOrSelf = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsMacroArgument.class, (boolean)false) != null) return true;
        $this$ancestorOrSelf$iv = $this$isInsideFunctionLikeMacroCall;
        $i$f$ancestorOrSelf = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsFormatMacroArgument.class, (boolean)false) == null) return false;
        return true;
    }

    private final void invokeInner(Project project, Editor editor2, PsiElement element) {
        Ctx Ctx = this.findApplicableContext(project, editor2, element);
        if (Ctx == null) {
            return;
        }
        Ctx ctx = Ctx;
        this.invoke(project, editor2, ctx);
    }

    private final void invokeInsideMacroExpansion(Project project, Editor originalEditor, PsiFile originalFile, PsiElement expandedElement) {
        IntentionInMacroUtil.INSTANCE.runActionInsideMacroExpansionCopy(project, originalEditor, originalFile, expandedElement, (arg_0, arg_1) -> RsElementBaseIntentionAction.invokeInsideMacroExpansion$lambda$0(this, project, arg_0, arg_1));
    }

    public final boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UtilsKt.checkReadAccessAllowed();
        PsiElement psiElement2 = this.findTargetElement(element);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement possiblyExpandedElement = psiElement2;
        if (!Intrinsics.areEqual((Object)possiblyExpandedElement, (Object)element)) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            bl = IntentionInMacroUtil.INSTANCE.doActionAvailabilityCheckInsideMacroExpansion(editor2, psiFile, possiblyExpandedElement, PsiElementKt.getStartOffset(possiblyExpandedElement) + (editor2.getCaretModel().getOffset() - PsiElementKt.getStartOffset(element)), (Function1<? super Editor, Boolean>)((Function1)arg_0 -> RsElementBaseIntentionAction.isAvailable$lambda$0(this, project, possiblyExpandedElement, arg_0)));
        } else {
            bl = this.findApplicableContext(project, editor2, possiblyExpandedElement) != null;
        }
        return bl;
    }

    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_EXPANSION;
    }

    @NotNull
    public InvokeInside getFunctionLikeMacroHandlingStrategy() {
        return InvokeInside.MACRO_EXPANSION;
    }

    private static final boolean invokeInsideMacroExpansion$lambda$0(RsElementBaseIntentionAction this$0, Project $project, Editor editorCopy, PsiElement expandedElementCopy) {
        Intrinsics.checkNotNullParameter((Object)editorCopy, (String)"editorCopy");
        Intrinsics.checkNotNullParameter((Object)expandedElementCopy, (String)"expandedElementCopy");
        this$0.invokeInner($project, editorCopy, expandedElementCopy);
        return true;
    }

    private static final boolean isAvailable$lambda$0(RsElementBaseIntentionAction this$0, Project $project, PsiElement $possiblyExpandedElement, Editor fakeEditor) {
        Intrinsics.checkNotNullParameter((Object)fakeEditor, (String)"fakeEditor");
        return this$0.findApplicableContext($project, fakeEditor, $possiblyExpandedElement) != null;
    }
}

