/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsAlias;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsUseGroup;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsUseGroupKt;
import org.rust.lang.core.stubs.common.RsPathPsiOrStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/intentions/RemoveCurlyBracesIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/RemoveCurlyBracesIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "Helper", "intellij.rustrover.core"})
public final class RemoveCurlyBracesIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.remove.curly.braces", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (PsiElement ancestor : PsiElementKt.getAncestors(element)) {
            RsUseSpeck speck;
            if ((ancestor instanceof RsUseSpeck ? (RsUseSpeck)ancestor : null) == null) continue;
            speck = speck;
            Context context = Helper.INSTANCE.createContextIfCompatible(speck);
            if (context == null) continue;
            return context;
        }
        return null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int caret = editor2.getCaretModel().getOffset();
        int newOffset = caret < PsiElementKt.getStartOffset(ctx.getUseGroup()) ? caret : (caret < PsiElementKt.getEndOffset(ctx.getUseGroup()) ? caret - 1 : caret - 2);
        Helper.INSTANCE.removeCurlyBracesFromUseSpeck(ctx);
        editor2.getCaretModel().moveToOffset(newOffset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/intentions/RemoveCurlyBracesIntention$Context;", "", "path", "Lorg/rust/lang/core/psi/RsPath;", "useGroup", "Lorg/rust/lang/core/psi/RsUseGroup;", "name", "", "<init>", "(Lorg/rust/lang/core/psi/RsPath;Lorg/rust/lang/core/psi/RsUseGroup;Ljava/lang/String;)V", "getPath", "()Lorg/rust/lang/core/psi/RsPath;", "getUseGroup", "()Lorg/rust/lang/core/psi/RsUseGroup;", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsPath path;
        @NotNull
        private final RsUseGroup useGroup;
        @NotNull
        private final String name;

        public Context(@NotNull RsPath path, @NotNull RsUseGroup useGroup, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)useGroup, (String)"useGroup");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.path = path;
            this.useGroup = useGroup;
            this.name = name2;
        }

        @NotNull
        public final RsPath getPath() {
            return this.path;
        }

        @NotNull
        public final RsUseGroup getUseGroup() {
            return this.useGroup;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final RsPath component1() {
            return this.path;
        }

        @NotNull
        public final RsUseGroup component2() {
            return this.useGroup;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final Context copy(@NotNull RsPath path, @NotNull RsUseGroup useGroup, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)useGroup, (String)"useGroup");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new Context(path, useGroup, name2);
        }

        public static /* synthetic */ Context copy$default(Context context, RsPath rsPath, RsUseGroup rsUseGroup, String string, int n, Object object) {
            if ((n & 1) != 0) {
                rsPath = context.path;
            }
            if ((n & 2) != 0) {
                rsUseGroup = context.useGroup;
            }
            if ((n & 4) != 0) {
                string = context.name;
            }
            return context.copy(rsPath, rsUseGroup, string);
        }

        @NotNull
        public String toString() {
            return "Context(path=" + this.path + ", useGroup=" + this.useGroup + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.useGroup.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)context.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.useGroup, (Object)context.useGroup)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)context.name);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/intentions/RemoveCurlyBracesIntention$Helper;", "", "<init>", "()V", "createContextIfCompatible", "Lorg/rust/ide/intentions/RemoveCurlyBracesIntention$Context;", "useSpeck", "Lorg/rust/lang/core/psi/RsUseSpeck;", "removeCurlyBracesFromUseSpeck", "", "ctx", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        @Nullable
        public final Context createContextIfCompatible(@NotNull RsUseSpeck useSpeck) {
            Intrinsics.checkNotNullParameter((Object)useSpeck, (String)"useSpeck");
            RsUseGroup rsUseGroup = useSpeck.getUseGroup();
            if (rsUseGroup == null) {
                return null;
            }
            RsUseGroup useGroup = rsUseGroup;
            RsPath rsPath = useSpeck.getPath();
            if (rsPath == null) {
                return null;
            }
            RsPath path = rsPath;
            Object object = RsUseGroupKt.getAsTrivial(useGroup);
            if (object == null || (object = object.getText()) == null) {
                return null;
            }
            Object name2 = object;
            if (!PsiModificationUtil.INSTANCE.canReplace(useGroup)) {
                return null;
            }
            return new Context(path, useGroup, (String)name2);
        }

        public final void removeCurlyBracesFromUseSpeck(@NotNull Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            RsPath path = ctx.component1();
            RsUseGroup useGroup = ctx.component2();
            String name2 = ctx.component3();
            Project project = useGroup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsUseSpeck newUseSpeck = new RsPsiFactory(project, false, false, 6, null).createUseSpeck("dummy::" + name2);
            RsPath rsPath = newUseSpeck.getPath();
            if (rsPath == null) {
                return;
            }
            RsPath newPath = rsPath;
            RsPath newSubPath = (RsPath)RsPathKt.basePath((RsPathPsiOrStub)newPath);
            newSubPath.replace(path.copy());
            path.replace(newPath);
            PsiElement psiElement2 = RsUseGroupKt.getParentUseSpeck(useGroup).getColoncolon();
            if (psiElement2 != null) {
                psiElement2.delete();
            }
            RsAlias alias = newUseSpeck.getAlias();
            if (alias != null) {
                useGroup.replace(alias.copy());
            } else {
                useGroup.delete();
            }
        }
    }
}

